/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyAdapter;

public abstract class PropertyBean
extends PropertyAdapter
implements IPropertyControl {
    private final List<PropertyChangeListener> mPropertyChangeListeners = new Vector<PropertyChangeListener>();
    private MouseClickListener mouseCliskListener;

    public PropertyBean(String name) {
        super(name);
    }

    public PropertyBean(String name, String label, String description) {
        super(name, label, description);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertyChangeListeners.add(listener);
    }

    public void fireOnMouseClick() {
        Component[] components;
        if (this.mouseCliskListener != null) {
            return;
        }
        this.mouseCliskListener = new MouseClickListener();
        for (Component c : components = this.getComponents()) {
            c.addMouseListener(this.mouseCliskListener);
        }
    }

    protected void firePropertyChangeEvent() {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, this.getName(), null, this.getValue());
        for (PropertyChangeListener l : this.mPropertyChangeListeners) {
            l.propertyChange(evt);
        }
    }

    public abstract String getValue();

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertyChangeListeners.remove(listener);
    }

    public abstract void setValue(String var1);

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + "->" + this.getValue() + ")";
    }

    protected abstract Component[] getComponents();

    private class MouseClickListener
    extends MouseAdapter {
        private MouseClickListener() {
        }

        public void mousePressed(MouseEvent e) {
            PropertyBean.this.firePropertyChangeEvent();
        }
    }
}

