/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.TextUtils;

public class PropertyAdapter {
    private String description;
    private String label;
    private final String name;

    void setLabel(String label) {
        this.label = label;
    }

    public PropertyAdapter(String name) {
        this(name, "OptionPanel." + name, "OptionPanel." + name + ".tooltip");
        if (ResourceController.getResourceController().getText(this.description, null) == null) {
            this.description = null;
        }
    }

    public PropertyAdapter(String name, String label, String description) {
        assert (name != null);
        this.name = name;
        this.label = label;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    protected void layout(DefaultFormBuilder builder, JComponent component) {
        JLabel label = builder.append(TextUtils.getOptionalText(this.getLabel()), (Component)component);
        String tooltip = TextUtils.getOptionalText(this.getDescription());
        label.setToolTipText(tooltip);
        component.setToolTipText(tooltip);
    }
}

