/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.OptionPanel;
import org.freeplane.core.resources.components.OptionPanelWindowConfigurationStorage;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;

public class PropertyAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final DefaultMutableTreeNode controls;

    public PropertyAction(DefaultMutableTreeNode controls) {
        super("PropertyAction");
        this.controls = controls;
    }

    public void actionPerformed(ActionEvent e) {
        Object source;
        Dialog dialog = null;
        if (e != null && (source = e.getSource()) instanceof Component) {
            Window window = SwingUtilities.getWindowAncestor((Component)source);
            if (window instanceof Dialog) {
                dialog = new JDialog((Dialog)window, true);
            } else if (window instanceof Frame) {
                dialog = new JDialog((Frame)window, true);
            }
        }
        if (dialog == null) {
            dialog = new JDialog(UITools.getFrame(), true);
        }
        dialog.setResizable(true);
        dialog.setUndecorated(false);
        final OptionPanel options = new OptionPanel((JDialog)dialog, new OptionPanel.IOptionPanelFeedback(){

            public void writeProperties(Properties props) {
                boolean propertiesChanged = false;
                for (Object keyObject : props.keySet()) {
                    String key = keyObject.toString();
                    String newProperty = props.getProperty(key);
                    propertiesChanged = propertiesChanged || !newProperty.equals(ResourceController.getResourceController().getProperty(key));
                    ResourceController.getResourceController().setProperty(key, newProperty);
                }
                if (propertiesChanged) {
                    JOptionPane.showMessageDialog(UITools.getFrame(), TextUtils.getText("option_changes_may_require_restart"));
                    ResourceController.getResourceController().saveProperties();
                }
            }
        });
        String marshalled = ResourceController.getResourceController().getProperty("OptionPanel_Window_Properties");
        OptionPanelWindowConfigurationStorage storage = OptionPanelWindowConfigurationStorage.decorateDialog(marshalled, (JDialog)dialog);
        if (storage != null) {
            options.setSelectedPanel(storage.getPanel());
        }
        options.buildPanel(this.controls);
        options.setProperties();
        String title = TextUtils.getText("PropertyAction.dialog");
        dialog.setTitle(title);
        ((JDialog)dialog).setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                options.closeWindow();
            }
        });
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                options.closeWindow();
            }
        };
        UITools.addEscapeActionToDialog((JDialog)dialog, action);
        if (storage == null) {
            UITools.setBounds(dialog, -1, -1, dialog.getPreferredSize().width + 50, -1);
        }
        dialog.setVisible(true);
    }

    public void afterMapChange(Object newMap) {
    }
}

