/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.TextUtils;

public class PathProperty
extends PropertyBean
implements IPropertyControl {
    private final boolean isDir;
    private final String[] suffixes;
    private String path;
    private JTextField filenameField;
    private JButton selectButton;

    public PathProperty(String name, boolean isDir, String[] suffixes) {
        super(name);
        this.isDir = isDir;
        this.suffixes = suffixes;
    }

    private JFileChooser createFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        if (this.path != null) {
            fileChooser.setSelectedFile(new File(this.path));
        }
        FileFilter filter = null;
        if (this.isDir) {
            fileChooser.setFileSelectionMode(1);
        } else if (this.suffixes != null) {
            filter = new FileFilter(){

                public String getDescription() {
                    return Arrays.asList(PathProperty.this.suffixes).toString();
                }

                public boolean accept(File f) {
                    String extension = FileUtils.getExtension(f);
                    for (String suffix : PathProperty.this.suffixes) {
                        if (!suffix.equalsIgnoreCase(extension)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        fileChooser.setFileFilter(filter);
        fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pE) {
                PathProperty.this.firePropertyChangeEvent();
            }
        });
        return fileChooser;
    }

    public String getValue() {
        return this.path;
    }

    public void layout(DefaultFormBuilder builder) {
        Box box = Box.createHorizontalBox();
        box.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.filenameField = new JTextField();
        this.filenameField.setText(this.path);
        this.filenameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                String text = PathProperty.this.filenameField.getText();
                if (text == null || text.length() == 0) {
                    PathProperty.this.filenameField.setText(PathProperty.this.path);
                    JOptionPane.showConfirmDialog(e.getComponent(), TextUtils.getText("OptionPanel.path_property_may_not_be_empty"), "", 2);
                } else {
                    PathProperty.this.path = text;
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        box.add(this.filenameField);
        box.add(Box.createHorizontalStrut(3));
        this.selectButton = new JButton();
        MenuBuilder.setLabelAndMnemonic(this.selectButton, TextUtils.getText("browse"));
        this.selectButton.addActionListener(new SelectFileAction());
        this.selectButton.setMaximumSize(new Dimension(1000, 1000));
        box.add(this.selectButton);
        this.layout(builder, box);
    }

    public void setEnabled(boolean enabled) {
        if (this.selectButton != null) {
            this.selectButton.setEnabled(enabled);
        }
        if (this.filenameField != null) {
            this.filenameField.setEnabled(enabled);
        }
    }

    public void setValue(String value) {
        this.path = value != null ? (value = value.replace("{freeplaneuserdir}", ResourceController.getResourceController().getFreeplaneUserDirectory())) : null;
        if (this.filenameField != null) {
            this.filenameField.setText(this.path);
        }
    }

    protected Component[] getComponents() {
        return new Component[]{this.filenameField, this.selectButton};
    }

    private class SelectFileAction
    implements ActionListener {
        private SelectFileAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser;
            int result;
            Object source = e.getSource();
            if (source == PathProperty.this.selectButton && (result = (chooser = PathProperty.this.createFileChooser()).showOpenDialog(chooser)) == 0) {
                PathProperty.this.setValue(chooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

