/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.IPropertyControlCreator;
import org.freeplane.core.resources.components.IValidator;
import org.freeplane.core.resources.components.OptionPanelBuilder;
import org.freeplane.core.resources.components.OptionPanelWindowConfigurationStorage;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.resources.components.TabProperty;
import org.freeplane.core.resources.components.VariableSizeCardLayout;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionPanel {
    private static final Color MARKED_BUTTON_COLOR = Color.BLUE;
    static final String PREFERENCE_STORAGE_PROPERTY = "OptionPanel_Window_Properties";
    private Vector<IPropertyControl> controls;
    private final IOptionPanelFeedback feedback;
    private String selectedPanel;
    private final HashMap<String, ChangeTabAction> tabActionMap = new HashMap();
    private final HashMap<String, JButton> tabButtonMap = new HashMap();
    private final JDialog topDialog;

    public OptionPanel(JDialog d, IOptionPanelFeedback feedback) {
        this.topDialog = d;
        this.feedback = feedback;
        new OptionPanelBuilder();
    }

    public void buildPanel(DefaultMutableTreeNode controlsTree) {
        FormLayout leftLayout = new FormLayout("max(80dlu;p):grow", "");
        DefaultFormBuilder leftBuilder = new DefaultFormBuilder(leftLayout);
        VariableSizeCardLayout cardLayout = new VariableSizeCardLayout();
        JPanel rightStack = new JPanel(cardLayout);
        FormLayout rightLayout = null;
        DefaultFormBuilder rightBuilder = null;
        String lastTabName = null;
        this.initControls(controlsTree);
        for (IPropertyControl control : this.controls) {
            if (control instanceof TabProperty) {
                TabProperty newTab = (TabProperty)control;
                if (rightBuilder != null) {
                    rightStack.add((Component)rightBuilder.getPanel(), lastTabName);
                }
                rightLayout = new FormLayout(newTab.getDescription(), "");
                rightBuilder = new DefaultFormBuilder(rightLayout);
                rightBuilder.setDefaultDialogBorder();
                lastTabName = newTab.getLabel();
                JButton tabButton = new JButton(TextUtils.getOptionalText(lastTabName));
                ChangeTabAction changeTabAction = new ChangeTabAction(cardLayout, rightStack, lastTabName);
                tabButton.addActionListener(changeTabAction);
                this.registerTabButton(tabButton, lastTabName, changeTabAction);
                leftBuilder.append((Component)tabButton);
                continue;
            }
            control.layout(rightBuilder);
        }
        rightStack.add((Component)rightBuilder.getPanel(), lastTabName);
        if (this.selectedPanel != null && this.tabActionMap.containsKey(this.selectedPanel)) {
            this.tabActionMap.get(this.selectedPanel).actionPerformed(null);
        }
        JScrollPane rightComponent = new JScrollPane(rightStack);
        UITools.setScrollbarIncrement(rightComponent);
        JSplitPane centralPanel = new JSplitPane(1, leftBuilder.getPanel(), rightComponent);
        this.topDialog.getContentPane().add((Component)centralPanel, "Center");
        JButton cancelButton = new JButton();
        MenuBuilder.setLabelAndMnemonic(cancelButton, TextUtils.getRawText("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                OptionPanel.this.closeWindow();
            }
        });
        JButton okButton = new JButton();
        MenuBuilder.setLabelAndMnemonic(okButton, TextUtils.getRawText("ok"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (OptionPanel.this.validate()) {
                    OptionPanel.this.closeWindow();
                    OptionPanel.this.feedback.writeProperties(OptionPanel.this.getOptionProperties());
                }
            }
        });
        this.topDialog.getRootPane().setDefaultButton(okButton);
        this.topDialog.getContentPane().add((Component)ButtonBarFactory.buildOKCancelBar((JButton)cancelButton, (JButton)okButton), "South");
    }

    private boolean validate() {
        Properties properties = this.getOptionProperties();
        IValidator.ValidationResult result = new IValidator.ValidationResult();
        for (IValidator validator : Controller.getCurrentController().getOptionValidators()) {
            result.add(validator.validate(properties));
        }
        if (!result.isValid()) {
            UITools.errorMessage(this.formatErrors("OptionPanel.validation_error", result.getErrors()));
            LogUtils.severe(result.toString());
        } else if (result.hasWarnings()) {
            UITools.informationMessage(this.formatErrors("OptionPanel.validation_warning", result.getWarnings()));
            LogUtils.warn(result.toString());
        }
        return result.isValid();
    }

    private String formatErrors(String key, ArrayList<String> errors) {
        MessageFormat formatter = new MessageFormat(TextUtils.getText(key));
        return formatter.format(new Object[]{StringUtils.join(errors.iterator(), (String)"<br>")});
    }

    private void initControls(DefaultMutableTreeNode controlsTree) {
        this.controls = new Vector();
        Enumeration<TreeNode> i = controlsTree.preorderEnumeration();
        while (i.hasMoreElements()) {
            IPropertyControlCreator creator = (IPropertyControlCreator)((DefaultMutableTreeNode)i.nextElement()).getUserObject();
            if (creator == null) continue;
            IPropertyControl control = creator.createControl();
            this.controls.add(control);
        }
    }

    public void closeWindow() {
        OptionPanelWindowConfigurationStorage storage = new OptionPanelWindowConfigurationStorage();
        storage.setPanel(this.selectedPanel);
        storage.storeDialogPositions(this.topDialog, PREFERENCE_STORAGE_PROPERTY);
        this.topDialog.setVisible(false);
        this.topDialog.dispose();
    }

    private Properties getOptionProperties() {
        Properties p = new Properties();
        for (IPropertyControl control : this.controls) {
            PropertyBean bean;
            String value;
            if (!(control instanceof PropertyBean) || (value = (bean = (PropertyBean)control).getValue()) == null) continue;
            p.setProperty(bean.getName(), value);
        }
        return p;
    }

    private JButton getTabButton(String name) {
        return this.tabButtonMap.get(name);
    }

    private void registerTabButton(JButton tabButton, String name, ChangeTabAction changeTabAction) {
        this.tabButtonMap.put(name, tabButton);
        this.tabActionMap.put(name, changeTabAction);
        if (this.selectedPanel == null) {
            this.selectedPanel = name;
        }
    }

    public void setProperties() {
        for (IPropertyControl control : this.controls) {
            if (!(control instanceof PropertyBean)) continue;
            PropertyBean bean = (PropertyBean)control;
            String name = bean.getName();
            String value = ResourceController.getResourceController().getProperty(name);
            bean.setValue(value);
        }
    }

    void setSelectedPanel(String panel) {
        this.selectedPanel = panel;
    }

    public static interface IOptionPanelFeedback {
        public void writeProperties(Properties var1);
    }

    private final class ChangeTabAction
    implements ActionListener {
        private final CardLayout cardLayout;
        private final JPanel centralPanel;
        private final String tabName;

        private ChangeTabAction(CardLayout cardLayout, JPanel centralPanel, String tabName) {
            this.cardLayout = cardLayout;
            this.centralPanel = centralPanel;
            this.tabName = tabName;
        }

        public void actionPerformed(ActionEvent arg0) {
            this.cardLayout.show(this.centralPanel, this.tabName);
            for (JButton button : OptionPanel.this.tabButtonMap.values()) {
                button.setForeground(null);
            }
            OptionPanel.this.getTabButton(this.tabName).setForeground(MARKED_BUTTON_COLOR);
            OptionPanel.this.selectedPanel = this.tabName;
        }
    }
}

