/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;

public class NumberProperty
extends PropertyBean
implements IPropertyControl {
    private final JSpinner spinner;
    private final boolean isDoubleProperty;

    public NumberProperty(String name, int min, int max, int step) {
        super(name);
        this.spinner = new JSpinner(new SpinnerNumberModel(min, min, max, step));
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent pE) {
                NumberProperty.this.firePropertyChangeEvent();
            }
        });
        this.isDoubleProperty = false;
    }

    public NumberProperty(String name, double min, double max, double step) {
        super(name);
        this.spinner = new JSpinner(new SpinnerNumberModel(min, min, max, step));
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent pE) {
                NumberProperty.this.firePropertyChangeEvent();
            }
        });
        this.isDoubleProperty = true;
    }

    public String getValue() {
        return this.spinner.getValue().toString();
    }

    public void layout(DefaultFormBuilder builder) {
        this.layout(builder, this.spinner);
    }

    public void setEnabled(boolean pEnabled) {
        this.spinner.setEnabled(pEnabled);
    }

    public void setValue(String value) {
        Number someValue;
        if (this.isDoubleProperty) {
            try {
                someValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                someValue = 1.0;
            }
        } else {
            try {
                someValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                someValue = 100;
            }
        }
        this.spinner.setValue(someValue);
    }

    protected Component[] getComponents() {
        return this.spinner.getComponents();
    }
}

