/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;

class KeyEventTranslator {
    static int c;
    static int a;
    static int m;
    static int s;
    private static Map<Key, Key> transMap;
    public static final boolean ALT_KEY_PRESSED_DISABLED = false;
    static int modifiers;

    KeyEventTranslator() {
    }

    public static String getModifierString(InputEvent evt) {
        StringBuilder buf = new StringBuilder();
        if (evt.isControlDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(2));
        }
        if (evt.isAltDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(8));
        }
        if (evt.isMetaDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(4));
        }
        if (evt.isShiftDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(1));
        }
        return buf.length() == 0 ? null : buf.toString();
    }

    public static String getSymbolicModifierName(int mod) {
        if ((mod & c) != 0) {
            return "control";
        }
        if ((mod & a) != 0) {
            return "alt";
        }
        if ((mod & m) != 0) {
            return "meta";
        }
        if ((mod & s) != 0) {
            return "shift";
        }
        return "";
    }

    public static String modifiersToString(int mods) {
        StringBuilder buf = null;
        if ((mods & 2) != 0) {
            buf = new StringBuilder();
            buf.append(KeyEventTranslator.getSymbolicModifierName(2));
        }
        if ((mods & 8) != 0) {
            if (buf == null) {
                buf = new StringBuilder();
            } else {
                buf.append(" ");
            }
            buf.append(KeyEventTranslator.getSymbolicModifierName(8));
        }
        if ((mods & 4) != 0) {
            if (buf == null) {
                buf = new StringBuilder();
            } else {
                buf.append(" ");
            }
            buf.append(KeyEventTranslator.getSymbolicModifierName(4));
        }
        if ((mods & 1) != 0) {
            if (buf == null) {
                buf = new StringBuilder();
            } else {
                buf.append(" ");
            }
            buf.append(KeyEventTranslator.getSymbolicModifierName(1));
        }
        if (buf == null) {
            return null;
        }
        return buf.toString();
    }

    public static void setModifierMapping(int c, int a, int m, int s) {
        int duplicateMapping = c & a | c & m | c & s | a & m | a & s | m & s;
        if ((duplicateMapping & 2) != 0) {
            throw new IllegalArgumentException("CTRL is mapped to more than one modifier");
        }
        if ((duplicateMapping & 8) != 0) {
            throw new IllegalArgumentException("ALT is mapped to more than one modifier");
        }
        if ((duplicateMapping & 4) != 0) {
            throw new IllegalArgumentException("META is mapped to more than one modifier");
        }
        if ((duplicateMapping & 1) != 0) {
            throw new IllegalArgumentException("SHIFT is mapped to more than one modifier");
        }
        KeyEventTranslator.c = c;
        KeyEventTranslator.a = a;
        KeyEventTranslator.m = m;
        KeyEventTranslator.s = s;
    }

    public static Key translateKeyEvent(KeyEvent evt) {
        int modifiers = evt.getModifiers();
        Key returnValue = null;
        switch (evt.getID()) {
            case 401: {
                int keyCode = evt.getKeyCode();
                if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90) {
                    returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), 0, Character.toUpperCase((char)keyCode));
                    break;
                }
                if (keyCode > 0 && keyCode <= 32 || keyCode == 127) {
                    evt.consume();
                    returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), keyCode, '\uffff');
                    break;
                }
                returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), keyCode, evt.getKeyChar());
                break;
            }
            default: {
                return null;
            }
        }
        Key trans = transMap.get(returnValue);
        if (trans == null) {
            return returnValue;
        }
        return trans;
    }

    static {
        transMap = new HashMap<Key, Key>();
        KeyEventTranslator.setModifierMapping(2, 8, 4, 1);
    }

    static class Key {
        public final char input;
        public final int key;
        public final String modifiers;

        public Key(String modifiers, int key, char input) {
            this.modifiers = modifiers;
            this.key = key;
            this.input = input;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                if (this.modifiers.equals(k.modifiers) && this.key == k.key && this.input == k.input) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.key + this.input;
        }

        public String toString() {
            return (this.modifiers == null ? "" : this.modifiers) + "<" + Integer.toString(this.key, 16) + "," + Integer.toString(this.input, 16) + ">";
        }
    }
}

