/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;

public class BooleanProperty
extends PropertyBean
implements IPropertyControl {
    JCheckBox mCheckBox = new JCheckBox();

    public BooleanProperty(String name) {
        super(name);
        this.mCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent pE) {
                BooleanProperty.this.firePropertyChangeEvent();
            }
        });
    }

    public String getValue() {
        return this.mCheckBox.isSelected() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
    }

    public void layout(DefaultFormBuilder builder) {
        this.layout(builder, this.mCheckBox);
    }

    public void setEnabled(boolean pEnabled) {
        this.mCheckBox.setEnabled(pEnabled);
    }

    public void setValue(String value) {
        boolean booleanValue = Boolean.parseBoolean(value);
        this.setValue(booleanValue);
    }

    public void setValue(boolean booleanValue) {
        this.mCheckBox.setSelected(booleanValue);
    }

    public boolean getBooleanValue() {
        return this.mCheckBox.isSelected();
    }

    protected Component[] getComponents() {
        return new Component[]{this.mCheckBox};
    }
}

