/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.collection.MultipleValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundles
extends ResourceBundle {
    public static final String LANGUAGE_AUTOMATIC = "automatic";
    private static final String DEFAULT_LANGUAGE = "en";
    public static final String POSTFIX_TRANSLATE_ME = "[translate me]";
    public static final String RESOURCE_LANGUAGE = "language";
    private final ResourceController controller;
    private Map<String, String> defaultResources;
    private final MultipleValueMap<String, URL> externalResources;
    private String lang;
    private Map<String, String> languageResources;
    private final boolean isUserDefined;

    ResourceBundles(ResourceController controller) {
        this.controller = controller;
        URL systemResource = this.getSystemResourceUrl(DEFAULT_LANGUAGE);
        this.isUserDefined = systemResource.getProtocol().equalsIgnoreCase("file");
        this.externalResources = new MultipleValueMap();
        try {
            this.loadLocalLanguageResources();
            this.defaultResources = this.lang.equals(DEFAULT_LANGUAGE) ? this.languageResources : this.getLanguageResources(DEFAULT_LANGUAGE);
        }
        catch (Exception ex) {
            LogUtils.severe(ex);
            LogUtils.severe("Error loading Resources");
        }
    }

    public void addResources(String language, Map<String, String> resources) {
        if (language.equalsIgnoreCase(DEFAULT_LANGUAGE)) {
            this.defaultResources.putAll(resources);
        } else if (language.equalsIgnoreCase(this.lang)) {
            this.languageResources.putAll(resources);
        }
    }

    public void addResources(String language, URL url) {
        try {
            this.addResources(language, this.getLanguageResources(url));
            this.externalResources.put(language, url);
        }
        catch (IOException e) {
            LogUtils.severe(e);
        }
    }

    public Enumeration getKeys() {
        final Iterator<String> iterator = this.defaultResources.keySet().iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    public String getLanguageCode() {
        return this.lang;
    }

    public String getDefaultLanguageCode() {
        return DEFAULT_LANGUAGE;
    }

    private Map<String, String> getLanguageResources(String lang) throws IOException {
        URL systemResource = this.getSystemResourceUrl(lang);
        if (systemResource == null) {
            return null;
        }
        Map<String, String> resources = this.getLanguageResources(systemResource);
        Iterator<URL> iterator = this.externalResources.get(lang).iterator();
        while (iterator.hasNext()) {
            resources.putAll(this.getLanguageResources(iterator.next()));
        }
        return resources;
    }

    protected URL getSystemResourceUrl(String lang) {
        String resourceName = "/translations/Resources_" + lang + ".properties";
        URL systemResource = ResourceController.getResourceController().getResource(resourceName);
        return systemResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getLanguageResources(URL systemResource) throws IOException {
        HashMap<Object, Object> hashMap;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(systemResource.openStream());
            Properties bundle = new Properties();
            bundle.load(in);
            hashMap = new HashMap<Object, Object>(bundle);
        }
        catch (Throwable throwable) {
            FileUtils.silentlyClose(in);
            throw throwable;
        }
        FileUtils.silentlyClose(in);
        return hashMap;
    }

    public String getResourceString(String key) {
        String resourceString = this.getResourceString(key, key);
        if (resourceString == key) {
            if (this.isUserDefined) {
                System.out.println("missing key " + key);
            } else {
                System.err.println("missing key " + key);
            }
            return '[' + key + ']';
        }
        return resourceString;
    }

    public String getResourceString(String key, String resource) {
        String value = this.languageResources.get(key);
        if (value != null) {
            return value;
        }
        value = this.defaultResources.get(key);
        if (value != null) {
            return value + POSTFIX_TRANSLATE_ME;
        }
        return resource;
    }

    public String putResourceString(String key, String resource) {
        return this.languageResources.put(key, resource);
    }

    @Override
    protected Object handleGetObject(String key) {
        try {
            return this.languageResources.get(key);
        }
        catch (Exception ex) {
            LogUtils.severe("Warning - resource string not found:" + key);
            return this.defaultResources.get(key) + POSTFIX_TRANSLATE_ME;
        }
    }

    private void loadLocalLanguageResources() throws IOException {
        this.lang = this.controller.getProperty(RESOURCE_LANGUAGE);
        if (this.lang == null || this.lang.equals(LANGUAGE_AUTOMATIC)) {
            String country = Locale.getDefault().getCountry();
            if (!country.equals("")) {
                this.lang = Locale.getDefault().getLanguage() + "_" + country;
                this.languageResources = this.getLanguageResources(this.lang);
                if (this.languageResources != null) {
                    LogUtils.info("language resources for " + this.lang + " found");
                    return;
                }
            }
            this.lang = Locale.getDefault().getLanguage();
            this.languageResources = this.getLanguageResources(this.lang);
            if (this.languageResources != null) {
                LogUtils.info("language resources for " + this.lang + " found");
                return;
            }
            LogUtils.info("language resources for " + this.lang + " not found");
        }
        if ("no".equals(this.lang)) {
            this.lang = "nb";
        }
        this.languageResources = this.getLanguageResources(this.lang);
        if (this.languageResources != null) {
            return;
        }
        LogUtils.info("language resources for " + this.lang + " not found");
        this.lang = DEFAULT_LANGUAGE;
        this.languageResources = this.getLanguageResources(this.lang);
        if (this.languageResources != null) {
            return;
        }
        LogUtils.severe("language resources for " + this.lang + " not found, aborting");
        System.exit(1);
    }

    public void loadAnotherLanguage() {
        try {
            if (!this.lang.equals(this.controller.getProperty(RESOURCE_LANGUAGE))) {
                this.loadLocalLanguageResources();
            }
        }
        catch (IOException e) {
            LogUtils.severe(e);
        }
    }
}

