/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.freeplane.core.util.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedObject {
    private String name;
    private Object object;
    private Icon icon;
    private static ListCellRenderer listCellRenderer;

    public static NamedObject literal(String literal) {
        NamedObject result = new NamedObject();
        result.object = literal;
        result.name = literal;
        return result;
    }

    private NamedObject() {
    }

    public NamedObject(Object object, String name) {
        this.object = object;
        this.name = name;
    }

    public NamedObject(String object) {
        this.object = object;
        this.name = TextUtils.getText(object);
    }

    public Object getObject() {
        return this.object;
    }

    public boolean objectEquals(Object o) {
        return this.getObject().equals(o);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NamedObject)) {
            return false;
        }
        NamedObject nobj = (NamedObject)obj;
        return this.object.equals(nobj.object) && this.name.equals(nobj.name);
    }

    public int hashCode() {
        return 37 * this.object.hashCode() + this.name.hashCode();
    }

    public static String toKeyString(Object obj) {
        if (obj instanceof NamedObject) {
            return ((NamedObject)obj).getObject().toString();
        }
        return obj.toString();
    }

    public static NamedObject format(String value) {
        int separatorPos = value.indexOf(44);
        if (separatorPos == -1) {
            return new NamedObject(value);
        }
        String key = value.substring(0, separatorPos);
        String s1 = value.substring(separatorPos + 1);
        String text = TextUtils.format(key, s1);
        return new NamedObject(value, text);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public static ListCellRenderer getIconRenderer() {
        if (listCellRenderer == null) {
            listCellRenderer = new ListCellRenderer(){
                private ListCellRenderer delegate = new DefaultListCellRenderer();

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Icon icon;
                    Object renderedValue = value instanceof NamedObject ? ((icon = ((NamedObject)value).getIcon()) != null ? icon : value) : value;
                    return this.delegate.getListCellRendererComponent(list, renderedValue, index, isSelected, cellHasFocus);
                }
            };
        }
        return listCellRenderer;
    }

    public static NamedObject[] fromEnum(Class<? extends Enum<?>> enumeration) {
        return NamedObject.fromEnum(enumeration.getSimpleName() + ".", enumeration);
    }

    public static NamedObject[] fromEnum(String prefix, Class<? extends Enum<?>> enumeration) {
        Enum<?>[] enumConstants = enumeration.getEnumConstants();
        NamedObject[] objs = new NamedObject[enumConstants.length];
        int i = 0;
        for (Enum<?> value : enumConstants) {
            objs[i++] = new NamedObject(value, TextUtils.getText(prefix + value.toString()));
        }
        return objs;
    }
}

