/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.io.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.freeplane.n3.nanoxml.XMLElement;

class XMLWriter {
    private PrintWriter writer;

    public void flush() {
        this.writer.flush();
    }

    public XMLWriter(OutputStream stream) {
        this.writer = new PrintWriter(stream);
    }

    public XMLWriter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void endElement(String fullName, boolean prettyPrint) {
        this.writer.print("</" + fullName + '>');
        if (prettyPrint) {
            this.writer.println();
        }
    }

    protected void finalize() throws Throwable {
        this.flush();
        this.writer = null;
        super.finalize();
    }

    public void startElement(XMLElement xml) throws IOException {
        this.write(xml, false, 0, true, false);
    }

    public void write(String content) {
        this.writeEncoded(content, false, true);
    }

    public void write(XMLElement xml) throws IOException {
        this.write(xml, false, 0, true, true);
    }

    protected void write(XMLElement xml, boolean prettyPrint, int indent, boolean collapseEmptyElements, boolean endElement) throws IOException {
        if (prettyPrint) {
            for (int i = 0; i < indent; ++i) {
                this.writer.print(' ');
            }
        }
        if (xml.getName() == null) {
            if (xml.getContent() != null) {
                if (prettyPrint) {
                    this.writeEncoded(xml.getContent().trim(), false, false);
                    this.writer.println();
                } else {
                    this.writeEncoded(xml.getContent(), false, false);
                }
            }
        } else {
            String key;
            this.writer.print('<');
            String fullName = xml.getFullName();
            this.writer.print(fullName);
            Vector<String> nsprefixes = new Vector<String>();
            if (xml.getNamespace() != null) {
                if (xml.getName().equals(fullName)) {
                    this.writer.print(" xmlns=\"" + xml.getNamespace() + '\"');
                } else {
                    String prefix = fullName;
                    prefix = prefix.substring(0, prefix.indexOf(58));
                    nsprefixes.addElement(prefix);
                    this.writer.print(" xmlns:" + prefix);
                    this.writer.print("=\"" + xml.getNamespace() + "\"");
                }
            }
            Enumeration<String> enumAttributeNames = xml.enumerateAttributeNames();
            while (enumAttributeNames.hasMoreElements()) {
                String prefix;
                String namespace;
                key = enumAttributeNames.nextElement();
                int index = key.indexOf(58);
                if (index < 0 || (namespace = xml.getAttributeNamespace(key)) == null || nsprefixes.contains(prefix = key.substring(0, index))) continue;
                this.writer.print(" xmlns:" + prefix);
                this.writer.print("=\"" + namespace + '\"');
                nsprefixes.addElement(prefix);
            }
            enumAttributeNames = xml.enumerateAttributeNames();
            while (enumAttributeNames.hasMoreElements()) {
                key = enumAttributeNames.nextElement();
                String value = xml.getAttribute(key, null);
                this.writer.print(" " + key + "=\"");
                this.writeEncoded(value, true, false);
                this.writer.print('\"');
            }
            if (xml.getContent() != null && xml.getContent().length() > 0) {
                this.writer.print('>');
                this.writeEncoded(xml.getContent(), false, false);
                if (endElement) {
                    this.endElement(fullName, prettyPrint);
                }
            } else if (xml.hasChildren() || !collapseEmptyElements) {
                this.writer.print('>');
                if (prettyPrint) {
                    this.writer.println();
                }
                Enumeration<XMLElement> enumeration = xml.enumerateChildren();
                while (enumeration.hasMoreElements()) {
                    XMLElement child = enumeration.nextElement();
                    this.write(child, prettyPrint, indent + 4, collapseEmptyElements, true);
                }
                if (prettyPrint) {
                    for (int i = 0; i < indent; ++i) {
                        this.writer.print(' ');
                    }
                }
                if (endElement) {
                    this.endElement(fullName, prettyPrint);
                }
            } else {
                if (endElement) {
                    this.writer.print("/>");
                } else {
                    this.writer.print(">");
                }
                if (prettyPrint) {
                    this.writer.println();
                }
            }
        }
    }

    private void writeEncoded(String str, boolean atributeValue, boolean xmlInclude) {
        block8: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c > '~') {
                this.writer.print("&#x");
                this.writer.print(Integer.toString(c, 16));
                this.writer.print(';');
                continue;
            }
            if (xmlInclude) {
                this.writer.print(c);
                continue;
            }
            switch (c) {
                case '<': {
                    this.writer.print("&lt;");
                    continue block8;
                }
                case '>': {
                    this.writer.print("&gt;");
                    continue block8;
                }
                case '&': {
                    this.writer.print("&amp;");
                    continue block8;
                }
                case '\'': {
                    this.writer.print("&apos;");
                    continue block8;
                }
                case '\"': {
                    this.writer.print("&quot;");
                    continue block8;
                }
                case '\n': {
                    if (atributeValue) {
                        this.writer.print("&#xa;");
                        continue block8;
                    }
                    this.writer.print(c);
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        this.writer.print("&#x");
                        this.writer.print(Integer.toString(c, 16));
                        this.writer.print(';');
                        continue block8;
                    }
                    this.writer.print(c);
                }
            }
        }
    }
}

