/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.io;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IElementHandler;
import org.freeplane.core.io.IReadCompletionListener;
import org.freeplane.core.io.ListHashTable;
import org.freeplane.features.map.NodeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadManager {
    private final Hashtable<String, Hashtable<String, IAttributeHandler>> attributeHandlers;
    private final ListHashTable<String, IElementHandler> elementHandlers = new ListHashTable();
    private final Collection<IReadCompletionListener> readCompletionListeners;

    public ReadManager() {
        this.attributeHandlers = new Hashtable();
        this.readCompletionListeners = new LinkedList<IReadCompletionListener>();
    }

    public void addAttributeHandler(String parentTag, String attributeName, IAttributeHandler a) {
        Hashtable<String, IAttributeHandler> tagHandlers = this.attributeHandlers.get(parentTag);
        if (tagHandlers == null) {
            tagHandlers = new Hashtable();
            this.attributeHandlers.put(parentTag, tagHandlers);
        }
        if (null != tagHandlers.put(attributeName, a)) {
            throw new RuntimeException("attribute handler " + parentTag + ", " + attributeName + " already registered");
        }
    }

    public void addElementHandler(String parentTag, IElementHandler handler) {
        this.elementHandlers.add(parentTag, handler);
    }

    public void addReadCompletionListener(IReadCompletionListener listener) {
        this.readCompletionListeners.add(listener);
    }

    public Hashtable<String, Hashtable<String, IAttributeHandler>> getAttributeHandlers() {
        return this.attributeHandlers;
    }

    public ListHashTable<String, IElementHandler> getElementHandlers() {
        return this.elementHandlers;
    }

    public void readingCompleted(NodeModel topNode, Map<String, String> newIds) {
        Iterator<IReadCompletionListener> iterator = this.readCompletionListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().readingCompleted(topNode, newIds);
        }
    }

    public void removeAttributeHandler(String parentTag, String attributeName, IAttributeHandler a) {
        Hashtable<String, IAttributeHandler> hashtable = this.attributeHandlers.get(parentTag);
        hashtable.remove(attributeName);
    }

    public void removeElementHandler(String parentTag, IElementHandler handler) {
        boolean removed = this.elementHandlers.remove(parentTag, handler);
        assert (removed);
    }

    public void removeReadCompletionListener(IReadCompletionListener listener) {
        boolean removed = this.readCompletionListeners.remove(listener);
        assert (removed);
    }
}

