/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.extension;

import java.util.Iterator;
import java.util.Map;
import org.freeplane.core.extension.IExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionContainer {
    private final Map<Class<? extends IExtension>, IExtension> extensions;

    public ExtensionContainer(Map<Class<? extends IExtension>, IExtension> extensions) {
        this.extensions = extensions;
    }

    public void addExtension(Class<? extends IExtension> clazz, IExtension extension) {
        assert (clazz.isAssignableFrom(extension.getClass()));
        IExtension oldExtension = this.getExtensions().put(clazz, extension);
        if (oldExtension != null && !oldExtension.equals(extension)) {
            this.getExtensions().put(clazz, oldExtension);
            throw new RuntimeException("extension of class " + clazz.getName() + " already registered");
        }
    }

    public void addExtension(IExtension extension) {
        this.addExtension(extension.getClass(), extension);
    }

    public IExtension putExtension(Class<? extends IExtension> clazz, IExtension extension) {
        IExtension oldExtension = this.getExtensions().put(clazz, extension);
        return oldExtension;
    }

    public IExtension putExtension(IExtension extension) {
        return this.putExtension(extension.getClass(), extension);
    }

    public boolean containsExtension(Class<? extends IExtension> clazz) {
        return this.extensions.containsKey(clazz);
    }

    public Iterator<IExtension> extensionIterator() {
        return this.getExtensions().values().iterator();
    }

    public <T extends IExtension> T getExtension(Class<T> clazz) {
        return (T)this.getExtensions().get(clazz);
    }

    public Map<Class<? extends IExtension>, IExtension> getExtensions() {
        return this.extensions;
    }

    public <T extends IExtension> T removeExtension(Class<T> clazz) {
        return (T)this.getExtensions().remove(clazz);
    }

    public boolean removeExtension(IExtension extension) {
        return this.getExtensions().remove(extension.getClass()) != null;
    }
}

