/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.imgscalr;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class Scalr {
    public static final boolean DEBUG;
    public static final String LOG_PREFIX = "[imgscalr] ";
    public static final ConvolveOp OP_ANTIALIAS;
    public static final int THRESHOLD_BALANCED_SPEED = 1600;
    public static final int THRESHOLD_QUALITY_BALANCED = 800;

    public static BufferedImage resize(BufferedImage src, int targetSize, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, Method.AUTOMATIC, Mode.AUTOMATIC, Rotation.NONE, targetSize, targetSize, ops);
    }

    public static BufferedImage resize(BufferedImage src, Rotation rotation, int targetSize, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, Method.AUTOMATIC, Mode.AUTOMATIC, rotation, targetSize, targetSize, ops);
    }

    public static BufferedImage resize(BufferedImage src, Method scalingMethod, int targetSize, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, scalingMethod, Mode.AUTOMATIC, Rotation.NONE, targetSize, targetSize, ops);
    }

    public static BufferedImage resize(BufferedImage src, Method scalingMethod, Rotation rotation, int targetSize, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, scalingMethod, Mode.AUTOMATIC, rotation, targetSize, targetSize, ops);
    }

    public static BufferedImage resize(BufferedImage src, Mode resizeMode, int targetSize, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, Method.AUTOMATIC, resizeMode, Rotation.NONE, targetSize, targetSize, ops);
    }

    public static BufferedImage resize(BufferedImage src, Mode resizeMode, Rotation rotation, int targetSize, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, Method.AUTOMATIC, resizeMode, rotation, targetSize, targetSize, ops);
    }

    public static BufferedImage resize(BufferedImage src, Method scalingMethod, Mode resizeMode, int targetSize, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, scalingMethod, resizeMode, Rotation.NONE, targetSize, targetSize, ops);
    }

    public static BufferedImage resize(BufferedImage src, Method scalingMethod, Mode resizeMode, Rotation rotation, int targetSize, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, scalingMethod, resizeMode, rotation, targetSize, targetSize, ops);
    }

    public static BufferedImage resize(BufferedImage src, int targetWidth, int targetHeight, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, Method.AUTOMATIC, Mode.AUTOMATIC, Rotation.NONE, targetWidth, targetHeight, ops);
    }

    public static BufferedImage resize(BufferedImage src, Rotation rotation, int targetWidth, int targetHeight, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, Method.AUTOMATIC, Mode.AUTOMATIC, rotation, targetWidth, targetHeight, ops);
    }

    public static BufferedImage resize(BufferedImage src, Method scalingMethod, int targetWidth, int targetHeight, BufferedImageOp ... ops) {
        return Scalr.resize(src, scalingMethod, Mode.AUTOMATIC, Rotation.NONE, targetWidth, targetHeight, ops);
    }

    public static BufferedImage resize(BufferedImage src, Method scalingMethod, Rotation rotation, int targetWidth, int targetHeight, BufferedImageOp ... ops) {
        return Scalr.resize(src, scalingMethod, Mode.AUTOMATIC, rotation, targetWidth, targetHeight, ops);
    }

    public static BufferedImage resize(BufferedImage src, Mode resizeMode, int targetWidth, int targetHeight, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, Method.AUTOMATIC, resizeMode, Rotation.NONE, targetWidth, targetHeight, ops);
    }

    public static BufferedImage resize(BufferedImage src, Mode resizeMode, Rotation rotation, int targetWidth, int targetHeight, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, Method.AUTOMATIC, resizeMode, rotation, targetWidth, targetHeight, ops);
    }

    public static BufferedImage resize(BufferedImage src, Method scalingMethod, Mode resizeMode, int targetWidth, int targetHeight, BufferedImageOp ... ops) throws IllegalArgumentException {
        return Scalr.resize(src, scalingMethod, resizeMode, Rotation.NONE, targetWidth, targetHeight, ops);
    }

    public static BufferedImage resize(BufferedImage src, Method scalingMethod, Mode resizeMode, Rotation rotation, int targetWidth, int targetHeight, BufferedImageOp ... ops) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("src cannot be null, a valid BufferedImage instance must be provided.");
        }
        if (scalingMethod == null) {
            throw new IllegalArgumentException("scalingMethod cannot be null. A good default value is Method.AUTOMATIC.");
        }
        if (resizeMode == null) {
            throw new IllegalArgumentException("resizeMode cannot be null. A good default value is Mode.AUTOMATIC.");
        }
        if (rotation == null) {
            throw new IllegalArgumentException("rotation cannot be null. A good default value is Rotation.NONE.");
        }
        if (targetWidth < 0) {
            throw new IllegalArgumentException("targetWidth must be >= 0");
        }
        if (targetHeight < 0) {
            throw new IllegalArgumentException("targetHeight must be >= 0");
        }
        BufferedImage result = null;
        long startTime = System.currentTimeMillis();
        if (ops != null && ops.length == 1 && ops[0] == null) {
            ops = null;
        }
        int currentWidth = src.getWidth();
        int currentHeight = src.getHeight();
        float ratio = (float)currentHeight / (float)currentWidth;
        if (DEBUG) {
            Scalr.log("START Resizing Source Image [size=%dx%d, mode=%s, orientation=%s, ratio(H/W)=%f] to [targetSize=%dx%d]", new Object[]{currentWidth, currentHeight, resizeMode, ratio <= 1.0f ? "Landscape/Square" : "Portrait", Float.valueOf(ratio), targetWidth, targetHeight});
        }
        if (ratio <= 1.0f && resizeMode == Mode.AUTOMATIC || resizeMode == Mode.FIT_TO_WIDTH) {
            if (targetWidth == src.getWidth()) {
                return src;
            }
            int originalTargetHeight = targetHeight;
            targetHeight = Math.round((float)targetWidth * ratio);
            if (DEBUG && originalTargetHeight != targetHeight) {
                Scalr.log("Auto-Corrected targetHeight [from=%d to=%d] to honor image proportions", originalTargetHeight, targetHeight);
            }
        } else {
            if (targetHeight == src.getHeight()) {
                return src;
            }
            int originalTargetWidth = targetWidth;
            targetWidth = Math.round((float)targetHeight / ratio);
            if (DEBUG && originalTargetWidth != targetWidth) {
                Scalr.log("Auto-Corrected targetWidth [from=%d to=%d] to honor image proportions", originalTargetWidth, targetWidth);
            }
        }
        if (scalingMethod == Method.AUTOMATIC) {
            scalingMethod = Scalr.determineScalingMethod(targetWidth, targetHeight, ratio);
        }
        if (DEBUG) {
            Scalr.log("Scaling Image to [size=%dx%d] using the %s method...", new Object[]{targetWidth, targetHeight, scalingMethod});
        }
        if (scalingMethod == Method.SPEED) {
            result = Scalr.scaleImage(src, targetWidth, targetHeight, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        } else if (scalingMethod == Method.BALANCED) {
            result = Scalr.scaleImage(src, targetWidth, targetHeight, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else if (scalingMethod == Method.QUALITY) {
            if (targetWidth > currentWidth || targetHeight > currentHeight) {
                Scalr.log("\tQUALITY Up-scale, single BICUBIC scaling will be used...", new Object[0]);
                result = Scalr.scaleImage(src, targetWidth, targetHeight, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            } else {
                Scalr.log("\tQUALITY Down-scale, incremental scaling will be used...", new Object[0]);
                result = Scalr.scaleImageIncrementally(src, targetWidth, targetHeight, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
        }
        if (ops != null && ops.length > 0) {
            if (DEBUG) {
                Scalr.log("Applying %d Image Ops to Result", ops.length);
            }
            for (BufferedImageOp op : ops) {
                if (op == null) continue;
                long opStartTime = System.currentTimeMillis();
                Rectangle2D dims = op.getBounds2D(result);
                BufferedImage dest = new BufferedImage((int)Math.round(dims.getWidth()), (int)Math.round(dims.getHeight()), result.getType());
                result = op.filter(result, dest);
                if (!DEBUG) continue;
                Scalr.log("\tOp Applied in %d ms, Resultant Image [width=%d, height=%d], Op: %s", System.currentTimeMillis() - opStartTime, result.getWidth(), result.getHeight(), op);
            }
        }
        if (rotation != Rotation.NONE) {
            if (DEBUG) {
                Scalr.log("Applying %s rotation to image...", new Object[]{rotation});
            }
            long rotStartTime = System.currentTimeMillis();
            int newWidth = result.getHeight();
            int newHeight = result.getWidth();
            AffineTransform tx = new AffineTransform();
            switch (rotation) {
                case CLOCKWISE: {
                    tx.translate(newWidth, 0.0);
                    tx.rotate(Math.toRadians(90.0));
                    break;
                }
                case COUNTER_CLOCKWISE: {
                    tx.translate(0.0, newHeight);
                    tx.rotate(Math.toRadians(-90.0));
                    break;
                }
                case FLIP: {
                    newWidth = result.getWidth();
                    newHeight = result.getHeight();
                    tx.translate(newWidth, newHeight);
                    tx.rotate(Math.toRadians(180.0));
                }
            }
            BufferedImage rotatedImage = new BufferedImage(newWidth, newHeight, result.getType());
            Graphics2D g2d = rotatedImage.createGraphics();
            g2d.drawImage(result, tx, null);
            g2d.dispose();
            result.flush();
            result = rotatedImage;
            if (DEBUG) {
                Scalr.log("\t%s Rotation Applied in %d ms, Resultant Image [width=%d, height=%d]", new Object[]{rotation, System.currentTimeMillis() - rotStartTime, result.getWidth(), result.getHeight()});
            }
        }
        if (DEBUG) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            Scalr.log("END Source Image Scaled from [%dx%d] to [%dx%d] and %d BufferedImageOp(s) Applied in %d ms", currentWidth, currentHeight, result.getWidth(), result.getHeight(), ops == null ? 0 : ops.length, elapsedTime);
        }
        return result;
    }

    protected static void log(String message, Object ... params) {
        if (DEBUG) {
            System.out.printf(LOG_PREFIX + message + '\n', params);
        }
    }

    protected static Method determineScalingMethod(int targetWidth, int targetHeight, float ratio) {
        int length = ratio <= 1.0f ? targetWidth : targetHeight;
        Method result = Method.SPEED;
        if (length <= 800) {
            result = Method.QUALITY;
        } else if (length <= 1600) {
            result = Method.BALANCED;
        }
        if (DEBUG) {
            Scalr.log("AUTOMATIC Scaling Method Selected [%s] for Image [size=%dx%d]", result.name(), targetWidth, targetHeight);
        }
        return result;
    }

    protected static BufferedImage scaleImage(BufferedImage src, int targetWidth, int targetHeight, Object interpolationHintValue) {
        int imageType = src.getTransparency() == 1 ? 1 : 2;
        BufferedImage result = new BufferedImage(targetWidth, targetHeight, imageType);
        Graphics2D resultGraphics = result.createGraphics();
        resultGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolationHintValue);
        resultGraphics.drawImage(src, 0, 0, targetWidth, targetHeight, null);
        resultGraphics.dispose();
        return result;
    }

    protected static BufferedImage scaleImageIncrementally(BufferedImage src, int targetWidth, int targetHeight, Object interpolationHintValue) {
        boolean hasReassignedSrc = false;
        int incrementCount = 0;
        int currentWidth = src.getWidth();
        int currentHeight = src.getHeight();
        do {
            if (currentWidth > targetWidth && (currentWidth /= 2) < targetWidth) {
                currentWidth = targetWidth;
            }
            if (currentHeight > targetHeight && (currentHeight /= 2) < targetHeight) {
                currentHeight = targetHeight;
            }
            BufferedImage incrementalImage = Scalr.scaleImage(src, currentWidth, currentHeight, interpolationHintValue);
            if (hasReassignedSrc) {
                src.flush();
            }
            src = incrementalImage;
            if (!hasReassignedSrc) {
                hasReassignedSrc = true;
            }
            ++incrementCount;
        } while (currentWidth != targetWidth || currentHeight != targetHeight);
        if (DEBUG) {
            Scalr.log("\tScaled Image in %d steps", incrementCount);
        }
        return src;
    }

    static {
        boolean debug = false;
        try {
            debug = Boolean.getBoolean("imgscalr.debug");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEBUG = debug;
        OP_ANTIALIAS = new ConvolveOp(new Kernel(3, 3, new float[]{0.0f, 0.08f, 0.0f, 0.08f, 0.68f, 0.08f, 0.0f, 0.08f, 0.0f}), 1, null);
        Scalr.log("Debug output ENABLED", new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Rotation {
        NONE,
        CLOCKWISE,
        COUNTER_CLOCKWISE,
        FLIP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        AUTOMATIC,
        FIT_TO_WIDTH,
        FIT_TO_HEIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        AUTOMATIC,
        SPEED,
        BALANCED,
        QUALITY;

    }
}

