/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.imgscalr;

import com.thebuzzmedia.imgscalr.Scalr;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncScalr {
    public static final int DEFAULT_THREAD_COUNT = 2;
    private static ExecutorService service;

    public static ExecutorService getService() {
        return service;
    }

    public static void setService(ExecutorService service) throws IllegalArgumentException {
        if (service == null) {
            throw new IllegalArgumentException("service cannot be null; it must be a valid ExecutorService that can execute Callable tasks created by this class.");
        }
        if (AsyncScalr.service != null) {
            AsyncScalr.service.shutdown();
        }
        AsyncScalr.service = service;
    }

    public static void setServiceThreadCount(int threadCount) throws IllegalArgumentException {
        if (threadCount < 1) {
            throw new IllegalArgumentException("threadCount [" + threadCount + "] must be > 0.");
        }
        if (service instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)service;
            tpe.setCorePoolSize(threadCount);
            tpe.setMaximumPoolSize(threadCount);
        } else {
            AsyncScalr.setService(Executors.newFixedThreadPool(threadCount));
        }
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final int targetSize, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, targetSize, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Rotation rotation, final int targetSize, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, rotation, targetSize, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Method scalingMethod, final int targetSize, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, scalingMethod, targetSize, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Method scalingMethod, final Scalr.Rotation rotation, final int targetSize, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, scalingMethod, rotation, targetSize, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Mode resizeMode, final int targetSize, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, resizeMode, targetSize, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Mode resizeMode, final Scalr.Rotation rotation, final int targetSize, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, resizeMode, rotation, targetSize, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Method scalingMethod, final Scalr.Mode resizeMode, final int targetSize, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, scalingMethod, resizeMode, targetSize, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Method scalingMethod, final Scalr.Mode resizeMode, final Scalr.Rotation rotation, final int targetSize, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, scalingMethod, resizeMode, rotation, targetSize, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final int targetWidth, final int targetHeight, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, targetWidth, targetHeight, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Rotation rotation, final int targetWidth, final int targetHeight, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, rotation, targetWidth, targetHeight, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Method scalingMethod, final int targetWidth, final int targetHeight, final BufferedImageOp ... ops) {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, scalingMethod, targetWidth, targetHeight, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Method scalingMethod, final Scalr.Rotation rotation, final int targetWidth, final int targetHeight, final BufferedImageOp ... ops) {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, scalingMethod, rotation, targetWidth, targetHeight, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Mode resizeMode, final int targetWidth, final int targetHeight, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, resizeMode, targetWidth, targetHeight, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Mode resizeMode, final Scalr.Rotation rotation, final int targetWidth, final int targetHeight, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, resizeMode, rotation, targetWidth, targetHeight, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Method scalingMethod, final Scalr.Mode resizeMode, final int targetWidth, final int targetHeight, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, scalingMethod, resizeMode, targetWidth, targetHeight, ops);
            }
        });
    }

    public static Future<BufferedImage> resize(final BufferedImage src, final Scalr.Method scalingMethod, final Scalr.Mode resizeMode, final Scalr.Rotation rotation, final int targetWidth, final int targetHeight, final BufferedImageOp ... ops) throws IllegalArgumentException {
        return service.submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return Scalr.resize(src, scalingMethod, resizeMode, rotation, targetWidth, targetHeight, ops);
            }
        });
    }

    static {
        AsyncScalr.setServiceThreadCount(2);
    }
}

