/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class ToggleComponentAction
extends DefaultSyntaxAction {
    private String componentName;

    public ToggleComponentAction() {
        super("toggle-component");
        this.putValue("SwingSelectedKey", Boolean.TRUE);
    }

    public void setComponent(String name) {
        this.componentName = name;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.componentName + ")";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (target instanceof JEditorPane) {
            JEditorPane jEditorPane = (JEditorPane)target;
            DefaultSyntaxKit kit = (DefaultSyntaxKit)jEditorPane.getEditorKit();
            boolean status = kit.toggleComponent(jEditorPane, this.componentName);
            this.putValue("SwingSelectedKey", status);
        }
    }
}

