/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.latex;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.latex.LatexExtension;
import org.freeplane.plugin.latex.LatexNodeHook;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

class LatexViewer
extends JComponent {
    static final int DEFAULT_FONT_SIZE = Math.round(10.0f * UITools.FONT_SCALE_FACTOR);
    static String editorTitle = null;
    private static final long serialVersionUID = 1L;
    private float zoom = 0.0f;
    private final LatexNodeHook nodeHook;
    private LatexExtension model;
    private TeXFormula teXFormula;

    LatexViewer(final LatexNodeHook nodeHook, LatexExtension latexExtension) {
        this.nodeHook = nodeHook;
        this.setModel(latexExtension);
        if (editorTitle == null) {
            editorTitle = TextUtils.getText((String)"plugins/latex/LatexNodeHook.editorTitle");
        }
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2 && Controller.getCurrentModeController().getModeName() == "MindMap") {
                    NodeModel node = null;
                    if (e.getSource().getClass() == LatexViewer.class) {
                        LatexViewer lv = (LatexViewer)e.getSource();
                        for (int i = 0; i < lv.getParent().getComponentCount(); ++i) {
                            if (!(lv.getParent().getComponent(i) instanceof MainView)) continue;
                            MainView mv = (MainView)lv.getParent().getComponent(i);
                            node = mv.getNodeView().getModel();
                            break;
                        }
                        if (node == null) {
                            node = Controller.getCurrentModeController().getMapController().getSelectedNode();
                        }
                        nodeHook.editLatexInEditor(node);
                        e.consume();
                        return;
                    }
                }
            }
        });
    }

    private void calculateSize() {
        MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, this);
        float mapZoom = mapView.getZoom();
        if (mapZoom == this.zoom) {
            return;
        }
        this.zoom = mapZoom;
        TeXIcon latexIcon = this.teXFormula.createTeXIcon(0, (float)DEFAULT_FONT_SIZE * this.zoom);
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(latexIcon.getIconWidth() + insets.left + insets.right, latexIcon.getIconHeight() + insets.top + insets.bottom);
        this.setPreferredSize(dimension);
    }

    public void paint(Graphics g) {
        TeXIcon latexIcon = this.teXFormula.createTeXIcon(0, (float)DEFAULT_FONT_SIZE * this.zoom);
        Insets insets = this.getInsets();
        latexIcon.paintIcon(this, g, insets.left, insets.top);
        super.paint(g);
    }

    public void setModel(LatexExtension latexExtension) {
        this.model = latexExtension;
        try {
            this.teXFormula = new TeXFormula("\\begin{array}{l} \\raisebox{0}{ " + this.model.getEquation() + " } \\end{array}");
            this.teXFormula.createTeXIcon(0, (float)DEFAULT_FONT_SIZE);
        }
        catch (Exception e) {
            try {
                this.teXFormula = new TeXFormula("\\mbox{" + e.getMessage() + "}");
                this.teXFormula.createTeXIcon(0, (float)DEFAULT_FONT_SIZE);
            }
            catch (Exception e1) {
                this.teXFormula = new TeXFormula("\\mbox{Can not parse given equation}");
            }
        }
        this.zoom = 0.0f;
        this.revalidate();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        this.calculateSize();
        return super.getPreferredSize();
    }
}

