/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.latex;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.text.AbstractContentTransformer;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.TransformationException;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.plugin.latex.LatexEditor;
import org.freeplane.plugin.latex.TeXText;
import org.scilab.forge.jlatexmath.TeXIcon;

public class LatexRenderer
extends AbstractContentTransformer
implements IEditBaseCreator {
    private static final String LATEX_EDITOR_FONT_SIZE = "latex_editor_font_size";
    private static final String LATEX_EDITOR_FONT = "latex_editor_font";
    private static final String LATEX = "\\latex";

    public LatexRenderer() {
        super(20);
    }

    public Object transformContent(TextController textController, Object content, NodeModel node, Object transformedExtension) throws TransformationException {
        return content;
    }

    private String getLatexNode(String nodeText, String nodeFormat, boolean includePrefix) {
        int startLength = LATEX.length() + 1;
        if (nodeText.length() > startLength && nodeText.startsWith(LATEX) && Character.isWhitespace(nodeText.charAt(startLength - 1))) {
            return includePrefix ? nodeText : nodeText.substring(startLength);
        }
        if ("latexPatternFormat".equals(nodeFormat)) {
            return nodeText;
        }
        return null;
    }

    public Icon getIcon(TextController textController, Object content, NodeModel node, Object transformedExtension) {
        if (transformedExtension == node.getUserObject()) {
            String string = content.toString();
            String nodeFormat = textController.getNodeFormat(node);
            if ("NO_FORMAT".equals(nodeFormat)) {
                return null;
            }
            String latext = this.getLatexNode(string, nodeFormat, false);
            if (latext == null) {
                return null;
            }
            NodeStyleController ncs = NodeStyleController.getController((ModeController)textController.getModeController());
            int maxWidth = ncs.getMaxWidth(node);
            TeXText teXt = new TeXText(latext);
            int fontSize = Math.round((float)ncs.getFontSize(node) * UITools.FONT_SCALE_FACTOR);
            TeXIcon icon = teXt.createTeXIcon(0, fontSize, 0, maxWidth);
            return icon;
        }
        return null;
    }

    public EditNodeBase createEditor(NodeModel node, EditNodeBase.IEditControl editControl, String text, boolean editLong) {
        MTextController textController = MTextController.getController();
        if (textController.isTextFormattingDisabled(node)) {
            return null;
        }
        KeyEvent firstKeyEvent = textController.getEventQueue().getFirstEvent();
        String nodeFormat = textController.getNodeFormat(node);
        String latexText = this.getLatexNode(text, nodeFormat, true);
        if (latexText != null) {
            JEditorPane textEditor = new JEditorPane();
            textEditor.putClientProperty("JEditorPane.honorDisplayProperties", true);
            JRestrictedSizeScrollPane scrollPane = new JRestrictedSizeScrollPane((Component)textEditor);
            scrollPane.setMinimumSize(new Dimension(0, 60));
            LatexEditor editNodeDialog = new LatexEditor(node, latexText, firstKeyEvent, editControl, false, textEditor);
            editNodeDialog.setTitle(TextUtils.getText((String)"latex_editor"));
            textEditor.setContentType("text/latex");
            String fontName = ResourceController.getResourceController().getProperty(LATEX_EDITOR_FONT);
            int fontSize = ResourceController.getResourceController().getIntProperty(LATEX_EDITOR_FONT_SIZE);
            textEditor.setFont(new Font(fontName, 0, fontSize));
            return editNodeDialog;
        }
        return null;
    }
}

