/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.latex;

import java.net.URL;
import java.util.Hashtable;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.main.osgi.IModeControllerExtensionProvider;
import org.freeplane.plugin.latex.LatexRegistration;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String PREFERENCES_RESOURCE = "preferences.xml";

    public void start(BundleContext context) throws Exception {
        this.registerMindMapModeExtension(context);
        this.registerBrowseModeExtension(context);
    }

    private void registerMindMapModeExtension(BundleContext context) {
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        props.put("mode", new String[]{"MindMap"});
        context.registerService(IModeControllerExtensionProvider.class.getName(), (Object)new IModeControllerExtensionProvider(){

            public void installExtension(ModeController modeController) {
                new LatexRegistration();
                this.addPreferencesToOptionPanel();
            }

            private void addPreferencesToOptionPanel() {
                URL preferences = this.getClass().getResource(Activator.PREFERENCES_RESOURCE);
                if (preferences == null) {
                    throw new RuntimeException("cannot open preferences");
                }
                Controller controller = Controller.getCurrentController();
                MModeController modeController = (MModeController)controller.getModeController();
                modeController.getOptionPanelBuilder().load(preferences);
            }
        }, props);
    }

    private void registerBrowseModeExtension(BundleContext context) {
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        props.put("mode", new String[]{"Browse"});
        context.registerService(IModeControllerExtensionProvider.class.getName(), (Object)new IModeControllerExtensionProvider(){

            public void installExtension(ModeController modeController) {
                new LatexRegistration();
            }
        }, props);
    }

    public void stop(BundleContext context) throws Exception {
    }
}

