/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JScrollPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.DoubleClickTimer;
import org.freeplane.core.ui.IEditHandler;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MouseArea;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.DefaultNodeMouseMotionListener;

public class MNodeMotionListener
extends DefaultNodeMouseMotionListener
implements IMouseListener {
    private Point dragStartingPoint = null;
    private int originalHGap;
    private int originalParentVGap;
    private int originalShiftY;
    private static final String EDIT_ON_DOUBLE_CLICK = "edit_on_double_click";

    Point getDragStartingPoint() {
        return this.dragStartingPoint;
    }

    private int getHGapChange(Point dragNextPoint, NodeModel node) {
        Controller controller = Controller.getCurrentController();
        MapView mapView = (MapView)controller.getMapViewManager().getMapViewComponent();
        int hGapChange = (int)((float)(dragNextPoint.x - this.dragStartingPoint.x) / mapView.getZoom());
        if (node.isLeft()) {
            hGapChange = -hGapChange;
        }
        return hGapChange;
    }

    private int getNodeShiftYChange(Point dragNextPoint, NodeModel node) {
        Controller controller = Controller.getCurrentController();
        MapView mapView = (MapView)controller.getMapViewManager().getMapViewComponent();
        int shiftYChange = (int)((float)(dragNextPoint.y - this.dragStartingPoint.y) / mapView.getZoom());
        return shiftYChange;
    }

    private NodeView getNodeView(MouseEvent e) {
        return ((MainView)e.getSource()).getNodeView();
    }

    private int getVGapChange(Point dragNextPoint, NodeModel node) {
        Controller controller = Controller.getCurrentController();
        MapView mapView = (MapView)controller.getMapViewManager().getMapViewComponent();
        int vGapChange = (int)((float)(dragNextPoint.y - this.dragStartingPoint.y) / mapView.getZoom());
        return vGapChange;
    }

    public boolean isDragActive() {
        return this.dragStartingPoint != null;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2 && this.doubleClickTimer.getDelay() > 0) {
            MainView mainView = (MainView)e.getComponent();
            if (mainView.getMouseArea().equals((Object)MouseArea.MOTION)) {
                Controller controller = Controller.getCurrentController();
                MLocationController locationController = (MLocationController)LocationController.getController(controller.getModeController());
                if (e.getModifiersEx() == 0) {
                    NodeView nodeV = this.getNodeView(e);
                    NodeModel node = nodeV.getModel();
                    locationController.moveNodePosition(node, LocationModel.getModel(node).getVGap(), 20, 0);
                    return;
                }
                if (Compat.isCtrlEvent(e)) {
                    NodeView nodeV = this.getNodeView(e);
                    NodeModel node = nodeV.getModel();
                    locationController.moveNodePosition(node, 3, LocationModel.getModel(node).getHGap(), LocationModel.getModel(node).getShiftY());
                    return;
                }
            } else if (Compat.isPlainEvent(e) && !this.isInFoldingRegion(e)) {
                MTextController textController = MTextController.getController();
                textController.getEventQueue().activate(e);
                textController.edit(IEditHandler.FirstAction.EDIT_CURRENT, false);
            }
        }
        super.mouseClicked(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.isDragActive()) {
            return;
        }
        MainView v = (MainView)e.getSource();
        if (v.isInDragRegion(e.getPoint())) {
            v.setMouseArea(MouseArea.MOTION);
            v.setCursor(Cursor.getPredefinedCursor(13));
            return;
        }
        super.mouseMoved(e);
    }

    public void mouseExited(MouseEvent e) {
        if (!this.isDragActive()) {
            super.mouseExited(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        MapView mapView = MapView.getMapView(e.getComponent());
        mapView.select();
        this.doubleClickTimer.cancel();
        this.setClickDelay();
        if (this.isInDragRegion(e)) {
            if ((e.getModifiersEx() & 0x400) == 1024) {
                this.nodeSelector.stopTimerForDelayedSelection();
                NodeView nodeV = this.getNodeView(e);
                Point point = e.getPoint();
                this.findGridPoint(point);
                UITools.convertPointToAncestor((Component)nodeV, point, JScrollPane.class);
                this.setDragStartingPoint(point, nodeV.getModel());
            }
        } else {
            super.mousePressed(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mouseDragged(MouseEvent e) {
        if (!this.isDragActive()) {
            return;
        }
        if ((e.getModifiersEx() & 0x400) != 1024) return;
        final MainView mainView = (MainView)e.getSource();
        NodeView nodeV = this.getNodeView(e);
        final MapView mapView = nodeV.getMap();
        Point point = e.getPoint();
        this.findGridPoint(point);
        UITools.convertPointToAncestor((Component)nodeV, point, JScrollPane.class);
        ModeController c = Controller.getCurrentController().getModeController();
        Point dragNextPoint = point;
        if (!Compat.isCtrlEvent(e)) {
            int shiftYChange;
            NodeModel node = nodeV.getModel();
            LocationModel locationModel = LocationModel.createLocationModel(node);
            int hGapChange = this.getHGapChange(dragNextPoint, node);
            if (hGapChange != 0) {
                locationModel.setHGap(this.originalHGap + hGapChange);
            }
            if ((shiftYChange = this.getNodeShiftYChange(dragNextPoint, node)) != 0) {
                locationModel.setShiftY(this.originalShiftY + shiftYChange);
            }
            if (hGapChange == 0 && shiftYChange == 0) return;
            c.getMapController().nodeRefresh(node);
        } else {
            NodeModel parentNode = nodeV.getVisibleParentView().getModel();
            int vGapChange = this.getVGapChange(dragNextPoint, parentNode);
            if (vGapChange == 0) return;
            LocationModel.createLocationModel(parentNode).setVGap(Math.max(0, this.originalParentVGap - vGapChange));
            MapController mapController = c.getMapController();
            mapController.nodeRefresh(parentNode);
            mapController.nodeRefresh(nodeV.getModel());
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Rectangle r = mainView.getBounds();
                UITools.convertRectangleToAncestor(mainView.getParent(), r, mapView);
                boolean isEventPointVisible = mapView.getVisibleRect().contains(r);
                if (!isEventPointVisible) {
                    mapView.scrollRectToVisible(r);
                }
            }
        });
    }

    private void findGridPoint(Point point) {
        int gridSize = ResourceController.getResourceController().getIntProperty("grid_size");
        if (gridSize <= 2) {
            return;
        }
        point.x -= point.x % gridSize;
        point.y -= point.y % gridSize;
    }

    public void mouseReleased(MouseEvent e) {
        MainView v = (MainView)e.getSource();
        if (!v.contains(e.getX(), e.getY())) {
            v.setMouseArea(MouseArea.OUT);
        }
        if (!this.isDragActive()) {
            super.mouseReleased(e);
            return;
        }
        NodeView nodeV = this.getNodeView(e);
        NodeModel node = nodeV.getModel();
        ModeController modeController = nodeV.getMap().getModeController();
        NodeModel parentNode = nodeV.getModel().getParentNode();
        int parentVGap = LocationModel.getModel(parentNode).getVGap();
        int hgap = LocationModel.getModel(node).getHGap();
        int shiftY = LocationModel.getModel(node).getShiftY();
        this.adjustNodeIndices(nodeV);
        this.resetPositions(node);
        Controller controller = modeController.getController();
        MLocationController locationController = (MLocationController)LocationController.getController(controller.getModeController());
        locationController.moveNodePosition(node, parentVGap, hgap, shiftY);
        this.stopDrag();
    }

    private void adjustNodeIndices(NodeView nodeV) {
        NodeModel[] selectedsBackup = null;
        NodeModel node = nodeV.getModel();
        if (FreeNode.isFreeNode(node)) {
            selectedsBackup = this.adjustNodeIndexBackupSelection(nodeV, selectedsBackup);
        } else {
            NodeModel[] siblingNodes;
            MapView map = nodeV.getMap();
            for (NodeModel sibling : siblingNodes = node.getParentNode().getChildren().toArray(new NodeModel[0])) {
                if (!FreeNode.isFreeNode(sibling)) continue;
                NodeView siblingV = map.getNodeView(sibling);
                selectedsBackup = this.adjustNodeIndexBackupSelection(siblingV, selectedsBackup);
            }
        }
        if (selectedsBackup != null) {
            ModeController modeController = nodeV.getMap().getModeController();
            Controller controller = modeController.getController();
            controller.getSelection().replaceSelection(selectedsBackup);
        }
    }

    private NodeModel[] adjustNodeIndexBackupSelection(NodeView nodeV, NodeModel[] selectedsBackup) {
        NodeModel node = nodeV.getModel();
        boolean isLeft = nodeV.isLeft();
        int newIndex = this.calculateNewNodeIndex(nodeV, isLeft, 0, node.getParentNode().getChildCount());
        if (newIndex != -1) {
            ModeController modeController = nodeV.getMap().getModeController();
            MMapController mapController = (MMapController)modeController.getMapController();
            if (selectedsBackup == null) {
                Collection<NodeModel> selecteds = mapController.getSelectedNodes();
                selectedsBackup = selecteds.toArray(new NodeModel[selecteds.size()]);
            }
            mapController.moveNode(node, node.getParentNode(), newIndex, isLeft, false);
        }
        return selectedsBackup;
    }

    public int getRefX(NodeView node) {
        return node.getContent().getX() + node.getContent().getWidth() / 2;
    }

    private int calculateNewNodeIndex(NodeView nodeV, boolean left, int start, int end) {
        int result;
        NodeModel node = nodeV.getModel();
        if (SummaryNode.isSummaryNode(node)) {
            return -1;
        }
        int nodeY = this.getRefY(nodeV);
        NodeView parent = nodeV.getParentView();
        int newIndex = 0;
        int oldIndex = -1;
        int wrondSideCount = 0;
        for (int i = start; i < end; ++i) {
            Component component = parent.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            NodeView sibling = (NodeView)component;
            if (sibling.isLeft() == left && !SummaryNode.isSummaryNode(sibling.getModel()) && this.getRefY(sibling) > nodeY) break;
            if (sibling != nodeV) {
                ++newIndex;
                if (sibling.isLeft() != left) {
                    ++wrondSideCount;
                    continue;
                }
                wrondSideCount = 0;
                continue;
            }
            oldIndex = i;
        }
        if ((result = newIndex - wrondSideCount) == oldIndex) {
            return -1;
        }
        return result;
    }

    private int getRefY(NodeView sibling) {
        return sibling.getY() + sibling.getContent().getY();
    }

    private void resetPositions(NodeModel node) {
        LocationModel locationModel = LocationModel.getModel(node.getParentNode());
        locationModel.setVGap(this.originalParentVGap);
        LocationModel.getModel(node).setHGap(this.originalHGap);
        LocationModel.getModel(node).setShiftY(this.originalShiftY);
    }

    void setDragStartingPoint(Point point, NodeModel node) {
        this.dragStartingPoint = point;
        if (point != null) {
            this.originalParentVGap = LocationModel.getModel(node.getParentNode()).getVGap();
            this.originalHGap = LocationModel.getModel(node).getHGap();
            this.originalShiftY = LocationModel.getModel(node).getShiftY();
        } else {
            this.originalShiftY = 0;
            this.originalHGap = 0;
            this.originalParentVGap = 0;
        }
    }

    private void stopDrag() {
        this.setDragStartingPoint(null, null);
    }

    private void setClickDelay() {
        if (ResourceController.getResourceController().getBooleanProperty(EDIT_ON_DOUBLE_CLICK)) {
            this.doubleClickTimer.setDelay(DoubleClickTimer.MAX_TIME_BETWEEN_CLICKS);
        } else {
            this.doubleClickTimer.setDelay(0);
        }
    }
}

