/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.clipboard.MindMapNodesSelection;
import org.freeplane.features.clipboard.mindmapmode.MClipboardController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

public class MNodeDropListener
implements DropTargetListener {
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent e) {
        Component draggedNode = e.getDropTargetContext().getComponent();
        ((MainView)draggedNode).setDraggedOver(0);
        draggedNode.repaint();
    }

    public void dragOver(DropTargetDragEvent e) {
        boolean repaint;
        MainView draggedNode = (MainView)e.getDropTargetContext().getComponent();
        int oldDraggedOver = draggedNode.getDraggedOver();
        draggedNode.setDraggedOver(e.getLocation());
        int newDraggedOver = draggedNode.getDraggedOver();
        boolean bl = repaint = newDraggedOver != oldDraggedOver;
        if (repaint) {
            draggedNode.repaint();
        }
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            int dropAction = dtde.getDropAction();
            Transferable t = dtde.getTransferable();
            MainView mainView = (MainView)dtde.getDropTargetContext().getComponent();
            NodeView targetNodeView = mainView.getNodeView();
            MapView mapView = targetNodeView.getMap();
            mapView.select();
            NodeModel targetNode = targetNodeView.getModel();
            Controller controller = Controller.getCurrentController();
            if (dtde.isLocalTransfer() && t.isDataFlavorSupported(MindMapNodesSelection.dropActionFlavor)) {
                String sourceAction = (String)t.getTransferData(MindMapNodesSelection.dropActionFlavor);
                if (sourceAction.equals("LINK")) {
                    dropAction = 0x40000000;
                }
                if (sourceAction.equals("COPY")) {
                    dropAction = 1;
                }
            }
            mainView.setDraggedOver(0);
            mainView.repaint();
            if (dtde.isLocalTransfer() && dropAction == 2 && !this.isDropAcceptable(dtde)) {
                dtde.rejectDrop();
                return;
            }
            boolean dropAsSibling = mainView.dropAsSibling(dtde.getLocation().getX());
            ModeController modeController = controller.getModeController();
            MMapController mapController = (MMapController)modeController.getMapController();
            if (dropAction == 2 || dropAction == 1) {
                NodeModel parent;
                NodeModel nodeModel = parent = dropAsSibling ? targetNode.getParentNode() : targetNode;
                if (!mapController.isWriteable(parent)) {
                    dtde.rejectDrop();
                    String message = TextUtils.getText("node_is_write_protected");
                    UITools.errorMessage(message);
                    return;
                }
            }
            boolean isLeft = mainView.dropLeft(dtde.getLocation().getX());
            if (!dtde.isLocalTransfer()) {
                dtde.acceptDrop(1);
                ((MClipboardController)ClipboardController.getController()).paste(t, targetNode, dropAsSibling, isLeft, dropAction);
                dtde.dropComplete(true);
                return;
            }
            dtde.acceptDrop(dropAction);
            if (dropAction == 0x40000000) {
                int yesorno = 0;
                if (controller.getSelection().size() >= 5) {
                    yesorno = JOptionPane.showConfirmDialog(controller.getViewController().getContentPane(), TextUtils.getText("lots_of_links_warning"), Integer.toString(controller.getSelection().size()) + " links to the same node", 0);
                }
                if (yesorno == 0) {
                    for (NodeModel selectedNodeModel : controller.getSelection().getSelection()) {
                        ((MLinkController)LinkController.getController(modeController)).addConnector(selectedNodeModel, targetNode);
                    }
                }
            } else {
                Transferable trans = null;
                Collection<NodeModel> selecteds = mapController.getSelectedNodes();
                if (2 == dropAction) {
                    NodeModel actualNode = targetNode;
                    do {
                        if (!selecteds.contains(actualNode)) continue;
                        String message = TextUtils.getText("cannot_move_to_child");
                        JOptionPane.showMessageDialog(controller.getViewController().getContentPane(), message, "Freeplane", 2);
                        dtde.dropComplete(true);
                        return;
                    } while ((actualNode = actualNode.isRoot() ? null : actualNode.getParentNode()) != null);
                    NodeModel[] array = selecteds.toArray(new NodeModel[selecteds.size()]);
                    List<NodeModel> sortedSelection = controller.getSelection().getSortedSelection(true);
                    for (NodeModel node : sortedSelection) {
                        boolean changeSide;
                        boolean bl = changeSide = isLeft != node.isLeft();
                        if (dropAsSibling) {
                            mapController.moveNodeBefore(node, targetNode, isLeft, changeSide);
                            continue;
                        }
                        mapController.moveNodeAsChild(node, targetNode, isLeft, changeSide);
                    }
                    if (dropAsSibling || !targetNode.isFolded()) {
                        controller.getSelection().replaceSelection(array);
                    } else {
                        controller.getSelection().selectAsTheOnlyOneSelected(targetNode);
                    }
                } else {
                    trans = ClipboardController.getController().copy(controller.getSelection());
                    ((MClipboardController)ClipboardController.getController()).paste(trans, targetNode, dropAsSibling, isLeft);
                    controller.getSelection().selectAsTheOnlyOneSelected(targetNode);
                }
            }
        }
        catch (Exception e) {
            LogUtils.severe("Drop exception:", e);
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private boolean isDragAcceptable(DropTargetDragEvent ev) {
        if (ev.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return true;
        }
        return ev.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor);
    }

    private boolean isDropAcceptable(DropTargetDropEvent event) {
        ModeController modeController;
        NodeModel selected;
        NodeModel node = ((MainView)event.getDropTargetContext().getComponent()).getNodeView().getModel();
        return node != (selected = (modeController = Controller.getCurrentController().getModeController()).getMapController().getSelectedNode()) && !node.isDescendantOf(selected);
    }
}

