/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.DefaultMapMouseListener;

public class MMapMouseListener
extends DefaultMapMouseListener {
    ConnectorModel draggedLink = null;
    private Point draggedLinkOldEndPoint;
    private Point draggedLinkOldStartPoint;

    public void mouseDragged(MouseEvent e) {
        MapView mapView = (MapView)e.getComponent();
        if (this.draggedLink != null && mapView.getLayoutType().equals((Object)MapViewLayout.MAP)) {
            Point changedInclination;
            int deltaX = (int)((float)(e.getX() - this.originX) / mapView.getZoom());
            int deltaY = (int)((float)(e.getY() - this.originY) / mapView.getZoom());
            double distSqToTarget = 0.0;
            double distSqToSource = 0.0;
            NodeModel target = this.draggedLink.getTarget();
            NodeView targetView = mapView.getNodeView(target);
            NodeView sourceView = mapView.getNodeView(this.draggedLink.getSource());
            if (targetView != null && sourceView != null) {
                Point targetLinkPoint = targetView.getLinkPoint(this.draggedLink.getEndInclination());
                Point sourceLinkPoint = sourceView.getLinkPoint(this.draggedLink.getStartInclination());
                distSqToTarget = targetLinkPoint.distanceSq(this.originX, this.originY);
                distSqToSource = sourceLinkPoint.distanceSq(this.originX, this.originY);
            }
            if ((targetView == null || sourceView != null) && distSqToSource <= distSqToTarget * 2.25) {
                changedInclination = this.draggedLink.getStartInclination();
                this.draggedLink.changeInclination(deltaX, deltaY, this.draggedLink.getSource(), changedInclination);
                this.draggedLink.setStartInclination(changedInclination);
            }
            if ((sourceView == null || targetView != null) && distSqToTarget <= distSqToSource * 2.25) {
                changedInclination = this.draggedLink.getEndInclination();
                this.draggedLink.changeInclination(deltaX, deltaY, target, changedInclination);
                this.draggedLink.setEndInclination(changedInclination);
            }
            this.originX = e.getX();
            this.originY = e.getY();
            mapView.repaintVisible();
        } else {
            super.mouseDragged(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (e.isPopupTrigger()) {
            return;
        }
        MapView mapView = (MapView)e.getComponent();
        Object object = mapView.detectCollision(new Point(this.originX, this.originY));
        if (object instanceof ConnectorModel) {
            ConnectorModel arrowLinkModel = (ConnectorModel)object;
            ConnectorModel.Shape shape = arrowLinkModel.getShape();
            if (ConnectorModel.Shape.EDGE_LIKE.equals((Object)shape) || ConnectorModel.Shape.LINE.equals((Object)shape) && !arrowLinkModel.isSelfLink()) {
                return;
            }
            this.draggedLink = arrowLinkModel;
            this.draggedLinkOldStartPoint = this.draggedLink.getStartInclination();
            this.draggedLinkOldEndPoint = this.draggedLink.getEndInclination();
            this.draggedLink.setShowControlPoints(true);
            mapView.repaintVisible();
        }
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.draggedLink != null) {
            this.draggedLink.setShowControlPoints(false);
            Point draggedLinkNewStartPoint = this.draggedLink.getStartInclination();
            Point draggedLinkNewEndPoint = this.draggedLink.getEndInclination();
            this.draggedLink.setStartInclination(this.draggedLinkOldStartPoint);
            this.draggedLink.setEndInclination(this.draggedLinkOldEndPoint);
            ((MLinkController)LinkController.getController(Controller.getCurrentController().getModeController())).setArrowLinkEndPoints(this.draggedLink, draggedLinkNewStartPoint, draggedLinkNewEndPoint);
            MapView mapView = (MapView)e.getComponent();
            mapView.repaintVisible();
            this.draggedLink = null;
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && Compat.isCtrlEvent(e)) {
            MapView mapView = (MapView)e.getComponent();
            Object object = mapView.detectCollision(new Point(this.originX, this.originY));
            if (object != null) {
                return;
            }
            ModeController modeController = Controller.getCurrentModeController();
            FreeNode freeNode = modeController.getExtension(FreeNode.class);
            if (freeNode != null && modeController instanceof MModeController) {
                boolean newNodeIsLeft;
                MainView rootContent = mapView.getRoot().getMainView();
                Point contentPt = new Point();
                UITools.convertPointToAncestor((Component)rootContent, contentPt, mapView);
                float zoom = mapView.getZoom();
                Point eventPoint = e.getPoint();
                int x = (int)((float)(eventPoint.x - contentPt.x) / zoom);
                int y = (int)((float)(eventPoint.y - contentPt.y) / zoom);
                int rootContentNormalWidth = (int)((float)rootContent.getWidth() / zoom);
                boolean bl = newNodeIsLeft = x < rootContentNormalWidth / 2;
                if (newNodeIsLeft) {
                    x = rootContentNormalWidth - x;
                }
                Point pt = new Point(x, y);
                ((MMapController)modeController.getMapController()).addFreeNode(pt, newNodeIsLeft);
            }
        } else {
            super.mouseClicked(e);
        }
    }
}

