/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.freeplane.core.ui.DelayedMouseListener;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.view.swing.ui.mindmapmode.GlassPaneNodeSelector;
import org.freeplane.view.swing.ui.mindmapmode.INodeSelector;

public class GlassPaneManager
implements AncestorListener {
    private final IMouseListener mouseListener;
    private final JRootPane rootPane;

    public GlassPaneManager(JRootPane jframe, INodeSelector nodeSelector) {
        this.mouseListener = new DelayedMouseListener(new GlassPaneNodeSelector(nodeSelector), 2, 1);
        this.rootPane = jframe;
    }

    public void ancestorRemoved(AncestorEvent event) {
        this.rootPane.getJMenuBar().setEnabled(true);
        Component glassPane = this.rootPane.getRootPane().getGlassPane();
        glassPane.removeMouseListener(this.mouseListener);
        glassPane.removeMouseMotionListener(this.mouseListener);
        glassPane.setVisible(false);
        SwingUtilities.getWindowAncestor(this.rootPane).setFocusableWindowState(true);
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorAdded(AncestorEvent event) {
        this.rootPane.getJMenuBar().setEnabled(false);
        Component glassPane = this.rootPane.getRootPane().getGlassPane();
        glassPane.addMouseListener(this.mouseListener);
        glassPane.addMouseMotionListener(this.mouseListener);
        glassPane.setVisible(true);
        SwingUtilities.getWindowAncestor(this.rootPane).setFocusableWindowState(false);
    }
}

