/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.mindmapmode;

import com.lightdev.app.shtm.SHTMLWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.html.ScaledEditorKit;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.EventBuffer;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.UrlManager;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.map.ZoomableLabelUI;
import org.freeplane.view.swing.map.mindmapmode.ExtendedEditorKit;

public class EditNodeTextField
extends EditNodeBase {
    private int extraWidth;
    private final boolean layoutMapOnTextChange;
    private static final int SPLIT_KEY_CODE;
    private JEditorPane textfield;
    private final DocumentListener documentListener;
    private int maxWidth;
    private final ZoomableLabel parent;
    private NodeView nodeView;
    private Font font;
    private float zoom;
    private final DefaultEditorKit.PasteAction pasteAction;
    private final StyledEditorKit.BoldAction boldAction;
    private final StyledEditorKit.ItalicAction italicAction;
    private final StyledEditorKit.UnderlineAction underlineAction;
    private final StyledEditorKit.ForegroundAction redAction;
    private final StyledEditorKit.ForegroundAction greenAction;
    private final StyledEditorKit.ForegroundAction blueAction;
    private final StyledEditorKit.ForegroundAction blackAction;
    private StyledEditorKit.StyledTextAction defaultColorAction;
    private StyledEditorKit.StyledTextAction removeFormattingAction;
    private int horizontalSpace;
    private int verticalSpace;
    private MapViewChangeListener mapViewChangeListener;

    private void layout() {
        if (this.textfield == null) {
            return;
        }
        int lastWidth = this.textfield.getWidth();
        int lastHeight = this.textfield.getHeight();
        boolean lineWrap = lastWidth == this.maxWidth;
        Dimension preferredSize = this.textfield.getPreferredSize();
        if (!lineWrap) {
            ++preferredSize.width;
            if (preferredSize.width > this.maxWidth) {
                this.setLineWrap();
                preferredSize = this.textfield.getPreferredSize();
            } else if (preferredSize.width < lastWidth) {
                preferredSize.width = lastWidth;
            } else {
                preferredSize.width = Math.min(preferredSize.width + this.extraWidth, this.maxWidth);
                if (preferredSize.width == this.maxWidth) {
                    this.setLineWrap();
                }
            }
        } else {
            preferredSize.width = Math.max(this.maxWidth, preferredSize.width);
        }
        if (preferredSize.width != lastWidth) {
            preferredSize.height = lastHeight;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditNodeTextField.this.layout();
                }
            });
        } else {
            preferredSize.height = Math.max(preferredSize.height, lastHeight);
        }
        if (preferredSize.width == lastWidth && preferredSize.height == lastHeight) {
            this.textfield.repaint();
            return;
        }
        this.textfield.setSize(preferredSize);
        if (this.layoutMapOnTextChange) {
            this.parent.setPreferredSize(new Dimension(preferredSize.width + this.horizontalSpace, preferredSize.height + this.verticalSpace));
        }
        this.textfield.revalidate();
        NodeView nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this.parent);
        MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, nodeView);
        if (mapView == null) {
            return;
        }
        if (this.layoutMapOnTextChange) {
            mapView.scrollNodeToVisible(nodeView);
        } else {
            mapView.scrollRectToVisible(this.textfield.getBounds());
        }
    }

    private void setLineWrap() {
        if (null != this.textfield.getClientProperty("EditNodeTextField.linewrap")) {
            return;
        }
        HTMLDocument document = (HTMLDocument)this.textfield.getDocument();
        document.getStyleSheet().addRule("body { width: " + (this.maxWidth - 1) + "}");
        this.textfield.setEditable(false);
        this.textfield.setEditable(true);
        this.textfield.putClientProperty("EditNodeTextField.linewrap", true);
    }

    public EditNodeTextField(NodeModel node, ZoomableLabel parent, String text, EditNodeBase.IEditControl editControl) {
        super(node, text, editControl);
        this.parent = parent;
        this.layoutMapOnTextChange = ResourceController.getResourceController().getBooleanProperty("layout_map_on_text_change");
        this.documentListener = new MyDocumentListener();
        this.pasteAction = new DefaultEditorKit.PasteAction(){

            public void actionPerformed(ActionEvent e) {
                JTextComponent target = this.getTextComponent(e);
                if (target == null) {
                    return;
                }
                Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                if (contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        String text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                        target.replaceSelection(text);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        };
        this.boldAction = new StyledEditorKit.BoldAction();
        this.boldAction.putValue("Name", TextUtils.getText("BoldAction.text"));
        this.boldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control B"));
        this.italicAction = new StyledEditorKit.ItalicAction();
        this.italicAction.putValue("Name", TextUtils.getText("ItalicAction.text"));
        this.italicAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control I"));
        this.underlineAction = new StyledEditorKit.UnderlineAction();
        this.underlineAction.putValue("Name", TextUtils.getText("UnderlineAction.text"));
        this.underlineAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control U"));
        this.redAction = new StyledEditorKit.ForegroundAction(TextUtils.getText("red"), Color.RED);
        this.redAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control R"));
        this.greenAction = new StyledEditorKit.ForegroundAction(TextUtils.getText("green"), Color.GREEN);
        this.greenAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control G"));
        this.blueAction = new StyledEditorKit.ForegroundAction(TextUtils.getText("blue"), Color.BLUE);
        this.blueAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control E"));
        this.blackAction = new StyledEditorKit.ForegroundAction(TextUtils.getText("black"), Color.BLACK);
        this.blackAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control K"));
        this.defaultColorAction = new ExtendedEditorKit.RemoveStyleAttributeAction(StyleConstants.Foreground, TextUtils.getText("DefaultColorAction.text"));
        this.defaultColorAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control D"));
        this.removeFormattingAction = new ExtendedEditorKit.RemoveStyleAttributeAction(null, TextUtils.getText("simplyhtml.clearFormatLabel"));
        this.removeFormattingAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control T"));
        if (editControl != null) {
            ModeController modeController = Controller.getCurrentModeController();
            MTextController textController = (MTextController)TextController.getController(modeController);
            this.textfield = textController.createEditorPane("NodeText");
            this.textfield.setNavigationFilter(new MyNavigationFilter(this.textfield));
        }
    }

    public String getNewText() {
        SHTMLWriter shtmlWriter = new SHTMLWriter((HTMLDocument)this.textfield.getDocument());
        try {
            shtmlWriter.write();
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
        return shtmlWriter.toString();
    }

    private void hideMe() {
        if (this.textfield == null) {
            return;
        }
        this.textfield.getDocument().removeDocumentListener(this.documentListener);
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        mapViewManager.removeMapViewChangeListener(this.mapViewChangeListener);
        this.mapViewChangeListener = null;
        this.parent.setPreferredSize(null);
        if (SwingUtilities.getAncestorOfClass(MapView.class, this.nodeView) != null) {
            this.nodeView.update();
        }
        if (this.nodeView.isRoot() && this.parent instanceof MainView) {
            this.parent.setHorizontalAlignment(0);
        }
        this.textfield.getParent().remove(this.textfield);
        this.parent.revalidate();
        this.parent.repaint();
        this.textfield = null;
    }

    protected JPopupMenu createPopupMenu(Component component) {
        JPopupMenu menu = super.createPopupMenu(component);
        JMenu formatMenu = new JMenu(TextUtils.getText("simplyhtml.formatLabel"));
        menu.add(formatMenu);
        if (this.textfield.getSelectionStart() == this.textfield.getSelectionEnd()) {
            formatMenu.setEnabled(false);
            return menu;
        }
        formatMenu.add(this.boldAction);
        formatMenu.add(this.italicAction);
        formatMenu.add(this.underlineAction);
        formatMenu.add(this.redAction);
        formatMenu.add(this.greenAction);
        formatMenu.add(this.blueAction);
        formatMenu.add(this.blackAction);
        formatMenu.add(this.defaultColorAction);
        formatMenu.add(this.removeFormattingAction);
        return menu;
    }

    public void show(RootPaneContainer frame) {
        ModeController modeController = Controller.getCurrentModeController();
        IMapViewManager viewController = modeController.getController().getMapViewManager();
        MTextController textController = (MTextController)TextController.getController(modeController);
        this.nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this.parent);
        this.font = this.parent.getFont();
        this.zoom = viewController.getZoom();
        if (this.zoom != 1.0f) {
            float fontSize = (int)Math.rint((float)this.font.getSize() * this.zoom);
            this.font = this.font.deriveFont(fontSize);
        }
        ScaledEditorKit kit = new ScaledEditorKit(){

            public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
                if (doc instanceof HTMLDocument) {
                    SHTMLWriter w = new SHTMLWriter(out, (HTMLDocument)doc, pos, len);
                    w.write();
                } else {
                    super.write(out, doc, pos, len);
                }
            }
        };
        this.textfield.setEditorKit(kit);
        InputMap inputMap = this.textfield.getInputMap();
        ActionMap actionMap = this.textfield.getActionMap();
        actionMap.put("paste-from-clipboard", this.pasteAction);
        inputMap.put((KeyStroke)this.boldAction.getValue("AcceleratorKey"), "boldAction");
        actionMap.put("boldAction", this.boldAction);
        inputMap.put((KeyStroke)this.italicAction.getValue("AcceleratorKey"), "italicAction");
        actionMap.put("italicAction", this.italicAction);
        inputMap.put((KeyStroke)this.underlineAction.getValue("AcceleratorKey"), "underlineAction");
        actionMap.put("underlineAction", this.underlineAction);
        inputMap.put((KeyStroke)this.redAction.getValue("AcceleratorKey"), "redAction");
        actionMap.put("redAction", this.redAction);
        inputMap.put((KeyStroke)this.greenAction.getValue("AcceleratorKey"), "greenAction");
        actionMap.put("greenAction", this.greenAction);
        inputMap.put((KeyStroke)this.blueAction.getValue("AcceleratorKey"), "blueAction");
        actionMap.put("blueAction", this.blueAction);
        inputMap.put((KeyStroke)this.blackAction.getValue("AcceleratorKey"), "blackAction");
        actionMap.put("blackAction", this.blackAction);
        inputMap.put((KeyStroke)this.defaultColorAction.getValue("AcceleratorKey"), "defaultColorAction");
        actionMap.put("defaultColorAction", this.defaultColorAction);
        inputMap.put((KeyStroke)this.removeFormattingAction.getValue("AcceleratorKey"), "removeFormattingAction");
        actionMap.put("removeFormattingAction", this.removeFormattingAction);
        Color nodeTextColor = this.parent.getForeground();
        this.textfield.setCaretColor(nodeTextColor);
        StringBuilder ruleBuilder = new StringBuilder(100);
        ruleBuilder.append("body {");
        ruleBuilder.append("font-family: ").append(this.font.getFamily()).append(";");
        int fontSize = Math.round((float)this.font.getSize() / UITools.FONT_SCALE_FACTOR);
        ruleBuilder.append("font-size: ").append(fontSize).append("pt;");
        if (this.font.isItalic()) {
            ruleBuilder.append("font-style: italic; ");
        }
        if (this.font.isBold()) {
            ruleBuilder.append("font-weight: bold; ");
        }
        ruleBuilder.append("color: ").append(ColorUtils.colorToString(nodeTextColor)).append(";");
        Color bgColor = this.getBackground();
        ruleBuilder.append("background-color: ").append(ColorUtils.colorToString(bgColor)).append(";");
        ruleBuilder.append("}\n");
        HTMLDocument document = (HTMLDocument)this.textfield.getDocument();
        StyleSheet styleSheet = document.getStyleSheet();
        styleSheet.addRule(ruleBuilder.toString());
        this.textfield.setText(this.text);
        MapView mapView = (MapView)viewController.getMapViewComponent();
        if (!mapView.isValid()) {
            mapView.validate();
        }
        NodeStyleController nsc = NodeStyleController.getController(modeController);
        this.maxWidth = nsc.getMaxWidth(this.node);
        Icon icon = this.parent.getIcon();
        if (icon != null) {
            this.maxWidth -= icon.getIconWidth();
            this.maxWidth -= this.parent.getIconTextGap();
        }
        this.maxWidth = mapView.getZoomed(this.maxWidth);
        this.extraWidth = ResourceController.getResourceController().getIntProperty("editor_extra_width", 80);
        this.extraWidth = mapView.getZoomed(this.extraWidth);
        TextFieldListener textFieldListener = new TextFieldListener();
        this.textFieldListener = textFieldListener;
        this.textfield.addFocusListener(textFieldListener);
        this.textfield.addKeyListener(textFieldListener);
        this.textfield.addMouseListener(textFieldListener);
        this.mapViewChangeListener = new MapViewChangeListener();
        Controller.getCurrentController().getMapViewManager().addMapViewChangeListener(this.mapViewChangeListener);
        SpellCheckerController.getController().enableAutoSpell(this.textfield, true);
        mapView.scrollNodeToVisible(this.nodeView);
        assert (this.parent.isValid());
        int nodeWidth = this.parent.getWidth();
        int nodeHeight = this.parent.getHeight();
        this.textfield.setBorder(new MatteBorder(2, 2, 2, 2, this.nodeView.getSelectedColor()));
        Dimension textFieldSize = this.textfield.getPreferredSize();
        ++textFieldSize.width;
        if (textFieldSize.width < this.extraWidth) {
            textFieldSize.width = this.extraWidth;
        }
        if (textFieldSize.width < 10) {
            textFieldSize.width = 10;
        }
        if (textFieldSize.width > this.maxWidth) {
            textFieldSize.width = this.maxWidth;
            this.setLineWrap();
            textFieldSize.height = this.textfield.getPreferredSize().height;
        }
        Rectangle textR = ((ZoomableLabelUI)this.parent.getUI()).getTextR(this.parent);
        textFieldSize.width = Math.max(textFieldSize.width, textR.width);
        textFieldSize.height = Math.max(textFieldSize.height, textR.height);
        this.textfield.setSize(textFieldSize.width, textFieldSize.height);
        this.horizontalSpace = Math.max(nodeWidth - textFieldSize.width, textR.x);
        this.verticalSpace = Math.max(nodeHeight - textFieldSize.height, textR.y);
        Dimension newParentSize = new Dimension(this.horizontalSpace + textFieldSize.width, this.verticalSpace + textFieldSize.height);
        this.parent.setPreferredSize(newParentSize);
        Point location = new Point(textR.x - 2, textR.y);
        if (!this.layoutMapOnTextChange) {
            UITools.convertPointToAncestor((Component)this.parent, location, mapView);
        }
        this.textfield.setBounds(location.x, location.y, textFieldSize.width, textFieldSize.height);
        this.parent.setText("");
        if (this.nodeView.isRoot() && this.parent instanceof MainView) {
            this.parent.setHorizontalAlignment(2);
        }
        if (this.layoutMapOnTextChange) {
            this.parent.add((Component)this.textfield, 0);
        } else {
            mapView.add((Component)this.textfield, 0);
        }
        EventBuffer eventQueue = MTextController.getController().getEventQueue();
        KeyEvent firstEvent = eventQueue.getFirstEvent();
        this.redispatchKeyEvents(this.textfield, firstEvent);
        if (firstEvent == null) {
            MouseEvent mouseEvent;
            MouseEvent currentEvent = eventQueue.getMouseEvent();
            int pos = document.getLength();
            if (currentEvent != null && (mouseEvent = currentEvent).getComponent().equals(this.parent)) {
                Point point = mouseEvent.getPoint();
                point.x -= textR.x;
                point.y -= textR.y;
                pos = this.textfield.viewToModel(point);
            }
            this.textfield.setCaretPosition(pos);
        }
        document.addDocumentListener(this.documentListener);
        if (textController.isMinimized(this.node)) {
            this.layout();
        }
        this.textfield.repaint();
        this.textfield.requestFocusInWindow();
    }

    static {
        char charAfterMnemoSign;
        String rawLabel = TextUtils.getRawText("split");
        int mnemoSignIndex = rawLabel.indexOf(38);
        SPLIT_KEY_CODE = mnemoSignIndex >= 0 && mnemoSignIndex + 1 < rawLabel.length() ? ((charAfterMnemoSign = rawLabel.charAt(mnemoSignIndex + 1)) != ' ' ? (int)charAfterMnemoSign : -1) : -1;
    }

    private class MapViewChangeListener
    implements IMapViewChangeListener {
        private MapViewChangeListener() {
        }

        public void afterViewChange(Component oldView, Component newView) {
        }

        public void afterViewClose(Component oldView) {
        }

        public void afterViewCreated(Component mapView) {
        }

        public void beforeViewChange(Component oldView, Component newView) {
            String output = EditNodeTextField.this.getNewText();
            EditNodeTextField.this.hideMe();
            EditNodeTextField.this.getEditControl().ok(output);
        }
    }

    private class TextFieldListener
    implements KeyListener,
    FocusListener,
    MouseListener {
        final int CANCEL = 2;
        final int EDIT = 1;
        Integer eventSource = 1;
        private boolean popupShown;

        private void conditionallyShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Component component = e.getComponent();
                JPopupMenu popupMenu = EditNodeTextField.this.createPopupMenu(component);
                this.popupShown = true;
                popupMenu.show(component, e.getX(), e.getY());
                e.consume();
            }
        }

        public void focusGained(FocusEvent e) {
            this.popupShown = false;
        }

        public void focusLost(FocusEvent e) {
            if (EditNodeTextField.this.textfield == null || !EditNodeTextField.this.textfield.isVisible() || this.eventSource == 2 || this.popupShown) {
                return;
            }
            if (e == null) {
                this.submitText();
                EditNodeTextField.this.hideMe();
                this.eventSource = 2;
                return;
            }
            if (e.isTemporary() && e.getOppositeComponent() == null) {
                return;
            }
            this.submitText();
            EditNodeTextField.this.hideMe();
        }

        private void submitText() {
            this.submitText(EditNodeTextField.this.getNewText());
        }

        private void submitText(String output) {
            EditNodeTextField.this.getEditControl().ok(output);
        }

        public void keyPressed(KeyEvent e) {
            if (e.isControlDown() || e.isMetaDown() || this.eventSource == 2 || EditNodeTextField.this.textfield == null) {
                return;
            }
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 27: {
                    this.eventSource = 2;
                    EditNodeTextField.this.hideMe();
                    EditNodeTextField.this.getEditControl().cancel();
                    EditNodeTextField.this.nodeView.requestFocusInWindow();
                    e.consume();
                    break;
                }
                case 10: {
                    boolean enterConfirms = ResourceController.getResourceController().getBooleanProperty("el__enter_confirms_by_default");
                    if (enterConfirms == e.isAltDown() || e.isShiftDown()) {
                        e.consume();
                        Component component = e.getComponent();
                        KeyEvent keyEvent = new KeyEvent(component, e.getID(), e.getWhen(), 0, keyCode, e.getKeyChar(), e.getKeyLocation());
                        SwingUtilities.processKeyBindings(keyEvent);
                        break;
                    }
                    String output = EditNodeTextField.this.getNewText();
                    e.consume();
                    this.eventSource = 2;
                    EditNodeTextField.this.hideMe();
                    this.submitText(output);
                    EditNodeTextField.this.nodeView.requestFocusInWindow();
                    break;
                }
                case 9: {
                    EditNodeTextField.this.textfield.replaceSelection("    ");
                }
                case 32: {
                    e.consume();
                    break;
                }
                default: {
                    if (keyCode != SPLIT_KEY_CODE || keyCode == -1 || !e.isAltDown() || !EditNodeTextField.this.getEditControl().canSplit()) break;
                    this.eventSource = 2;
                    String output = EditNodeTextField.this.getNewText();
                    int caretPosition = EditNodeTextField.this.textfield.getCaretPosition();
                    EditNodeTextField.this.hideMe();
                    EditNodeTextField.this.getEditControl().split(output, caretPosition);
                    EditNodeTextField.this.nodeView.requestFocusInWindow();
                    e.consume();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void mouseClicked(MouseEvent ev) {
            String linkURL;
            if (EditNodeTextField.this.textfield != null && (ev.getModifiers() & 2) != 0 && (linkURL = HtmlUtils.getURLOfExistingLink((HTMLDocument)EditNodeTextField.this.textfield.getDocument(), EditNodeTextField.this.textfield.viewToModel(ev.getPoint()))) != null) {
                try {
                    UrlManager.getController().loadURL(new URI(linkURL));
                }
                catch (Exception e) {
                    LogUtils.warn(e);
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.conditionallyShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.conditionallyShowPopup(e);
        }
    }

    private final class MyDocumentListener
    implements DocumentListener {
        private boolean updateRunning = false;

        private MyDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            this.onUpdate();
        }

        private void onUpdate() {
            if (this.updateRunning) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MyDocumentListener.this.updateRunning = true;
                    EditNodeTextField.this.layout();
                    MyDocumentListener.this.updateRunning = false;
                }
            });
        }

        public void insertUpdate(DocumentEvent e) {
            this.onUpdate();
        }

        public void removeUpdate(DocumentEvent e) {
            this.onUpdate();
        }
    }

    private class MyNavigationFilter
    extends NavigationFilter {
        private final JEditorPane textfield;

        public MyNavigationFilter(JEditorPane textfield) {
            this.textfield = textfield;
        }

        public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            dot = this.getValidPosition(dot);
            super.moveDot(fb, dot, bias);
        }

        public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            dot = this.getValidPosition(dot);
            super.setDot(fb, dot, bias);
        }

        private int getValidPosition(int position) {
            HTMLDocument doc = (HTMLDocument)this.textfield.getDocument();
            if (doc.getDefaultRootElement().getElementCount() > 1) {
                int startPos = doc.getDefaultRootElement().getElement(1).getStartOffset();
                int validPosition = Math.max(position, startPos);
                return validPosition;
            }
            return position;
        }
    }
}

