/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode.nodelist;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.BlindIcon;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderExtension;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.CoreTextAccessor;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.DateRenderer;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.DetailTextAccessor;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.FlatNodeTableFilterModel;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.IconsHolder;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.IconsRenderer;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.NoteTextAccessor;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TableSorter;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TextHolder;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TextRenderer;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TimeWindowColumnSetting;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TimeWindowConfigurationStorage;

public class NodeList {
    private static String COLUMN_CREATED = "Created";
    private static String COLUMN_DATE = "Date";
    private static String COLUMN_ICONS = "Icons";
    private static String COLUMN_MODIFIED = "Modified";
    private static String COLUMN_NOTES = "Notes";
    private static String COLUMN_TEXT = "Text";
    private static String COLUMN_DETAILS = "Details";
    private static final int DATE_COLUMN = 0;
    protected static final int NODE_CREATED_COLUMN = 3;
    protected static final int NODE_ICON_COLUMN = 2;
    protected static final int NODE_MODIFIED_COLUMN = 4;
    protected static final int NODE_DETAILS_COLUMN = 5;
    protected static final int NODE_NOTES_COLUMN = 6;
    public static final int NODE_TEXT_COLUMN = 1;
    private static final String PLUGINS_TIME_LIST_XML_CREATED = "plugins/TimeList.xml_Created";
    private static final String PLUGINS_TIME_LIST_XML_DATE = "plugins/TimeList.xml_Date";
    private static final String PLUGINS_TIME_LIST_XML_ICONS = "plugins/TimeList.xml_Icons";
    private static final String PLUGINS_TIME_LIST_XML_MODIFIED = "plugins/TimeList.xml_Modified";
    private static final String PLUGINS_TIME_LIST_XML_NOTES = "plugins/TimeList.xml_Notes";
    private static final String PLUGINS_TIME_LIST_XML_DETAILS = "plugins/TimeList.xml_Details";
    private static final String PLUGINS_TIME_LIST_XML_TEXT = "plugins/TimeList.xml_Text";
    private static final String PLUGINS_TIME_MANAGEMENT_XML_CLOSE = "plugins/TimeManagement.xml_closeButton";
    private static final String PLUGINS_TIME_MANAGEMENT_XML_FIND = "plugins/TimeManagement.xml_Find";
    private static final String PLUGINS_TIME_MANAGEMENT_XML_REPLACE = "plugins/TimeManagement.xml_Replace";
    private static final String PLUGINS_TIME_MANAGEMENT_XML_WINDOW_TITLE = "plugins/TimeManagement.xml_WindowTitle";
    private static final String PLUGINS_TIME_MANAGEMENT_XML_WINDOW_TITLE_ALL_NODES = "plugins/TimeManagement.xml_WindowTitle_All_Nodes";
    private static final String WINDOW_PREFERENCE_STORAGE_PROPERTY = NodeList.class.getName() + "_properties";
    private DateRenderer dateRenderer;
    private JDialog dialog;
    private IconsRenderer iconsRenderer;
    private final JComboBox mFilterTextReplaceField;
    private final JComboBox mFilterTextSearchField;
    private FlatNodeTableFilterModel mFlatNodeTableFilterModel;
    private JLabel mTreeLabel;
    private TextRenderer textRenderer;
    private boolean showAllNodes = false;
    private TableSorter sorter;
    private JTable tableView;
    private DefaultTableModel tableModel;
    private final boolean searchInAllMaps;
    private final JCheckBox useRegexInReplace;
    private final JCheckBox useRegexInFind;
    private final JCheckBox matchCase;
    private final boolean modal;

    private static String replace(Pattern p, String input, String replacement) {
        String result = HtmlUtils.getReplaceResult(p, input, replacement);
        return result;
    }

    public NodeList(boolean showAllNodes, boolean searchInAllMaps) {
        this(false, showAllNodes, searchInAllMaps);
    }

    public NodeList(boolean modal, boolean showAllNodes, boolean searchInAllMaps) {
        this.modal = modal;
        this.showAllNodes = showAllNodes;
        this.searchInAllMaps = searchInAllMaps;
        this.mFilterTextSearchField = new JComboBox();
        this.mFilterTextSearchField.setEditable(true);
        FilterTextDocumentListener listener = new FilterTextDocumentListener();
        this.mFilterTextSearchField.addActionListener(listener);
        JTextComponent editorComponent = (JTextComponent)this.mFilterTextSearchField.getEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener(listener);
        this.mFilterTextSearchField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 40) {
                    NodeList.this.mFilterTextReplaceField.requestFocusInWindow();
                }
            }
        });
        this.mFilterTextReplaceField = new JComboBox();
        this.mFilterTextReplaceField.setEditable(true);
        this.mFilterTextReplaceField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 40) {
                    NodeList.this.tableView.requestFocusInWindow();
                } else if (pEvent.getKeyCode() == 38) {
                    NodeList.this.mFilterTextSearchField.requestFocusInWindow();
                }
            }
        });
        this.useRegexInReplace = new JCheckBox();
        this.useRegexInFind = new JCheckBox();
        this.useRegexInFind.addChangeListener(listener);
        this.matchCase = new JCheckBox();
        this.matchCase.addChangeListener(listener);
        MapChangeListener mapChangeListener = new MapChangeListener();
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        mapController.addMapChangeListener(mapChangeListener);
        mapController.addNodeChangeListener(mapChangeListener);
        Controller.getCurrentController().getMapViewManager().addMapSelectionListener(mapChangeListener);
    }

    private void disposeDialog() {
        if (this.dialog == null || !this.dialog.isVisible()) {
            return;
        }
        TimeWindowConfigurationStorage storage = new TimeWindowConfigurationStorage();
        for (int i = 0; i < this.tableView.getColumnCount(); ++i) {
            TimeWindowColumnSetting setting = new TimeWindowColumnSetting();
            setting.setColumnWidth(this.tableView.getColumnModel().getColumn(i).getWidth());
            setting.setColumnSorting(this.sorter.getSortingStatus(i));
            storage.addTimeWindowColumnSetting(setting);
        }
        storage.storeDialogPositions(this.dialog, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
    }

    protected void exportSelectedRowsAndClose() {
        int[] selectedRows = this.tableView.getSelectedRows();
        ArrayList<NodeModel> selectedNodes = new ArrayList<NodeModel>();
        for (int i = 0; i < selectedRows.length; ++i) {
            int row = selectedRows[i];
            selectedNodes.add(this.getMindMapNode(row));
        }
        ModeController mindMapController = Controller.getCurrentModeController();
        MFileManager.getController(mindMapController).newMapFromDefaultTemplate();
        MapModel newMap = Controller.getCurrentController().getMap();
        for (NodeModel node : selectedNodes) {
            NodeModel copy = ClipboardController.getController().duplicate(node, false);
            if (copy == null) continue;
            mindMapController.getMapController().insertNodeIntoWithoutUndo(copy, newMap.getRootNode());
        }
        this.disposeDialog();
    }

    private NodeModel getMindMapNode(int focussedRow) {
        NodeModel selectedNode = ((TextHolder)this.tableView.getModel().getValueAt(focussedRow, 1)).getNode();
        return selectedNode;
    }

    private void gotoNodesAndClose(int focussedRow, int[] selectedRows) {
        this.selectNodes(focussedRow, selectedRows);
        this.disposeDialog();
    }

    private void replace(HolderAccessor holderAccessor) {
        Pattern p;
        String searchString = (String)this.mFilterTextSearchField.getSelectedItem();
        if (searchString == null) {
            return;
        }
        String replaceString = (String)this.mFilterTextReplaceField.getSelectedItem();
        try {
            p = Pattern.compile(this.useRegexInFind.isSelected() ? searchString : Pattern.quote(searchString), this.matchCase.isSelected() ? 0 : 2);
        }
        catch (PatternSyntaxException e) {
            UITools.errorMessage(TextUtils.format("wrong_regexp", searchString, e.getMessage()));
            return;
        }
        String replacement = replaceString == null ? "" : replaceString;
        int length = holderAccessor.getLength();
        for (int i = 0; i < length; ++i) {
            TextHolder[] textHolders;
            for (TextHolder textHolder : textHolders = holderAccessor.getNodeHoldersAt(i)) {
                String replaceResult;
                String text = textHolder.getText();
                String literalReplacement = this.useRegexInReplace.isSelected() ? replacement : Matcher.quoteReplacement(replacement);
                try {
                    replaceResult = HtmlUtils.isHtmlNode(text) ? NodeList.replace(p, text, literalReplacement) : p.matcher(text).replaceAll(literalReplacement);
                }
                catch (Exception e) {
                    UITools.errorMessage(TextUtils.format("wrong_regexp", replacement, e.getMessage()));
                    return;
                }
                if (StringUtils.equals((String)text, (String)replaceResult)) continue;
                holderAccessor.changeString(textHolder, replaceResult);
            }
        }
        this.tableModel.fireTableDataChanged();
        this.mFlatNodeTableFilterModel.resetFilter();
        this.mFilterTextSearchField.insertItemAt(this.mFilterTextSearchField.getSelectedItem(), 0);
        this.mFilterTextReplaceField.insertItemAt(this.mFilterTextReplaceField.getSelectedItem(), 0);
        this.mFilterTextSearchField.setSelectedItem("");
    }

    private void selectNodes(int focussedRow, int[] selectedRows) {
        if (focussedRow >= 0) {
            NodeModel focussedNode = this.getMindMapNode(focussedRow);
            MapModel map = focussedNode.getMap();
            ArrayList<NodeModel> selectedNodes = new ArrayList<NodeModel>();
            for (int row : selectedRows) {
                NodeModel node = this.getMindMapNode(row);
                if (!node.getMap().equals(map)) continue;
                selectedNodes.add(node);
            }
            this.selectMap(map);
            Controller.getCurrentModeController().getMapController().selectMultipleNodes(focussedNode, selectedNodes);
        }
    }

    private void selectMap(MapModel map) {
        if (map.equals(Controller.getCurrentController().getMap())) {
            return;
        }
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        Map<String, MapModel> maps = mapViewManager.getMaps("MindMap");
        for (Map.Entry<String, MapModel> entry : maps.entrySet()) {
            if (!map.equals(entry.getValue())) continue;
            mapViewManager.tryToChangeToMapView(entry.getKey());
        }
    }

    private void selectSelectedRows() {
        this.selectNodes(this.tableView.getSelectedRow(), this.tableView.getSelectedRows());
    }

    public void startup() {
        TimeWindowConfigurationStorage result;
        if (this.dialog != null) {
            this.dialog.toFront();
            return;
        }
        COLUMN_MODIFIED = TextUtils.getText(PLUGINS_TIME_LIST_XML_MODIFIED);
        COLUMN_CREATED = TextUtils.getText(PLUGINS_TIME_LIST_XML_CREATED);
        COLUMN_ICONS = TextUtils.getText(PLUGINS_TIME_LIST_XML_ICONS);
        COLUMN_TEXT = TextUtils.getText(PLUGINS_TIME_LIST_XML_TEXT);
        COLUMN_DETAILS = TextUtils.getText(PLUGINS_TIME_LIST_XML_DETAILS);
        COLUMN_DATE = TextUtils.getText(PLUGINS_TIME_LIST_XML_DATE);
        COLUMN_NOTES = TextUtils.getText(PLUGINS_TIME_LIST_XML_NOTES);
        this.dialog = new JDialog(Controller.getCurrentController().getViewController().getFrame(), this.modal);
        String windowTitle = this.showAllNodes ? PLUGINS_TIME_MANAGEMENT_XML_WINDOW_TITLE_ALL_NODES : PLUGINS_TIME_MANAGEMENT_XML_WINDOW_TITLE;
        this.dialog.setTitle(TextUtils.getText(windowTitle));
        this.dialog.setDefaultCloseOperation(0);
        WindowAdapter windowListener = new WindowAdapter(){

            public void windowGainedFocus(WindowEvent e) {
                NodeList.this.mFilterTextSearchField.getEditor().selectAll();
            }

            public void windowClosing(WindowEvent event) {
                NodeList.this.disposeDialog();
            }
        };
        this.dialog.addWindowListener(windowListener);
        this.dialog.addWindowFocusListener(windowListener);
        UITools.addEscapeActionToDialog(this.dialog, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.disposeDialog();
            }
        });
        Container contentPane = this.dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.gridx = 0;
        layoutConstraints.gridy = 0;
        layoutConstraints.gridwidth = 1;
        layoutConstraints.gridheight = 1;
        layoutConstraints.weightx = 0.0;
        layoutConstraints.weighty = 0.0;
        layoutConstraints.anchor = 17;
        layoutConstraints.fill = 2;
        contentPane.add((Component)new JLabel(TextUtils.getText(PLUGINS_TIME_MANAGEMENT_XML_FIND)), layoutConstraints);
        layoutConstraints.gridwidth = 1;
        ++layoutConstraints.gridx;
        contentPane.add(Box.createHorizontalStrut(40), layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add((Component)new JLabel(TextUtils.getText("filter_match_case")), layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add((Component)this.matchCase, layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add(Box.createHorizontalStrut(40), layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add((Component)new JLabel(TextUtils.getText("regular_expressions")), layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add((Component)this.useRegexInFind, layoutConstraints);
        layoutConstraints.gridx = 0;
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        ++layoutConstraints.gridy;
        contentPane.add((Component)this.mFilterTextSearchField, layoutConstraints);
        ++layoutConstraints.gridy;
        layoutConstraints.weightx = 0.0;
        layoutConstraints.gridwidth = 1;
        contentPane.add((Component)new JLabel(TextUtils.getText(PLUGINS_TIME_MANAGEMENT_XML_REPLACE)), layoutConstraints);
        layoutConstraints.gridx = 5;
        contentPane.add((Component)new JLabel(TextUtils.getText("regular_expressions")), layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add((Component)this.useRegexInReplace, layoutConstraints);
        layoutConstraints.gridx = 0;
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        ++layoutConstraints.gridy;
        contentPane.add((Component)this.mFilterTextReplaceField, layoutConstraints);
        this.dateRenderer = new DateRenderer();
        this.textRenderer = new TextRenderer();
        this.iconsRenderer = new IconsRenderer();
        this.tableView = new FlatNodeTable();
        this.tableView.addKeyListener(new FlatNodeTableKeyListener());
        this.tableView.addMouseListener(new FlatNodeTableMouseAdapter());
        this.tableView.getTableHeader().setReorderingAllowed(false);
        this.tableModel = this.updateModel();
        this.mFlatNodeTableFilterModel = new FlatNodeTableFilterModel(this.tableModel, new int[]{1, 5, 6});
        this.sorter = new TableSorter(this.mFlatNodeTableFilterModel);
        this.tableView.setModel(this.sorter);
        this.sorter.setTableHeader(this.tableView.getTableHeader());
        this.sorter.setColumnComparator(Date.class, TableSorter.COMPARABLE_COMPARATOR);
        this.sorter.setColumnComparator(NodeModel.class, TableSorter.LEXICAL_COMPARATOR);
        this.sorter.setColumnComparator(IconsHolder.class, TableSorter.COMPARABLE_COMPARATOR);
        this.sorter.setSortingStatus(0, 1);
        JScrollPane pane = new JScrollPane(this.tableView);
        UITools.setScrollbarIncrement(pane);
        ++layoutConstraints.gridy;
        GridBagConstraints tableConstraints = (GridBagConstraints)layoutConstraints.clone();
        tableConstraints.weightx = 1.0;
        tableConstraints.weighty = 10.0;
        tableConstraints.fill = 1;
        contentPane.add((Component)pane, tableConstraints);
        this.mTreeLabel = new JLabel();
        ++layoutConstraints.gridy;
        GridBagConstraints treeConstraints = (GridBagConstraints)layoutConstraints.clone();
        treeConstraints.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.mTreeLabel){

            public boolean isValidateRoot() {
                return false;
            }
        };
        contentPane.add((Component)scrollPane, treeConstraints);
        final AbstractAction exportAction = new AbstractAction(TextUtils.getText("plugins/TimeManagement.xml_Export")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.exportSelectedRowsAndClose();
            }
        };
        JButton exportButton = new JButton(exportAction);
        AbstractAction replaceAllAction = new AbstractAction(TextUtils.getText("plugins/TimeManagement.xml_Replace_All")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.replace(new HolderAccessor(false));
            }
        };
        JButton replaceAllButton = new JButton(replaceAllAction);
        final AbstractAction replaceSelectedAction = new AbstractAction(TextUtils.getText("plugins/TimeManagement.xml_Replace_Selected")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.replace(new HolderAccessor(true));
            }
        };
        JButton replaceSelectedButton = new JButton(replaceSelectedAction);
        final AbstractAction gotoAction = new AbstractAction(TextUtils.getText("plugins/TimeManagement.xml_Goto")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.selectSelectedRows();
            }
        };
        JButton gotoButton = new JButton(gotoAction);
        AbstractAction disposeAction = new AbstractAction(TextUtils.getText(PLUGINS_TIME_MANAGEMENT_XML_CLOSE)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.disposeDialog();
            }
        };
        JButton cancelButton = new JButton(disposeAction);
        gotoAction.setEnabled(false);
        exportAction.setEnabled(false);
        replaceSelectedAction.setEnabled(false);
        Box bar = Box.createHorizontalBox();
        bar.add(Box.createHorizontalGlue());
        bar.add(cancelButton);
        bar.add(exportButton);
        bar.add(replaceAllButton);
        bar.add(replaceSelectedButton);
        bar.add(gotoButton);
        bar.add(Box.createHorizontalGlue());
        ++layoutConstraints.gridy;
        contentPane.add((Component)bar, layoutConstraints);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(TextUtils.getText("plugins/TimeManagement.xml_menu_actions"));
        AbstractAction[] actionList = new AbstractAction[]{gotoAction, replaceSelectedAction, replaceAllAction, exportAction, disposeAction};
        for (int i = 0; i < actionList.length; ++i) {
            AbstractAction action = actionList[i];
            JMenuItem item = menu.add(action);
            item.setIcon(new BlindIcon(16));
        }
        menuBar.add(menu);
        this.dialog.setJMenuBar(menuBar);
        ListSelectionModel rowSM = this.tableView.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                boolean enable = !lsm.isSelectionEmpty();
                replaceSelectedAction.setEnabled(enable);
                gotoAction.setEnabled(enable);
                exportAction.setEnabled(enable);
            }
        });
        rowSM.addListSelectionListener(new ListSelectionListener(){

            String getNodeText(NodeModel node) {
                return TextController.getController().getShortText(node) + (node.isRoot() ? "" : " <- " + this.getNodeText(node.getParentNode()));
            }

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    NodeList.this.mTreeLabel.setText("");
                    return;
                }
                int selectedRow = lsm.getLeadSelectionIndex();
                NodeModel mindMapNode = NodeList.this.getMindMapNode(selectedRow);
                NodeList.this.mTreeLabel.setText(this.getNodeText(mindMapNode));
            }
        });
        String marshalled = ResourceController.getResourceController().getProperty(WINDOW_PREFERENCE_STORAGE_PROPERTY);
        TimeWindowConfigurationStorage storage = result = TimeWindowConfigurationStorage.decorateDialog(marshalled, this.dialog);
        if (storage != null) {
            this.tableView.setAutoResizeMode(0);
            int column = 0;
            for (TimeWindowColumnSetting setting : storage.getListTimeWindowColumnSettingList()) {
                this.tableView.getColumnModel().getColumn(column).setPreferredWidth(setting.getColumnWidth());
                this.sorter.setSortingStatus(column, setting.getColumnSorting());
                ++column;
            }
        }
        this.mFlatNodeTableFilterModel.setFilter((String)this.mFilterTextSearchField.getSelectedItem(), this.matchCase.isSelected(), this.useRegexInFind.isSelected());
        this.dialog.setVisible(true);
    }

    private DefaultTableModel updateModel() {
        DefaultTableModel model = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int arg0) {
                switch (arg0) {
                    case 0: 
                    case 3: 
                    case 4: {
                        return Date.class;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        return TextHolder.class;
                    }
                    case 2: {
                        return IconsHolder.class;
                    }
                }
                return Object.class;
            }
        };
        model.addColumn(COLUMN_DATE);
        model.addColumn(COLUMN_TEXT);
        model.addColumn(COLUMN_ICONS);
        model.addColumn(COLUMN_CREATED);
        model.addColumn(COLUMN_MODIFIED);
        model.addColumn(COLUMN_DETAILS);
        model.addColumn(COLUMN_NOTES);
        if (!this.searchInAllMaps) {
            NodeModel node = Controller.getCurrentController().getMap().getRootNode();
            this.updateModel(model, node);
        } else {
            Map<String, MapModel> maps = Controller.getCurrentController().getMapViewManager().getMaps("MindMap");
            for (MapModel map : maps.values()) {
                NodeModel node = map.getRootNode();
                this.updateModel(model, node);
            }
        }
        return model;
    }

    private void updateModel(DefaultTableModel model, NodeModel node) {
        ReminderExtension hook = ReminderExtension.getExtension(node);
        Date date = null;
        if (hook != null) {
            date = new Date(hook.getRemindUserAt());
        }
        if (this.showAllNodes && node.isVisible() || hook != null) {
            model.addRow(new Object[]{date, new TextHolder(new CoreTextAccessor(node)), new IconsHolder(node), node.getHistoryInformation().getCreatedAt(), node.getHistoryInformation().getLastModifiedAt(), new TextHolder(new DetailTextAccessor(node)), new TextHolder(new NoteTextAccessor(node))});
        }
        for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
            this.updateModel(model, child);
        }
    }

    private class HolderAccessor {
        private final boolean selectedOnly;

        private HolderAccessor(boolean selectedOnly) {
            this.selectedOnly = selectedOnly;
        }

        public void changeString(TextHolder textHolder, String newText) {
            textHolder.setText(newText);
        }

        public int getLength() {
            return NodeList.this.mFlatNodeTableFilterModel.getRowCount();
        }

        public TextHolder[] getNodeHoldersAt(int row) {
            return this.selectedOnly ? this.getSelectedNodeHoldersAt(row) : this.getAnyNodeHoldersAt(row);
        }

        public TextHolder[] getAnyNodeHoldersAt(int i) {
            return new TextHolder[]{(TextHolder)NodeList.this.mFlatNodeTableFilterModel.getValueAt(i, 1), (TextHolder)NodeList.this.mFlatNodeTableFilterModel.getValueAt(i, 5), (TextHolder)NodeList.this.mFlatNodeTableFilterModel.getValueAt(i, 6)};
        }

        public TextHolder[] getSelectedNodeHoldersAt(int i) {
            return new TextHolder[]{(TextHolder)NodeList.this.sorter.getValueAt(NodeList.this.tableView.getSelectedRows()[i], 1)};
        }
    }

    private final class FlatNodeTableMouseAdapter
    extends MouseAdapter {
        private FlatNodeTableMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point p = e.getPoint();
                int row = NodeList.this.tableView.rowAtPoint(p);
                NodeList.this.gotoNodesAndClose(row, new int[]{row});
            }
        }
    }

    private final class FlatNodeTableKeyListener
    implements KeyListener {
        private FlatNodeTableKeyListener() {
        }

        public void keyPressed(KeyEvent arg0) {
        }

        public void keyReleased(KeyEvent arg0) {
            if (arg0.getKeyCode() == 27) {
                NodeList.this.disposeDialog();
            }
            if (arg0.getKeyCode() == 10) {
                NodeList.this.selectSelectedRows();
                NodeList.this.disposeDialog();
            }
        }

        public void keyTyped(KeyEvent arg0) {
        }
    }

    private final class FlatNodeTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        private FlatNodeTable() {
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            Object object = this.getModel().getValueAt(row, column);
            if (object instanceof Date) {
                return NodeList.this.dateRenderer;
            }
            if (object instanceof TextHolder) {
                return NodeList.this.textRenderer;
            }
            if (object instanceof IconsHolder) {
                return NodeList.this.iconsRenderer;
            }
            return super.getCellRenderer(row, column);
        }

        public boolean isCellEditable(int rowIndex, int vColIndex) {
            return false;
        }

        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                EventListener[] el = super.getListeners(KeyListener.class);
                if (e.getID() != 402) {
                    return;
                }
                for (int i = 0; i < el.length; ++i) {
                    KeyListener kl = (KeyListener)el[i];
                    kl.keyReleased(e);
                }
                return;
            }
            super.processKeyEvent(e);
        }
    }

    private final class FilterTextDocumentListener
    implements DocumentListener,
    ChangeListener,
    ActionListener {
        private Timer mTypeDelayTimer = null;

        private FilterTextDocumentListener() {
        }

        private synchronized void delayedChange() {
            this.stopTimer();
            this.mTypeDelayTimer = new Timer(500, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FilterTextDocumentListener.this.change();
                }
            });
            this.mTypeDelayTimer.start();
        }

        public void stopTimer() {
            if (this.mTypeDelayTimer != null) {
                this.mTypeDelayTimer.stop();
                this.mTypeDelayTimer = null;
            }
        }

        public void changedUpdate(DocumentEvent event) {
            this.delayedChange();
        }

        public void insertUpdate(DocumentEvent event) {
            this.delayedChange();
        }

        public void removeUpdate(DocumentEvent event) {
            this.delayedChange();
        }

        private synchronized void change() {
            this.stopTimer();
            Object selectedItem = NodeList.this.mFilterTextSearchField.getEditor().getItem();
            NodeList.this.mFlatNodeTableFilterModel.setFilter((String)selectedItem, NodeList.this.matchCase.isSelected(), NodeList.this.useRegexInFind.isSelected());
        }

        public void stateChanged(ChangeEvent e) {
            this.change();
        }

        public void actionPerformed(ActionEvent e) {
            this.change();
        }
    }

    private final class MapChangeListener
    implements IMapChangeListener,
    INodeChangeListener,
    IMapSelectionListener {
        private MapChangeListener() {
        }

        public void onPreNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
            NodeList.this.disposeDialog();
        }

        public void onPreNodeDelete(NodeModel oldParent, NodeModel selectedNode, int index) {
            NodeList.this.disposeDialog();
        }

        public void onNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
            NodeList.this.disposeDialog();
        }

        public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
            NodeList.this.disposeDialog();
        }

        public void onNodeDeleted(NodeModel parent, NodeModel child, int index) {
            NodeList.this.disposeDialog();
        }

        public void mapChanged(MapChangeEvent event) {
            NodeList.this.disposeDialog();
        }

        public void nodeChanged(NodeChangeEvent event) {
            if (event.getProperty().equals("node_text")) {
                NodeList.this.disposeDialog();
            }
        }

        public void afterMapChange(MapModel oldMap, MapModel newMap) {
        }

        public void beforeMapChange(MapModel oldMap, MapModel newMap) {
            NodeList.this.disposeDialog();
        }
    }
}

