/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode.nodelist;

import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FlatNodeTableFilterModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String mFilterRegexp;
    private Pattern mPattern;
    private ArrayList<Integer> mIndexArray;
    private final int[] mNodeTextColumns;
    private final TableModel mTableModel;
    private boolean matchCase;

    public FlatNodeTableFilterModel(TableModel tableModel, int[] node_text_column) {
        this.mTableModel = tableModel;
        this.mNodeTextColumns = node_text_column;
        tableModel.addTableModelListener(new TableModelHandler());
        this.resetFilter();
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return this.mTableModel.getColumnClass(arg0);
    }

    @Override
    public int getColumnCount() {
        return this.mTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int pColumnIndex) {
        return this.mTableModel.getColumnName(pColumnIndex);
    }

    @Override
    public int getRowCount() {
        return this.mIndexArray.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            throw new IllegalArgumentException("Illegal Row specified: " + row);
        }
        int origRow = this.mIndexArray.get(row);
        return this.mTableModel.getValueAt(origRow, column);
    }

    public void resetFilter() {
        this.setFilter(null, false, false);
    }

    public void setFilter(String filterRegexp, boolean matchCase, boolean useRegex) {
        this.mFilterRegexp = filterRegexp == null || "".equals(filterRegexp) ? null : (matchCase ? filterRegexp : filterRegexp.toLowerCase());
        this.matchCase = matchCase;
        try {
            this.mPattern = !useRegex || this.mFilterRegexp == null ? null : Pattern.compile(this.mFilterRegexp, matchCase ? 0 : 2);
            this.updateIndexArray();
            this.fireTableDataChanged();
        }
        catch (PatternSyntaxException e) {
            // empty catch block
        }
    }

    private void updateIndexArray() {
        ArrayList<Integer> newIndexArray = new ArrayList<Integer>();
        block0: for (int i = 0; i < this.mTableModel.getRowCount(); ++i) {
            if (this.mFilterRegexp == null) {
                newIndexArray.add(new Integer(i));
                continue;
            }
            for (int nodeTextColumn : this.mNodeTextColumns) {
                TextHolder nodeContent = (TextHolder)this.mTableModel.getValueAt(i, nodeTextColumn);
                if (!(this.mPattern == null && (this.matchCase && nodeContent.toString().contains(this.mFilterRegexp) || !this.matchCase && nodeContent.toString().toLowerCase().contains(this.mFilterRegexp))) && (this.mPattern == null || !this.mPattern.matcher(nodeContent.toString()).find())) continue;
                newIndexArray.add(new Integer(i));
                continue block0;
            }
        }
        this.mIndexArray = newIndexArray;
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent arg0) {
            FlatNodeTableFilterModel.this.fireTableDataChanged();
        }
    }
}

