/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.calendar.JCalendar;
import org.freeplane.core.ui.components.calendar.JTripleCalendar;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.format.PatternFormat;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.script.IScriptEditorStarter;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.view.swing.features.time.mindmapmode.PeriodPanel;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderExtension;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderHook;

class TimeManagement
implements PropertyChangeListener,
IMapSelectionListener {
    private Calendar calendar;
    public static final String REMINDER_HOOK_NAME = "plugins/TimeManagementReminder.xml";
    private static TimeManagement sCurrentlyOpenTimeManagement = null;
    private JDialog dialog;
    private final ReminderHook reminderHook;
    private PatternFormat dateFormat;
    private INodeChangeListener nodeChangeListener;
    private INodeSelectionListener nodeSelectionListener;

    public TimeManagement(ReminderHook reminderHook) {
        this.reminderHook = reminderHook;
        Controller.getCurrentController().getMapViewManager().addMapSelectionListener(this);
    }

    public void afterMapChange(MapModel oldMap, MapModel newMap) {
    }

    public void beforeMapChange(MapModel oldMap, MapModel newMap) {
        this.disposeDialog();
    }

    private void disposeDialog() {
        if (this.dialog == null) {
            return;
        }
        this.getMindMapController().getMapController().removeNodeSelectionListener(this.nodeSelectionListener);
        this.nodeSelectionListener = null;
        this.getMindMapController().getMapController().removeNodeChangeListener(this.nodeChangeListener);
        this.nodeChangeListener = null;
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
        sCurrentlyOpenTimeManagement = null;
    }

    private FormattedDate getCalendarDate() {
        return new FormattedDate(this.calendar.getTime(), this.dateFormat.getPattern());
    }

    private ModeController getMindMapController() {
        return Controller.getCurrentModeController();
    }

    private String getResourceString(String string) {
        return TextUtils.getText(string);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("day")) {
            // empty if block
        }
    }

    void showDialog() {
        if (sCurrentlyOpenTimeManagement != null) {
            TimeManagement.sCurrentlyOpenTimeManagement.dialog.getContentPane().setVisible(true);
            return;
        }
        sCurrentlyOpenTimeManagement = this;
        this.dialog = new JDialog(Controller.getCurrentController().getViewController().getFrame(), false);
        final JTimePanel timePanel = this.createTimePanel(this.dialog, true, 4);
        this.nodeSelectionListener = new INodeSelectionListener(){

            public void onSelect(NodeModel node) {
                timePanel.update(node);
            }

            public void onDeselect(NodeModel node) {
            }
        };
        this.getMindMapController().getMapController().addNodeSelectionListener(this.nodeSelectionListener);
        this.nodeChangeListener = new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                NodeModel node = event.getNode();
                if (event.getProperty().equals(ReminderExtension.class) && node.equals(TimeManagement.this.getMindMapController().getMapController().getSelectedNode())) {
                    timePanel.update(node);
                }
            }
        };
        this.getMindMapController().getMapController().addNodeChangeListener(this.nodeChangeListener);
        this.dialog.setTitle(this.getResourceString("plugins/TimeManagement.xml_WindowTitle"));
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                TimeManagement.this.disposeDialog();
            }
        });
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                TimeManagement.this.disposeDialog();
            }
        };
        UITools.addEscapeActionToDialog(this.dialog, action);
        this.dialog.setContentPane(timePanel);
        this.dialog.pack();
        UITools.setBounds(this.dialog, -1, -1, this.dialog.getWidth(), this.dialog.getHeight());
        this.dialog.setVisible(true);
    }

    public JTimePanel createTimePanel(Dialog dialog, boolean useTriple, int colCount) {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
            this.calendar.set(13, 0);
            this.calendar.set(14, 0);
        }
        JTimePanel contentPane = new JTimePanel(useTriple, colCount);
        return contentPane;
    }

    private JComboBox createDateFormatChooser() {
        String dateFormatPattern = ResourceController.getResourceController().getProperty("date_format");
        class DateFormatComboBoxElement {
            private final PatternFormat dateFormat;

            DateFormatComboBoxElement(PatternFormat dateFormat) {
                this.dateFormat = dateFormat;
            }

            PatternFormat getDateFormat() {
                return this.dateFormat;
            }

            public String toString() {
                return this.dateFormat.formatObject(TimeManagement.this.getCalendarDate()).toString();
            }
        }
        Vector<DateFormatComboBoxElement> values = new Vector<DateFormatComboBoxElement>();
        List<PatternFormat> datePatterns = FormatController.getController().getDateFormats();
        int selectedIndex = 0;
        for (int i = 0; i < datePatterns.size(); ++i) {
            PatternFormat patternFormat = datePatterns.get(i);
            values.add(new DateFormatComboBoxElement(patternFormat));
            if (!patternFormat.getPattern().equals(dateFormatPattern)) continue;
            this.dateFormat = patternFormat;
            selectedIndex = i;
        }
        JComboBox dateFormatChooser = new JComboBox(values);
        dateFormatChooser.setFocusable(false);
        if (!datePatterns.isEmpty()) {
            dateFormatChooser.setSelectedIndex(selectedIndex);
            this.dateFormat = ((DateFormatComboBoxElement)dateFormatChooser.getSelectedItem()).getDateFormat();
        }
        dateFormatChooser.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TimeManagement.this.dateFormat = ((DateFormatComboBoxElement)e.getItem()).getDateFormat();
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (focusOwner instanceof JTable) {
                    JTable table = (JTable)focusOwner;
                    int[] selectedRows = table.getSelectedRows();
                    int[] selectedColumns = table.getSelectedColumns();
                    for (int r : selectedRows) {
                        for (int c : selectedColumns) {
                            FormattedDate fd;
                            Object date = table.getValueAt(r, c);
                            if (!(date instanceof FormattedDate) || (fd = (FormattedDate)date).getDateFormat().equals(TimeManagement.this.dateFormat)) continue;
                            table.setValueAt(new FormattedDate(fd, TimeManagement.this.dateFormat.getPattern()), r, c);
                        }
                    }
                } else {
                    ModeController mController = Controller.getCurrentModeController();
                    for (NodeModel node : mController.getMapController().getSelectedNodes()) {
                        FormattedDate fd;
                        MTextController textController = (MTextController)TextController.getController();
                        Object date = node.getUserObject();
                        if (!(date instanceof FormattedDate) || (fd = (FormattedDate)date).getDateFormat().equals(TimeManagement.this.dateFormat)) continue;
                        textController.setNodeObject(node, new FormattedDate(fd, TimeManagement.this.dateFormat.getPattern()));
                    }
                }
            }
        });
        dateFormatChooser.setAlignmentX(0.0f);
        return dateFormatChooser;
    }

    void insertTime(Dialog dialog, JButton appendButton) {
        FormattedDate date = this.getCalendarDate();
        String dateAsString = this.dateFormat.formatObject(date).toString();
        Window parentWindow = dialog != null ? (Window)dialog.getParent() : SwingUtilities.getWindowAncestor(appendButton);
        Component mostRecentFocusOwner = parentWindow.getMostRecentFocusOwner();
        if (mostRecentFocusOwner instanceof JTextComponent && !mostRecentFocusOwner.getClass().getName().contains("JSpinField")) {
            JTextComponent textComponent = (JTextComponent)mostRecentFocusOwner;
            textComponent.replaceSelection(dateAsString);
            return;
        }
        if (mostRecentFocusOwner instanceof JTable) {
            JTable table = (JTable)mostRecentFocusOwner;
            int[] selectedRows = table.getSelectedRows();
            int[] selectedColumns = table.getSelectedColumns();
            for (int r : selectedRows) {
                for (int c : selectedColumns) {
                    table.setValueAt(date, r, c);
                }
            }
        } else {
            ModeController mController = Controller.getCurrentModeController();
            for (NodeModel node : mController.getMapController().getSelectedNodes()) {
                MTextController textController = (MTextController)TextController.getController();
                textController.setNodeObject(node, date);
            }
        }
    }

    class JTimePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JButton setReminderButton;
        private JButton removeReminderButton;
        private JButton remindLaterButton;
        private PeriodPanel periodPanel;
        private ComboBoxEditor scriptEditor;
        private JCalendar calendarComponent;
        private JComboBox dateFormatChooser;

        public JTimePanel(boolean useTriple, int colCount) {
            this.init(useTriple, colCount);
            NodeModel selected = TimeManagement.this.reminderHook.getModeController().getMapController().getSelectedNode();
            this.update(selected);
        }

        public void update(NodeModel node) {
            if (node == null) {
                return;
            }
            ReminderExtension reminder = ReminderExtension.getExtension(node);
            boolean reminderIsSet = reminder != null;
            this.removeReminderButton.setEnabled(reminderIsSet);
            if (reminderIsSet) {
                long reminderTime = reminder.getRemindUserAt();
                this.updateCalendar(reminderTime);
                this.periodPanel.setPeriod(reminder.getPeriod());
                this.periodPanel.setPeriodUnit(reminder.getPeriodUnit());
                if (this.scriptEditor != null) {
                    this.scriptEditor.setItem(reminder.getScript());
                }
            } else if (this.scriptEditor != null) {
                this.scriptEditor.setItem(null);
            }
        }

        private void updateCalendar(long reminderTime) {
            TimeManagement.this.calendar.setTimeInMillis(reminderTime);
            this.calendarComponent.setCalendar(TimeManagement.this.calendar);
            this.dateFormatChooser.repaint();
        }

        private void init(boolean useTriple, int colCount) {
            JPanel calendarContainer;
            if (useTriple) {
                JTripleCalendar trippleCalendar = new JTripleCalendar();
                this.calendarComponent = trippleCalendar.getCalendar();
                calendarContainer = trippleCalendar;
            } else {
                this.calendarComponent = new JCalendar();
                calendarContainer = this.calendarComponent;
            }
            this.calendarComponent.setCalendar(TimeManagement.this.calendar);
            if (TimeManagement.this.dialog != null) {
                TimeManagement.this.dialog.addWindowFocusListener(new WindowAdapter(){

                    public void windowGainedFocus(WindowEvent e) {
                        JTimePanel.this.calendarComponent.getDayChooser().setFocus();
                    }
                });
            }
            this.calendarComponent.setMaximumSize(this.calendarComponent.getPreferredSize());
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createHorizontalGlue());
            this.calendarComponent.getDayChooser().addPropertyChangeListener(TimeManagement.this);
            calendarContainer.setAlignmentX(0.5f);
            this.add(calendarContainer);
            DefaultFormBuilder btnBuilder = new DefaultFormBuilder(new FormLayout(FormFactory.GROWING_BUTTON_COLSPEC.toString(), ""));
            btnBuilder.getLayout().addGroupedColumn(btnBuilder.getColumnCount());
            for (int i = 1; i < colCount; ++i) {
                btnBuilder.appendRelatedComponentsGapColumn();
                btnBuilder.appendColumn(FormFactory.GROWING_BUTTON_COLSPEC);
                btnBuilder.getLayout().addGroupedColumn(btnBuilder.getColumnCount());
            }
            JButton todayButton = new JButton(TimeManagement.this.getResourceString("plugins/TimeManagement.xml_todayButton"));
            todayButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    Calendar currentTime = Calendar.getInstance();
                    currentTime.set(13, 0);
                    TimeManagement.this.calendar.setTimeInMillis(currentTime.getTimeInMillis());
                    JTimePanel.this.calendarComponent.setCalendar(TimeManagement.this.calendar);
                }
            });
            btnBuilder.append((Component)todayButton);
            this.dateFormatChooser = TimeManagement.this.createDateFormatChooser();
            btnBuilder.append((Component)this.dateFormatChooser);
            final JButton appendButton = new JButton(TimeManagement.this.getResourceString("plugins/TimeManagement.xml_appendButton"));
            if (TimeManagement.this.dialog == null) {
                appendButton.setFocusable(false);
            }
            appendButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    TimeManagement.this.insertTime(TimeManagement.this.dialog, appendButton);
                }
            });
            btnBuilder.append((Component)appendButton);
            this.scriptEditor = null;
            IScriptEditorStarter editor = TimeManagement.this.reminderHook.getModeController().getExtension(IScriptEditorStarter.class);
            if (editor != null) {
                this.scriptEditor = editor.createComboBoxEditor(new Dimension(600, 400));
                Component scriptButton = this.scriptEditor.getEditorComponent();
                btnBuilder.append(scriptButton);
            }
            this.setReminderButton = new JButton(TimeManagement.this.getResourceString("plugins/TimeManagement.xml_reminderButton"));
            this.setReminderButton.setToolTipText(TimeManagement.this.getResourceString("plugins/TimeManagement.xml_reminderButton_tooltip"));
            this.setReminderButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    JTimePanel.this.addReminder();
                }
            });
            btnBuilder.append((Component)this.setReminderButton);
            this.remindLaterButton = new JButton(TimeManagement.this.getResourceString("plugins/TimeManagement.xml_remindLaterButton"));
            this.remindLaterButton.setToolTipText(TimeManagement.this.getResourceString("plugins/TimeManagement.xml_remindLaterButton_tooltip"));
            this.remindLaterButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    JTimePanel.this.remindLaterReminder();
                }
            });
            btnBuilder.append((Component)this.remindLaterButton);
            this.periodPanel = new PeriodPanel();
            btnBuilder.append((Component)this.periodPanel);
            this.removeReminderButton = new JButton(TimeManagement.this.getResourceString("plugins/TimeManagement.xml_removeReminderButton"));
            this.removeReminderButton.setToolTipText(TimeManagement.this.getResourceString("plugins/TimeManagement.xml_removeReminderButton_tooltip"));
            this.removeReminderButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    JTimePanel.this.removeReminder();
                }
            });
            btnBuilder.append((Component)this.removeReminderButton);
            if (TimeManagement.this.dialog != null) {
                JButton cancelButton = new JButton(TimeManagement.this.getResourceString("plugins/TimeManagement.xml_closeButton"));
                cancelButton.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        TimeManagement.this.disposeDialog();
                    }
                });
                btnBuilder.append((Component)cancelButton);
            }
            JPanel btnPanel = btnBuilder.getPanel();
            btnPanel.setAlignmentX(0.5f);
            this.add(btnPanel);
        }

        private void addReminder() {
            FormattedDate date = TimeManagement.this.getCalendarDate();
            String script = null;
            if (this.scriptEditor != null && (script = (String)this.scriptEditor.getItem()) != null && "".equals(script.trim())) {
                script = null;
            }
            Controller controller = Controller.getCurrentController();
            for (NodeModel node : controller.getModeController().getMapController().getSelectedNodes()) {
                ReminderExtension alreadyPresentHook = ReminderExtension.getExtension(node);
                if (alreadyPresentHook != null) {
                    long oldReminderTime = alreadyPresentHook.getRemindUserAt();
                    if (oldReminderTime > System.currentTimeMillis()) {
                        Object[] messageArguments = new Object[]{new Date(oldReminderTime), date};
                        MessageFormat formatter = new MessageFormat(TimeManagement.this.getResourceString("plugins/TimeManagement.xml_reminderNode_onlyOneDate"));
                        String message = formatter.format(messageArguments);
                        int result = JOptionPane.showConfirmDialog(controller.getViewController().getFrame(), message, "Freeplane", 0);
                        if (result == 1) {
                            return;
                        }
                    }
                    TimeManagement.this.reminderHook.undoableToggleHook(node);
                }
                ReminderExtension reminderExtension = new ReminderExtension(node);
                reminderExtension.setRemindUserAt(date.getTime());
                reminderExtension.setPeriodUnit(this.periodPanel.getPeriodUnit());
                reminderExtension.setPeriod(this.periodPanel.getPeriod());
                reminderExtension.setScript(script);
                TimeManagement.this.reminderHook.undoableActivateHook(node, reminderExtension);
            }
        }

        private void removeReminder() {
            for (NodeModel node : TimeManagement.this.getMindMapController().getMapController().getSelectedNodes()) {
                ReminderExtension alreadyPresentHook = ReminderExtension.getExtension(node);
                if (alreadyPresentHook == null) continue;
                TimeManagement.this.reminderHook.undoableToggleHook(node);
            }
        }

        private void remindLaterReminder() {
            Date nextTime = this.periodPanel.calculateNextTime(TimeManagement.this.calendar.getTime());
            this.updateCalendar(nextTime.getTime());
            this.addReminder();
        }
    }
}

