/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.core.ui.IMenuContributor;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.script.IScriptStarter;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.view.swing.features.time.mindmapmode.ClockState;
import org.freeplane.view.swing.features.time.mindmapmode.PeriodUnit;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderConditionController;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderExtension;
import org.freeplane.view.swing.features.time.mindmapmode.TimeManagement;
import org.freeplane.view.swing.features.time.mindmapmode.TimerBlinkTask;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.AllMapsNodeListAction;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.NodeList;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.NodeListAction;
import org.freeplane.view.swing.map.attribute.AttributePanelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NodeHookDescriptor(hookName="plugins/TimeManagementReminder.xml", onceForMap=false)
public class ReminderHook
extends PersistentNodeHook
implements IExtension {
    static final String PLUGIN_LABEL = "plugins/TimeManagementReminder.xml";
    static final String REMINDUSERAT = "REMINDUSERAT";
    static final String PERIOD = "PERIOD";
    static final String UNIT = "UNIT";
    static final String SCRIPT = "SCRIPT";
    private static final Integer REMINDER_TOOLTIP = 12;
    private ModeController modeController;
    private static final IconStore STORE = IconStoreFactory.create();
    private static UIIcon bellIcon;
    private static UIIcon clockIcon;
    private static UIIcon flagIcon;

    public ReminderHook(ModeController modeController) {
        this.modeController = modeController;
        modeController.addMenuContributor(new IMenuContributor(){

            public void updateMenus(ModeController modeController, MenuBuilder builder) {
                ReminderHook.this.createTimePanel();
            }
        });
        this.registerAction(new TimeManagementAction(this));
        this.registerAction(new TimeListAction());
        this.registerAction(new NodeListAction());
        this.registerAction(new AllMapsNodeListAction());
        this.registerTooltipProvider();
        this.registerStateIconProvider();
        FilterController.getCurrentFilterController().getConditionFactory().addConditionController(9, new ReminderConditionController());
    }

    void registerStateIconProvider() {
        IconController.getController(this.modeController).addStateIconProvider(new IStateIconProvider(){

            public UIIcon getStateIcon(NodeModel node) {
                UIIcon icon = null;
                ClockState stateAdded = node.getExtension(ClockState.class);
                ReminderExtension reminder = node.getExtension(ReminderExtension.class);
                if (stateAdded == ClockState.CLOCK_VISIBLE) {
                    icon = ReminderHook.this.getClockIcon();
                } else if (stateAdded == ClockState.CLOCK_INVISIBLE) {
                    icon = reminder != null && node == reminder.getNode() ? ReminderHook.this.getBellIcon() : ReminderHook.this.getFlagIcon();
                }
                if (stateAdded != null || reminder != null && node == reminder.getNode() || ReminderExtension.getExtension(node) == null) {
                    return icon;
                }
                return null;
            }
        });
    }

    private UIIcon getBellIcon() {
        if (bellIcon == null) {
            bellIcon = STORE.getUIIcon("bell.png");
        }
        return bellIcon;
    }

    private UIIcon getClockIcon() {
        if (clockIcon == null) {
            clockIcon = STORE.getUIIcon("clock.png");
        }
        return clockIcon;
    }

    private UIIcon getFlagIcon() {
        if (flagIcon == null) {
            flagIcon = STORE.getUIIcon("flag.png");
        }
        return flagIcon;
    }

    private void registerTooltipProvider() {
        this.modeController.addToolTipProvider(REMINDER_TOOLTIP, new ITooltipProvider(){

            public String getTooltip(ModeController modeController, NodeModel node, Component view) {
                ReminderExtension model = ReminderExtension.getExtension(node);
                if (model == null) {
                    return null;
                }
                Date date = new Date(model.getRemindUserAt());
                Object[] messageArguments = new Object[]{date};
                MessageFormat formatter = new MessageFormat(TextUtils.getText("plugins/TimeManagement.xml_reminderNode_tooltip"));
                String message = formatter.format(messageArguments);
                return message;
            }
        });
    }

    private void createTimePanel() {
        TimeManagement timeManagement = new TimeManagement(this);
        boolean axis = true;
        final TimeManagement.JTimePanel timePanel = timeManagement.createTimePanel(null, false, 1);
        this.modeController.getMapController().addNodeSelectionListener(new INodeSelectionListener(){

            public void onSelect(NodeModel node) {
                timePanel.update(node);
            }

            public void onDeselect(NodeModel node) {
            }
        });
        this.modeController.getMapController().addNodeChangeListener(new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                NodeModel node = event.getNode();
                if (event.getProperty().equals(ReminderHook.this.getExtensionClass()) && node.equals(ReminderHook.this.modeController.getMapController().getSelectedNode())) {
                    timePanel.update(node);
                }
            }
        });
        timePanel.setBorder(BorderFactory.createTitledBorder(TextUtils.getText("calendar_panel")));
        JPanel tablePanel = new AttributePanelManager(this.modeController).getTablePanel();
        tablePanel.setBorder(BorderFactory.createTitledBorder(TextUtils.getText("attributes_attribute")));
        Box panel = new Box(1);
        panel.add(timePanel);
        panel.add(tablePanel);
        JTabbedPane tabs = (JTabbedPane)this.modeController.getUserInputListenerFactory().getToolBar("/format").getComponent(1);
        JScrollPane timeScrollPane = new JScrollPane(panel, 20, 30);
        UITools.setScrollbarIncrement(timeScrollPane);
        tabs.add(TextUtils.getText("calendar_attributes_panel"), timeScrollPane);
    }

    @Override
    public void add(NodeModel node, IExtension extension) {
        ReminderExtension reminderExtension = (ReminderExtension)extension;
        this.scheduleTimer(reminderExtension);
        this.modeController.getMapController().addMapChangeListener(reminderExtension);
        super.add(node, extension);
    }

    void blink(ReminderExtension model, boolean stateAdded) {
        if (model.getNode().getMap() != Controller.getCurrentController().getMap()) {
            return;
        }
        model.displayState(stateAdded ? ClockState.CLOCK_VISIBLE : ClockState.CLOCK_INVISIBLE, model.getNode(), true);
    }

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        ReminderExtension reminderExtension = new ReminderExtension(node);
        XMLElement parameters = element.getFirstChildNamed("Parameters");
        String time = parameters.getAttribute(REMINDUSERAT, "0");
        String unit = parameters.getAttribute(UNIT, "DAY");
        String period = parameters.getAttribute(PERIOD, "1");
        reminderExtension.setRemindUserAt(Long.parseLong(time));
        reminderExtension.setPeriodUnit(PeriodUnit.valueOf(unit));
        reminderExtension.setPeriod(Integer.parseInt(period));
        String script = parameters.getAttribute(SCRIPT, null);
        reminderExtension.setScript(script);
        return reminderExtension;
    }

    @Override
    protected PersistentNodeHook.HookAction createHookAction() {
        return new ReminderHookAction();
    }

    @Override
    protected Class<? extends IExtension> getExtensionClass() {
        return ReminderExtension.class;
    }

    @Override
    public void remove(NodeModel node, IExtension extension) {
        ReminderExtension reminderExtension = (ReminderExtension)extension;
        reminderExtension.deactivateTimer();
        reminderExtension.displayState(null, reminderExtension.getNode(), true);
        this.modeController.getMapController().removeMapChangeListener(reminderExtension);
        super.remove(node, extension);
    }

    @Override
    protected void saveExtension(IExtension extension, XMLElement element) {
        super.saveExtension(extension, element);
        ReminderExtension reminderExtension = (ReminderExtension)extension;
        XMLElement parameters = element.createElement("Parameters");
        parameters.setAttribute(REMINDUSERAT, Long.toString(reminderExtension.getRemindUserAt()));
        parameters.setAttribute(PERIOD, Integer.toString(reminderExtension.getPeriod()));
        parameters.setAttribute(UNIT, reminderExtension.getPeriodUnit().toString());
        String script = reminderExtension.getScript();
        if (script != null) {
            parameters.setAttribute(SCRIPT, script);
        }
        element.addChild(parameters);
    }

    private void scheduleTimer(ReminderExtension model) {
        Date date = new Date(model.getRemindUserAt());
        this.scheduleTimer(model, new TimerBlinkTask(this, model, false, System.currentTimeMillis() < date.getTime() + 1000L));
        model.displayState(ClockState.CLOCK_VISIBLE, model.getNode(), false);
    }

    private void scheduleTimer(ReminderExtension model, TimerBlinkTask task) {
        Date date = new Date(model.getRemindUserAt());
        model.scheduleTimer(task, date);
    }

    ModeController getModeController() {
        return this.modeController;
    }

    public void runScript(ReminderExtension reminderExtension) {
        String script = reminderExtension.getScript();
        if (script == null || script.equals("")) {
            return;
        }
        IScriptStarter starter = this.modeController.getExtension(IScriptStarter.class);
        if (starter == null) {
            return;
        }
        NodeModel node = reminderExtension.getNode();
        MapModel map = node.getMap();
        Controller controller = this.modeController.getController();
        if (!controller.getMapViewManager().getMaps(this.modeController.getModeName()).containsValue(map)) {
            return;
        }
        starter.executeScript(node, script);
    }

    private static class TimeManagementAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;
        private final TimeManagement timeManagement;

        public TimeManagementAction(ReminderHook reminderHook) {
            super("TimeManagementAction");
            this.timeManagement = new TimeManagement(reminderHook);
        }

        public void actionPerformed(ActionEvent e) {
            this.timeManagement.showDialog();
        }
    }

    private static class TimeListAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;
        private final NodeList timeList = new NodeList(false, false);

        public TimeListAction() {
            super("TimeListAction");
        }

        public void actionPerformed(ActionEvent e) {
            this.timeList.startup();
        }
    }

    @EnabledAction(checkOnNodeChange=true)
    private class ReminderHookAction
    extends PersistentNodeHook.HookAction {
        private static final long serialVersionUID = 1L;

        public ReminderHookAction() {
            super(ReminderHook.this, "ReminderHookAction");
        }

        public void setEnabled() {
            this.setEnabled(ReminderHook.this.isActiveForSelection());
        }
    }
}

