/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode;

import java.util.Date;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.time.TimeComboBoxEditor;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderConditionAfter;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderConditionBefore;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderConditionExecuted;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderConditionLater;

public class ReminderConditionController
implements IElementaryConditionController {
    static final String FILTER_REMINDER = "filter_reminder";
    private final ComboBoxEditor editor = new TimeComboBoxEditor(true);
    private final ComboBoxModel values = new DefaultComboBoxModel();

    public boolean canEditValues(Object property, NamedObject simpleCond) {
        return true;
    }

    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof NamedObject)) {
            return false;
        }
        NamedObject namedObject = (NamedObject)selectedItem;
        return namedObject.objectEquals(FILTER_REMINDER);
    }

    public boolean canSelectValues(Object property, NamedObject simpleCond) {
        if (simpleCond.objectEquals("filter_reminder_later")) {
            return false;
        }
        return !simpleCond.objectEquals("filter_reminder_executed");
    }

    public ASelectableCondition createCondition(Object selectedItem, NamedObject simpleCond, Object value, boolean matchCase, boolean matchApproximately) {
        return ReminderConditionController.create(simpleCond, (FormattedDate)value);
    }

    public ComboBoxModel getConditionsForProperty(Object property) {
        return new DefaultComboBoxModel<Object>(this.getTimeConditionNames());
    }

    public ListModel getFilteredProperties() {
        DefaultListModel<NamedObject> list = new DefaultListModel<NamedObject>();
        list.addElement(TextUtils.createTranslatedString(FILTER_REMINDER));
        return list;
    }

    public Object[] getTimeConditionNames() {
        return new NamedObject[]{TextUtils.createTranslatedString("filter_reminder_later"), TextUtils.createTranslatedString("filter_reminder_executed"), TextUtils.createTranslatedString("filter_reminder_after"), TextUtils.createTranslatedString("filter_reminder_before")};
    }

    public ComboBoxEditor getValueEditor(Object selectedProperty, NamedObject selectedCondition) {
        return this.editor;
    }

    public ComboBoxModel getValuesForProperty(Object selectedItem, NamedObject simpleCond) {
        this.values.setSelectedItem(FormattedDate.createDefaultFormattedDate(new Date().getTime(), "datetime"));
        return this.values;
    }

    public boolean isCaseDependent(Object property, NamedObject simpleCond) {
        return false;
    }

    public boolean supportsApproximateMatching(Object property, NamedObject simpleCond) {
        return false;
    }

    public ASelectableCondition loadCondition(XMLElement element) {
        try {
            if (element.getName().equalsIgnoreCase("reminder_condition_later")) {
                return new ReminderConditionLater();
            }
            if (element.getName().equalsIgnoreCase("reminder_condition_earlier")) {
                return new ReminderConditionExecuted();
            }
            if (element.getName().equalsIgnoreCase("reminder_condition_before")) {
                String dateString = element.getAttribute("DATE", null);
                FormattedDate date = FormattedDate.createDefaultFormattedDate(Long.parseLong(dateString), "datetime");
                return new ReminderConditionBefore(date);
            }
            if (element.getName().equalsIgnoreCase("reminder_condition_after")) {
                String dateString = element.getAttribute("DATE", null);
                FormattedDate date = FormattedDate.createDefaultFormattedDate(Long.parseLong(dateString), "datetime");
                return new ReminderConditionAfter(date);
            }
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
        return null;
    }

    public ListCellRenderer getValueRenderer(Object selectedProperty, NamedObject selectedCondition) {
        return null;
    }

    public static ASelectableCondition create(NamedObject simpleCond, FormattedDate date) {
        if (simpleCond.objectEquals("filter_reminder_later")) {
            return new ReminderConditionLater();
        }
        if (simpleCond.objectEquals("filter_reminder_executed")) {
            return new ReminderConditionExecuted();
        }
        if (simpleCond.objectEquals("filter_reminder_after")) {
            return new ReminderConditionAfter(date);
        }
        if (simpleCond.objectEquals("filter_reminder_before")) {
            return new ReminderConditionBefore(date);
        }
        return null;
    }
}

