/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode.stylemode;

import java.awt.EventQueue;
import java.util.Collections;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ShowSelectionAsRectangleAction;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.ModelessAttributeController;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.mindmapmode.MCloudController;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mapio.mindmapmode.MMapIO;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.styles.mindmapmode.StyleEditorPanel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ToggleToolbarAction;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.main.mindmapmode.stylemode.DeleteLevelStyleAction;
import org.freeplane.main.mindmapmode.stylemode.DeleteUserStyleAction;
import org.freeplane.main.mindmapmode.stylemode.DialogController;
import org.freeplane.main.mindmapmode.stylemode.EditStylesAction;
import org.freeplane.main.mindmapmode.stylemode.NewLevelStyleAction;
import org.freeplane.main.mindmapmode.stylemode.NewUserStyleAction;
import org.freeplane.main.mindmapmode.stylemode.SModeController;
import org.freeplane.view.swing.map.ViewLayoutTypeAction;
import org.freeplane.view.swing.map.attribute.EditAttributesAction;
import org.freeplane.view.swing.map.mindmapmode.MMapViewController;
import org.freeplane.view.swing.ui.DefaultNodeMouseMotionListener;
import org.freeplane.view.swing.ui.UserInputListenerFactory;
import org.freeplane.view.swing.ui.mindmapmode.MMapMouseListener;

public class SModeControllerFactory {
    private static SModeControllerFactory instance;
    private SModeController modeController;

    static SModeControllerFactory getInstance() {
        if (instance == null) {
            instance = new SModeControllerFactory();
        }
        return instance;
    }

    Controller createController(JDialog dialog) {
        final Controller controller = new Controller(ResourceController.getResourceController());
        Controller.setCurrentController(controller);
        MMapViewController mapViewController = new MMapViewController(controller);
        DialogController viewController = new DialogController(controller, (IMapViewManager)mapViewController, dialog);
        controller.setViewController(viewController);
        FilterController.install();
        TextController.install();
        controller.addAction(new ViewLayoutTypeAction(MapViewLayout.OUTLINE));
        controller.addAction(new ShowSelectionAsRectangleAction());
        this.modeController = new SModeController(controller);
        controller.selectModeForBuild(this.modeController);
        this.modeController.addAction(new NewUserStyleAction());
        this.modeController.addAction(new DeleteUserStyleAction());
        this.modeController.addAction(new NewLevelStyleAction());
        this.modeController.addAction(new DeleteLevelStyleAction());
        UserInputListenerFactory userInputListenerFactory = new UserInputListenerFactory(this.modeController);
        userInputListenerFactory.setNodeMouseMotionListener(new DefaultNodeMouseMotionListener());
        this.modeController.setUserInputListenerFactory(userInputListenerFactory);
        controller.addExtension(ModelessAttributeController.class, new ModelessAttributeController());
        new MMapController(this.modeController);
        TextController.install(new MTextController(this.modeController));
        SpellCheckerController.install(this.modeController);
        IconController.install(new MIconController(this.modeController));
        NodeStyleController.install(new MNodeStyleController(this.modeController));
        EdgeController.install(new MEdgeController(this.modeController));
        CloudController.install(new MCloudController(this.modeController));
        NoteController.install(new MNoteController(this.modeController));
        LinkController.install(new MLinkController(this.modeController));
        MFileManager.install(new MFileManager());
        MMapIO.install(this.modeController);
        MLogicalStyleController logicalStyleController = new MLogicalStyleController(this.modeController);
        logicalStyleController.initS();
        LogicalStyleController.install(logicalStyleController);
        AttributeController.install(new MAttributeController(this.modeController));
        FormatController.install(new FormatController());
        ScannerController scannerController = new ScannerController();
        ScannerController.install(scannerController);
        scannerController.addParsersForStandardFormats();
        this.modeController.addAction(new EditAttributesAction());
        userInputListenerFactory.setMapMouseListener(new MMapMouseListener());
        JPopupMenu popupmenu = new JPopupMenu();
        userInputListenerFactory.setNodePopupMenu(popupmenu);
        FreeplaneToolBar toolBar = new FreeplaneToolBar("main_toolbar", 0);
        toolBar.putClientProperty("VISIBLE_PROPERTY_KEY", "toolbarVisible");
        userInputListenerFactory.addToolBar("/main_toolbar", 0, toolBar);
        userInputListenerFactory.addToolBar("/icon_toolbar", 1, ((MIconController)IconController.getController()).getIconToolBarScrollPane());
        userInputListenerFactory.addToolBar("/status", 3, controller.getViewController().getStatusBar());
        this.modeController.addAction(new ToggleToolbarAction("ToggleLeftToolbarAction", "/icon_toolbar"));
        MapStyle.install(false);
        controller.addModeController(this.modeController);
        controller.selectModeForBuild(this.modeController);
        SModeController modeController = this.modeController;
        StyleEditorPanel styleEditorPanel = new StyleEditorPanel(modeController, null, false);
        final MapController mapController = modeController.getMapController();
        mapController.addNodeSelectionListener(new INodeSelectionListener(){

            public void onSelect(NodeModel node) {
                final IMapSelection selection = controller.getSelection();
                if (selection == null) {
                    return;
                }
                if (selection.size() == 1 && node.depth() >= 2) {
                    return;
                }
                final NodeModel nextSelection = node.depth() < 2 ? (node.depth() == 1 && node.hasChildren() ? (NodeModel)node.getChildAt(0) : (NodeModel)node.getMap().getRootNode().getChildAt(0).getChildAt(0)) : node;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        selection.selectAsTheOnlyOneSelected(nextSelection);
                    }
                });
            }

            public void onDeselect(NodeModel node) {
            }
        });
        mapController.addNodeChangeListener(new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                NodeModel node = event.getNode();
                if (node.getUserObject().equals(MapStyleModel.DEFAULT_STYLE)) {
                    mapController.fireMapChanged(new MapChangeEvent(this, node.getMap(), "MAP_STYLES", null, null));
                }
            }
        });
        JScrollPane styleScrollPane = new JScrollPane(styleEditorPanel, 22, 31);
        UITools.setScrollbarIncrement(styleScrollPane);
        userInputListenerFactory.addToolBar("/format", 2, styleScrollPane);
        Set<String> emptySet = Collections.emptySet();
        modeController.updateMenus("/xml/stylemodemenu.xml", emptySet);
        this.modeController = null;
        return controller;
    }

    public static void install() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction(new EditStylesAction());
    }
}

