/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode.stylemode;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.main.mindmapmode.stylemode.DialogController;

class SModeController
extends MModeController {
    private int status = -1;

    public SModeController(Controller controller) {
        super(controller);
        JDialog dialog = ((DialogController)controller.getViewController()).getDialog();
        dialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                SModeController.this.status = -1;
            }
        });
        String key = "styledialog";
        AFreeplaneAction okAction = new AFreeplaneAction("styledialog.ok"){

            public void actionPerformed(ActionEvent e) {
                SModeController.this.status = 0;
                SModeController.this.closeDialog();
            }
        };
        controller.addAction(okAction);
        AFreeplaneAction cancelAction = new AFreeplaneAction("styledialog.cancel"){

            public void actionPerformed(ActionEvent e) {
                SModeController.this.status = 2;
                SModeController.this.closeDialog();
            }
        };
        controller.addAction(cancelAction);
        AFreeplaneAction tryToCloseAction = new AFreeplaneAction("QuitAction"){

            public void actionPerformed(ActionEvent e) {
                SModeController.this.tryToCloseDialog();
            }
        };
        controller.addAction(tryToCloseAction);
    }

    public int getStatus() {
        return this.status;
    }

    protected void closeDialog() {
        JDialog dialog = ((DialogController)this.getController().getViewController()).getDialog();
        ((Window)dialog).setVisible(false);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    void tryToCloseDialog() {
        String title;
        IMapViewManager mapViewManager = this.getController().getMapViewManager();
        MapModel map = mapViewManager.getModel();
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        JDialog dialog = ((DialogController)this.getController().getViewController()).getDialog();
        if (!undoHandler.canUndo()) {
            ((Window)dialog).setVisible(false);
            return;
        }
        String text = TextUtils.getText("save_unsaved_styles");
        int returnVal = JOptionPane.showOptionDialog(dialog, text, title = TextUtils.getText("SaveAction.text"), 1, 3, null, null, null);
        if (returnVal == 2 || returnVal == -1) {
            return;
        }
        this.setStatus(returnVal == 0 ? 0 : 2);
        ((Window)dialog).setVisible(false);
    }

    public void startup() {
    }
}

