/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode.stylemode;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.styles.StyleNamedObject;

public class NewUserStyleAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public NewUserStyleAction() {
        super("NewUserStyleAction");
    }

    public void actionPerformed(ActionEvent e) {
        IStyle style;
        String styleName = JOptionPane.showInputDialog(TextUtils.getText("enter_new_style_name"));
        if (styleName == null) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        NodeModel selectedNode = controller.getSelection().getSelected();
        MapModel map = controller.getMap();
        final MapStyleModel styleModel = MapStyleModel.getExtension(map);
        if (null != styleModel.getStyleNode(style = StyleFactory.create(styleName))) {
            UITools.errorMessage(TextUtils.getText("style_already_exists"));
            return;
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        final NodeModel newNode = new NodeModel(map);
        newNode.setUserObject(style);
        Controller.getCurrentModeController().copyExtensions((Object)LogicalStyleKeys.NODE_STYLE, selectedNode, newNode);
        Controller.getCurrentModeController().copyExtensions((Object)MIconController.Keys.ICONS, selectedNode, newNode);
        NodeModel userStyleParentNode = styleModel.getStyleNodeGroup(map, "styles.user-defined");
        if (userStyleParentNode == null) {
            userStyleParentNode = new NodeModel(map);
            userStyleParentNode.setUserObject(new StyleNamedObject("styles.user-defined"));
            mapController.insertNode(userStyleParentNode, map.getRootNode(), false, false, true);
        }
        mapController.insertNode(newNode, userStyleParentNode, false, false, true);
        mapController.select(newNode);
        IActor actor = new IActor(){

            public void undo() {
                styleModel.removeStyleNode(newNode);
            }

            public String getDescription() {
                return "NewStyle";
            }

            public void act() {
                styleModel.addStyleNode(newNode);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }
}

