/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode.stylemode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.main.mindmapmode.stylemode.AEditStylesAction;
import org.freeplane.main.mindmapmode.stylemode.DialogController;
import org.freeplane.main.mindmapmode.stylemode.SModeController;

public class EditStylesAction
extends AEditStylesAction {
    public EditStylesAction() {
        super("EditStylesAction");
    }

    public void actionPerformed(ActionEvent e) {
        MapModel map = Controller.getCurrentController().getMap();
        MapStyleModel mapStyleModel = MapStyleModel.getExtension(map);
        MapModel styleMap = mapStyleModel.getStyleMap();
        if (styleMap == null) {
            UITools.errorMessage(TextUtils.getText("no_styles_found_in_map"));
            return;
        }
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        undoHandler.startTransaction();
        this.init();
        SModeController modeController = this.getModeController();
        modeController.getMapController().newMapView(styleMap);
        Controller controller = modeController.getController();
        Component mapViewComponent = controller.getMapViewManager().getMapViewComponent();
        ((DialogController)controller.getViewController()).setMapView(mapViewComponent);
        this.dialog.setLocationRelativeTo(Controller.getCurrentController().getViewController().getJFrame());
        this.dialog.setVisible(true);
    }

    void commit() {
        MapModel currentMap = Controller.getCurrentController().getMap();
        LogicalStyleController.getController().refreshMap(currentMap);
        ModeController currentModeController = Controller.getCurrentModeController();
        currentModeController.commit();
    }

    void rollback() {
        Controller.getCurrentModeController().rollback();
    }
}

