/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode.stylemode;

import java.awt.event.ActionEvent;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleFactory;

public class DeleteLevelStyleAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public DeleteLevelStyleAction() {
        super("DeleteLevelStyleAction");
    }

    public void actionPerformed(ActionEvent e) {
        ModeController modeController = Controller.getCurrentModeController();
        MapModel map = Controller.getCurrentController().getMap();
        NodeModel levelStyleParentNode = this.getLevelStyleParentNode(map);
        int childNumber = levelStyleParentNode.getChildCount() - 1;
        if (childNumber < 1) {
            UITools.errorMessage(TextUtils.getText("can_not_delete_root_style"));
            return;
        }
        String styleName = "AutomaticLayout.level," + childNumber;
        IStyle styleObject = StyleFactory.create(NamedObject.format(styleName));
        final MapStyleModel styleModel = MapStyleModel.getExtension(map);
        MMapController mapController = (MMapController)modeController.getMapController();
        final NodeModel node = styleModel.getStyleNode(styleObject);
        mapController.deleteNode(node);
        IActor actor = new IActor(){

            public void undo() {
                styleModel.addStyleNode(node);
            }

            public String getDescription() {
                return "DeleteStyle";
            }

            public void act() {
                styleModel.removeStyleNode(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }

    private NodeModel getLevelStyleParentNode(MapModel map) {
        return (NodeModel)map.getRootNode().getChildAt(1);
    }
}

