/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode.stylemode;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import org.freeplane.core.resources.WindowConfigurationStorage;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.main.mindmapmode.stylemode.SModeController;
import org.freeplane.main.mindmapmode.stylemode.SModeControllerFactory;

abstract class AEditStylesAction
extends AFreeplaneAction {
    private Controller controller = null;
    private SModeController modeController;
    private static final long serialVersionUID = 1L;
    protected JDialog dialog;

    abstract void commit();

    abstract void rollback();

    public AEditStylesAction(String key) {
        super(key);
    }

    SModeController getModeController() {
        return this.modeController;
    }

    protected void init() {
        this.controller = Controller.getCurrentController();
        if (this.dialog != null) {
            Controller.setCurrentController((Controller)this.dialog.getRootPane().getClientProperty(Controller.class));
            return;
        }
        this.dialog = new JDialog(Controller.getCurrentController().getViewController().getJFrame());
        WindowConfigurationStorage windowConfigurationStorage = new WindowConfigurationStorage(this.getKey() + ".dialog");
        windowConfigurationStorage.restoreDialogPositions(this.dialog);
        this.dialog.setModal(true);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AEditStylesAction.this.getModeController().tryToCloseDialog();
            }
        });
        Controller controller = SModeControllerFactory.getInstance().createController(this.dialog);
        this.modeController = (SModeController)controller.getModeController();
        ViewController viewController = controller.getViewController();
        viewController.init(controller);
        this.dialog.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                WindowConfigurationStorage windowConfigurationStorage = new WindowConfigurationStorage(AEditStylesAction.this.getKey() + ".dialog");
                windowConfigurationStorage.storeDialogPositions(AEditStylesAction.this.dialog);
                IMapViewManager mapViewManager = AEditStylesAction.this.modeController.getController().getMapViewManager();
                MapModel map = mapViewManager.getModel();
                IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
                mapViewManager.close(true);
                Controller.setCurrentController(AEditStylesAction.this.controller);
                super.componentHidden(e);
                switch (AEditStylesAction.this.modeController.getStatus()) {
                    case 0: {
                        if (undoHandler.canUndo()) {
                            AEditStylesAction.this.commit();
                            break;
                        }
                    }
                    case 2: {
                        AEditStylesAction.this.rollback();
                    }
                }
            }
        });
    }
}

