/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IEditHandler;
import org.freeplane.core.ui.SetAcceleratorOnNextClickAction;
import org.freeplane.core.ui.components.FButtonBar;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.JResizer;
import org.freeplane.core.ui.components.OneTouchCollapseResizer;
import org.freeplane.core.ui.components.ResizeEvent;
import org.freeplane.core.ui.components.ResizerListener;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.mindmapmode.AddAttributeAction;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.attribute.mindmapmode.RemoveAllAttributesAction;
import org.freeplane.features.attribute.mindmapmode.RemoveFirstAttributeAction;
import org.freeplane.features.attribute.mindmapmode.RemoveLastAttributeAction;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.clipboard.mindmapmode.MClipboardController;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.mindmapmode.MCloudController;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.mindmapmode.AutomaticEdgeColorHook;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.encrypt.mindmapmode.MEncryptionController;
import org.freeplane.features.export.mindmapmode.ExportController;
import org.freeplane.features.export.mindmapmode.ImportMindmanagerFiles;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.icon.HierarchicalIcons;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.mindmapmode.IconSelectionPlugin;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.AlwaysUnfoldedNode;
import org.freeplane.features.map.FoldingController;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.mindmapmode.ChangeNodeLevelController;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.NewParentNode;
import org.freeplane.features.mapio.mindmapmode.MMapIO;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.RevisionPlugin;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.styles.AutomaticLayoutController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.styles.mindmapmode.MUIFactory;
import org.freeplane.features.styles.mindmapmode.ShowFormatPanelAction;
import org.freeplane.features.styles.mindmapmode.StyleEditorPanel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.text.mindmapmode.SortNodes;
import org.freeplane.features.text.mindmapmode.SplitNode;
import org.freeplane.features.time.CreationModificationPlugin;
import org.freeplane.features.ui.ToggleToolbarAction;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.features.url.mindmapmode.SaveAll;
import org.freeplane.main.mindmapmode.MToolbarContributor;
import org.freeplane.main.mindmapmode.stylemode.SModeControllerFactory;
import org.freeplane.view.swing.features.BlinkingNodeHook;
import org.freeplane.view.swing.features.FitToPage;
import org.freeplane.view.swing.features.filepreview.AddExternalImageAction;
import org.freeplane.view.swing.features.filepreview.ChangeExternalImageAction;
import org.freeplane.view.swing.features.filepreview.RemoveExternalImageAction;
import org.freeplane.view.swing.features.filepreview.ViewerController;
import org.freeplane.view.swing.features.nodehistory.NodeHistory;
import org.freeplane.view.swing.features.progress.mindmapmode.ProgressFactory;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderHook;
import org.freeplane.view.swing.map.ShowNotesInMapAction;
import org.freeplane.view.swing.map.attribute.AttributePanelManager;
import org.freeplane.view.swing.map.attribute.EditAttributesAction;
import org.freeplane.view.swing.ui.DefaultNodeKeyListener;
import org.freeplane.view.swing.ui.UserInputListenerFactory;
import org.freeplane.view.swing.ui.mindmapmode.MMapMouseListener;
import org.freeplane.view.swing.ui.mindmapmode.MNodeDragListener;
import org.freeplane.view.swing.ui.mindmapmode.MNodeDropListener;
import org.freeplane.view.swing.ui.mindmapmode.MNodeMotionListener;

public class MModeControllerFactory {
    private static MModeControllerFactory instance;
    private MModeController modeController;
    private MUIFactory uiFactory;

    public static MModeController createModeController() {
        return MModeControllerFactory.getInstance().createModeControllerImpl();
    }

    private static MModeControllerFactory getInstance() {
        if (instance == null) {
            instance = new MModeControllerFactory();
        }
        return instance;
    }

    private void createAddIns() {
        StyleEditorPanel panel = new StyleEditorPanel(this.modeController, this.uiFactory, true);
        JScrollPane styleScrollPane = new JScrollPane(panel, 22, 30);
        UITools.setScrollbarIncrement(styleScrollPane);
        JComponent tabs = (JComponent)this.modeController.getUserInputListenerFactory().getToolBar("/format").getComponent(1);
        tabs.add(TextUtils.getText("format_panel"), styleScrollPane);
        new AttributePanelManager(this.modeController);
        new HierarchicalIcons();
        new AutomaticLayoutController();
        new BlinkingNodeHook();
        SummaryNode.install();
        AlwaysUnfoldedNode.install();
        FreeNode.install();
        new CreationModificationPlugin();
        this.modeController.addExtension(ReminderHook.class, new ReminderHook(this.modeController));
        new AutomaticEdgeColorHook();
        new ViewerController();
        this.modeController.addAction(new AddAttributeAction());
        this.modeController.addAction(new RemoveFirstAttributeAction());
        this.modeController.addAction(new RemoveLastAttributeAction());
        this.modeController.addAction(new RemoveAllAttributesAction());
        this.modeController.addAction(new AddExternalImageAction());
        this.modeController.addAction(new RemoveExternalImageAction());
        this.modeController.addAction(new ChangeExternalImageAction());
        this.modeController.addAction(new ShowFormatPanelAction());
        this.modeController.addAction(new FitToPage());
        MEncryptionController.install(new MEncryptionController(this.modeController));
        this.modeController.addAction(new IconSelectionPlugin());
        this.modeController.addAction(new NewParentNode());
        this.modeController.addAction(new SaveAll());
        this.modeController.addAction(new SortNodes());
        this.modeController.addAction(new SplitNode());
        new ChangeNodeLevelController(this.modeController);
        NodeHistory.install(this.modeController);
        this.modeController.addAction(new ImportMindmanagerFiles());
    }

    private MModeController createModeControllerImpl() {
        this.createStandardControllers();
        this.createAddIns();
        return this.modeController;
    }

    private void createStandardControllers() {
        Controller controller = Controller.getCurrentController();
        this.modeController = new MModeController(controller);
        UserInputListenerFactory userInputListenerFactory = new UserInputListenerFactory(this.modeController);
        MNodeMotionListener nodeMouseMotionListener = new MNodeMotionListener();
        userInputListenerFactory.setNodeMouseMotionListener(nodeMouseMotionListener);
        JPopupMenu popupmenu = new JPopupMenu();
        userInputListenerFactory.setNodePopupMenu(popupmenu);
        this.modeController.setUserInputListenerFactory(userInputListenerFactory);
        controller.addModeController(this.modeController);
        controller.selectModeForBuild(this.modeController);
        new MMapController(this.modeController);
        MFileManager fileManager = new MFileManager();
        UrlManager.install(fileManager);
        MMapIO.install(this.modeController);
        controller.getMapViewManager().addMapViewChangeListener(fileManager);
        IconController.install(new MIconController(this.modeController));
        new ProgressFactory().installActions(this.modeController);
        MapController mapController = this.modeController.getMapController();
        EdgeController.install(new MEdgeController(this.modeController));
        CloudController.install(new MCloudController(this.modeController));
        NoteController.install(new MNoteController(this.modeController));
        userInputListenerFactory.setMapMouseListener(new MMapMouseListener());
        final MTextController textController = new MTextController(this.modeController);
        TextController.install(textController);
        LinkController.install(new MLinkController(this.modeController));
        NodeStyleController.install(new MNodeStyleController(this.modeController));
        ClipboardController.install(new MClipboardController());
        userInputListenerFactory.setNodeDragListener(new MNodeDragListener());
        userInputListenerFactory.setNodeDropTargetListener(new MNodeDropListener());
        LocationController.install(new MLocationController());
        MLogicalStyleController logicalStyleController = new MLogicalStyleController(this.modeController);
        LogicalStyleController.install(logicalStyleController);
        logicalStyleController.initM();
        AttributeController.install(new MAttributeController(this.modeController));
        userInputListenerFactory.setNodeKeyListener(new DefaultNodeKeyListener(new IEditHandler(){

            public void edit(KeyEvent e, IEditHandler.FirstAction action, boolean editLong) {
                ((MTextController)MTextController.getController(MModeControllerFactory.this.modeController)).getEventQueue().activate(e);
                textController.edit(action, editLong);
            }
        }));
        userInputListenerFactory.setNodeMotionListener(new MNodeMotionListener());
        this.modeController.addAction(new EditAttributesAction());
        SpellCheckerController.install(this.modeController);
        ExportController.install(new ExportController("/xml/ExportWithXSLT.xml"));
        MapStyle.install(true);
        FreeplaneToolBar toolbar = new FreeplaneToolBar("main_toolbar", 0);
        toolbar.putClientProperty("VISIBLE_PROPERTY_KEY", "toolbarVisible");
        userInputListenerFactory.addToolBar("/main_toolbar", 0, toolbar);
        userInputListenerFactory.addToolBar("/filter_toolbar", 0, FilterController.getController(controller).getFilterToolbar());
        userInputListenerFactory.addToolBar("/status", 3, controller.getViewController().getStatusBar());
        final JTabbedPane tabs = new JTabbedPane();
        Box resisableTabs = Box.createHorizontalBox();
        String TABBEDPANE_VIEW_COLLAPSED = "tabbed_pane.collapsed";
        String TABBEDPANE_VIEW_WIDTH = "tabbed_pane.width";
        boolean expanded = true;
        try {
            expanded = !Boolean.parseBoolean(ResourceController.getResourceController().getProperty("tabbed_pane.collapsed", "false"));
        }
        catch (Exception e) {
            // empty catch block
        }
        OneTouchCollapseResizer otcr = new OneTouchCollapseResizer(JResizer.Direction.RIGHT, OneTouchCollapseResizer.CollapseDirection.COLLAPSE_RIGHT);
        resisableTabs.add(otcr);
        resisableTabs.add(tabs);
        otcr.addResizerListener(new ResizerListener(){

            public void componentResized(ResizeEvent event) {
                if (event.getSource().equals(tabs)) {
                    ResourceController.getResourceController().setProperty("tabbed_pane.width", String.valueOf(((JComponent)event.getSource()).getPreferredSize().width));
                }
            }
        });
        otcr.addCollapseListener(new OneTouchCollapseResizer.ComponentCollapseListener(){

            public void componentCollapsed(ResizeEvent event) {
                if (event.getSource().equals(tabs)) {
                    ResourceController.getResourceController().setProperty("tabbed_pane.collapsed", "true");
                }
            }

            public void componentExpanded(ResizeEvent event) {
                if (event.getSource().equals(tabs)) {
                    ResourceController.getResourceController().setProperty("tabbed_pane.collapsed", "false");
                }
            }
        });
        try {
            int width = Integer.parseInt(ResourceController.getResourceController().getProperty("tabbed_pane.width", "350"));
            tabs.setPreferredSize(new Dimension(width, 40));
        }
        catch (Exception e) {
            // empty catch block
        }
        otcr.setExpanded(expanded);
        resisableTabs.putClientProperty("VISIBLE_PROPERTY_KEY", "styleScrollPaneVisible");
        this.modeController.getUserInputListenerFactory().addToolBar("/format", 2, resisableTabs);
        FButtonBar fButtonToolBar = new FButtonBar(controller.getViewController().getRootPaneContainer().getRootPane());
        fButtonToolBar.putClientProperty("VISIBLE_PROPERTY_KEY", "fbarVisible");
        fButtonToolBar.setVisible(ResourceController.getResourceController().getBooleanProperty("fbarVisible"));
        userInputListenerFactory.addToolBar("/fbuttons", 0, fButtonToolBar);
        controller.addAction(new ToggleToolbarAction("ToggleFBarAction", "/fbuttons"));
        SModeControllerFactory.install();
        this.modeController.addAction(new SetAcceleratorOnNextClickAction());
        this.modeController.addAction(new ShowNotesInMapAction());
        userInputListenerFactory.getMenuBuilder().setAcceleratorChangeListener(fButtonToolBar);
        userInputListenerFactory.addToolBar("/icon_toolbar", 1, ((MIconController)IconController.getController()).getIconToolBarScrollPane());
        this.modeController.addAction(new ToggleToolbarAction("ToggleLeftToolbarAction", "/icon_toolbar"));
        new RevisionPlugin();
        FoldingController.install(new FoldingController());
        this.uiFactory = new MUIFactory();
        mapController.addNodeChangeListener(this.uiFactory);
        mapController.addNodeSelectionListener(this.uiFactory);
        mapController.addMapChangeListener(this.uiFactory);
        controller.getMapViewManager().addMapSelectionListener(this.uiFactory);
        MToolbarContributor menuContributor = new MToolbarContributor(this.uiFactory);
        this.modeController.addMenuContributor(menuContributor);
    }
}

