/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.filemode;

import javax.swing.JPopupMenu;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.filemode.CenterAction;
import org.freeplane.features.map.filemode.FMapController;
import org.freeplane.features.map.filemode.OpenPathAction;
import org.freeplane.features.mapio.MapIO;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.filemode.FModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.text.TextController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.view.swing.features.nodehistory.NodeHistory;
import org.freeplane.view.swing.ui.UserInputListenerFactory;

public class FModeControllerFactory {
    private static FModeController modeController;

    public static FModeController createModeController() {
        Controller controller = Controller.getCurrentController();
        modeController = new FModeController(controller);
        UserInputListenerFactory userInputListenerFactory = new UserInputListenerFactory(modeController);
        modeController.setUserInputListenerFactory(userInputListenerFactory);
        controller.addModeController(modeController);
        controller.selectModeForBuild(modeController);
        new FMapController(modeController);
        UrlManager.install(new UrlManager());
        MapIO.install(modeController);
        IconController.install(new IconController(modeController));
        NodeStyleController.install(new NodeStyleController(modeController));
        EdgeController.install(new EdgeController(modeController));
        TextController.install(new TextController(modeController));
        LinkController.install(new LinkController());
        CloudController.install(new CloudController(modeController));
        ClipboardController.install(new ClipboardController());
        LocationController.install(new LocationController());
        LogicalStyleController.install(new LogicalStyleController(modeController));
        MapStyle.install(true);
        NodeStyleController.getController().addShapeGetter(new Integer(0), new IPropertyHandler<String, NodeModel>(){

            @Override
            public String getProperty(NodeModel node, String currentValue) {
                return "fork";
            }
        });
        modeController.addAction(new CenterAction());
        modeController.addAction(new OpenPathAction());
        userInputListenerFactory.setNodePopupMenu(new JPopupMenu());
        FreeplaneToolBar toolBar = new FreeplaneToolBar("main_toolbar", 0);
        toolBar.putClientProperty("VISIBLE_PROPERTY_KEY", "toolbarVisible");
        userInputListenerFactory.addToolBar("/main_toolbar", 0, toolBar);
        userInputListenerFactory.addToolBar("/filter_toolbar", 0, FilterController.getCurrentFilterController().getFilterToolbar());
        userInputListenerFactory.addToolBar("/status", 3, controller.getViewController().getStatusBar());
        NodeHistory.install(modeController);
        return modeController;
    }
}

