/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JLabel;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.main.application.ApplicationResourceController;

public class UserPropertiesUpdater {
    private static final String ORG_FREEPLANE_OLD_USERFPDIR = "org.freeplane.old_userfpdir";

    void importOldProperties() {
        File userPreferencesFile = ApplicationResourceController.getUserPreferencesFile();
        if (userPreferencesFile.exists()) {
            return;
        }
        this.copyUserFilesFromPreviousVersionTo(userPreferencesFile.getParentFile());
        if (userPreferencesFile.exists()) {
            this.removeOpenedMaps(userPreferencesFile);
            return;
        }
        File oldUserPreferencesFile = new File(System.getProperty("user.home"), ".freeplane/auto.properties");
        if (!oldUserPreferencesFile.exists()) {
            return;
        }
        this.importOldPreferences(userPreferencesFile, oldUserPreferencesFile);
        this.importOldIcons();
    }

    private void copyUserFilesFromPreviousVersionTo(File targetDirectory) {
        File parentDirectory = targetDirectory.getParentFile();
        String previousDirName = "1.2.x";
        String old_userfpdir = System.getProperty(ORG_FREEPLANE_OLD_USERFPDIR);
        File sourceDirectory = this.isDefined(old_userfpdir) ? new File(old_userfpdir, "1.2.x") : new File(parentDirectory, "1.2.x");
        if (sourceDirectory.exists() && !sourceDirectory.getAbsolutePath().equals(targetDirectory.getAbsolutePath())) {
            try {
                parentDirectory.mkdirs();
                org.apache.commons.io.FileUtils.copyDirectory((File)sourceDirectory, (File)targetDirectory);
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
    }

    private boolean isDefined(String old_userfpdir) {
        return old_userfpdir != null;
    }

    private void importOldPreferences(File userPreferencesFile, File oldUserPreferencesFile) {
        try {
            Properties userProp = this.loadProperties(userPreferencesFile);
            userProp.remove("lastOpened_1.0.20");
            userProp.remove("openedNow_1.0.20");
            userProp.remove("browse_url_storage");
            this.fixFontSize(userProp, "defaultfontsize");
            this.fixFontSize(userProp, "label_font_size");
            this.saveProperties(userProp, userPreferencesFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void removeOpenedMaps(File userPreferencesFile) {
        try {
            Properties userProp = this.loadProperties(userPreferencesFile);
            userProp.remove("lastOpened_1.0.20");
            userProp.remove("openedNow_1.0.20");
            userProp.remove("browse_url_storage");
            userProp.remove("single_backup_directory_path");
            this.saveProperties(userProp, userPreferencesFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties loadProperties(File userPreferencesFile) throws IOException {
        FileInputStream inputStream = null;
        Properties userProp = new Properties();
        try {
            inputStream = new FileInputStream(userPreferencesFile);
            userProp.load(inputStream);
        }
        catch (Throwable throwable) {
            FileUtils.silentlyClose(inputStream);
            throw throwable;
        }
        FileUtils.silentlyClose(inputStream);
        return userProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveProperties(Properties userProp, File userPreferencesFile) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(userPreferencesFile);
            userProp.store(outputStream, null);
        }
        catch (Throwable throwable) {
            FileUtils.silentlyClose(outputStream);
            throw throwable;
        }
        FileUtils.silentlyClose(outputStream);
    }

    private void fixFontSize(Properties userProp, String name) {
        Object defaultFontSizeObj = userProp.remove(name);
        if (defaultFontSizeObj == null) {
            return;
        }
        try {
            int oldDefaultFontSize = Integer.parseInt(defaultFontSizeObj.toString());
            int newDefaultFontSize = Math.round((float)oldDefaultFontSize / UITools.FONT_SCALE_FACTOR);
            userProp.put(name, Integer.toString(newDefaultFontSize));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    void importOldDefaultStyle() {
        File userDefault;
        ModeController modeController = Controller.getCurrentController().getModeController("MindMap");
        MFileManager fm = MFileManager.getController(modeController);
        String standardTemplateName = fm.getStandardTemplateName();
        File absolute = new File(standardTemplateName);
        if (absolute.isAbsolute()) {
            userDefault = absolute;
        } else {
            File userTemplates = fm.defaultUserTemplateDir();
            userDefault = new File(userTemplates, standardTemplateName);
        }
        if (userDefault.exists()) {
            return;
        }
        userDefault.getParentFile().mkdirs();
        if (!userDefault.getParentFile().exists()) {
            return;
        }
        MapModel defaultStyleMap = new MapModel();
        File allUserTemplates = fm.defaultStandardTemplateDir();
        File standardTemplate = new File(allUserTemplates, "standard.mm");
        try {
            fm.loadCatchExceptions(standardTemplate.toURL(), defaultStyleMap);
        }
        catch (Exception e) {
            LogUtils.warn(e);
            try {
                fm.loadCatchExceptions(ResourceController.getResourceController().getResource("/styles/viewer_standard.mm"), defaultStyleMap);
            }
            catch (Exception e2) {
                defaultStyleMap.createNewRoot();
                LogUtils.severe(e);
            }
        }
        NodeStyleController nodeStyleController = NodeStyleController.getController(modeController);
        this.updateDefaultStyle(nodeStyleController, defaultStyleMap);
        this.updateNoteStyle(nodeStyleController, defaultStyleMap);
        try {
            fm.writeToFile(defaultStyleMap, userDefault);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void updateDefaultStyle(NodeStyleController nodeStyleController, MapModel defaultStyleMap) {
        NodeModel styleNode1;
        NodeModel styleNode = styleNode1 = MapStyleModel.getExtension(defaultStyleMap).getStyleNode(MapStyleModel.DEFAULT_STYLE);
        styleNode.removeExtension(NodeStyleModel.class);
        styleNode.removeExtension(EdgeModel.class);
        NodeStyleModel nodeStyleModel = new NodeStyleModel();
        nodeStyleModel.setBackgroundColor(nodeStyleController.getBackgroundColor(styleNode));
        nodeStyleModel.setBold(nodeStyleController.isBold(styleNode));
        nodeStyleModel.setColor(nodeStyleController.getColor(styleNode));
        nodeStyleModel.setFontFamilyName(nodeStyleController.getFontFamilyName(styleNode));
        nodeStyleModel.setFontSize(nodeStyleController.getFontSize(styleNode));
        nodeStyleModel.setItalic(nodeStyleController.isItalic(styleNode));
        nodeStyleModel.setShape(nodeStyleController.getShape(styleNode));
        styleNode.addExtension(nodeStyleModel);
        NodeSizeModel nodeSizeModel = new NodeSizeModel();
        nodeSizeModel.setMaxNodeWidth(nodeStyleController.getMaxWidth(styleNode));
        nodeSizeModel.setMinNodeWidth(nodeStyleController.getMinWidth(styleNode));
        EdgeModel standardEdgeModel = EdgeModel.getModel(styleNode);
        if (standardEdgeModel != null) {
            EdgeModel edgeModel = new EdgeModel();
            edgeModel.setColor(standardEdgeModel.getColor());
            edgeModel.setStyle(standardEdgeModel.getStyle());
            edgeModel.setWidth(standardEdgeModel.getWidth());
            styleNode.addExtension(edgeModel);
        }
    }

    private void updateNoteStyle(NodeStyleController nodeStyleController, MapModel defaultStyleMap) {
        if (ResourceController.getResourceController().getBooleanProperty("resources_use_default_font_for_notes_too")) {
            return;
        }
        NodeModel styleNode = MapStyleModel.getExtension(defaultStyleMap).getStyleNode(MapStyleModel.NOTE_STYLE);
        if (styleNode == null) {
            return;
        }
        styleNode.removeExtension(NodeStyleModel.class);
        Font defaultFont = new JLabel().getFont();
        NodeStyleModel nodeStyleModel = new NodeStyleModel();
        nodeStyleModel.setFontFamilyName(defaultFont.getFamily());
        nodeStyleModel.setFontSize(defaultFont.getSize());
        styleNode.addExtension(nodeStyleModel);
    }

    private void importOldIcons() {
        File oldUserPreferencesFile = new File(System.getProperty("user.home"), ".freeplane/auto.properties");
        if (!oldUserPreferencesFile.exists()) {
            return;
        }
        File userPreferencesFile = ApplicationResourceController.getUserPreferencesFile();
        File iconDir = new File(userPreferencesFile.getParentFile(), "icons");
        if (iconDir.exists()) {
            return;
        }
        LogUtils.info("creating user icons directory " + iconDir);
        iconDir.mkdirs();
        File oldIconDir = new File(oldUserPreferencesFile.getParentFile(), "icons");
        if (oldIconDir.exists()) {
            try {
                org.apache.commons.io.FileUtils.copyDirectory((File)oldIconDir, (File)iconDir);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

