/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.main.application.HttpVersionClient;

class UpdateCheckAction
extends AFreeplaneAction {
    private static boolean autorunEnabled = true;
    private static Timer autorunTimer = null;
    private static final int CHECK_TIME = 30000;
    private static final String CHECK_UPDATES_AUTOMATICALLY = "check_updates_automatically";
    private static final String LAST_UPDATE_CHECK_TIME = "last_update_check_time";
    private static final String LAST_UPDATE_VERSION = "last_update_verson";
    private static final long serialVersionUID = 1L;
    private static final int TWO_DAYS = 86400000;
    private static final String UPDATE_BUTTON_LOCATION = "main_toolbar_update";
    private static final String UPDATE_BUTTON_PATH = "main_toolbar_update/checkUpdate";
    private static final String WEB_UPDATE_LOCATION_KEY = "webUpdateLocation";
    private ActionListener openUrlListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            try {
                Controller.getCurrentController().getViewController().openDocument(new URL(((JButton)e.getSource()).getActionCommand()));
            }
            catch (MalformedURLException ex) {
                UITools.errorMessage(TextUtils.getText("url_error") + "\n" + ex);
            }
            catch (Exception ex) {
                UITools.errorMessage(ex);
            }
        }
    };

    public UpdateCheckAction() {
        super("UpdateCheckAction");
        final Controller controller = Controller.getCurrentController();
        controller.getMapViewManager().addMapViewChangeListener(new IMapViewChangeListener(){

            public void afterViewChange(Component oldView, Component newView) {
                if (newView == null) {
                    return;
                }
                controller.getViewController().invokeLater(new Runnable(){

                    public void run() {
                        this.removeMe();
                    }
                });
                UpdateCheckAction.this.setTimer();
            }

            public void afterViewClose(Component oldView) {
            }

            public void afterViewCreated(Component mapView) {
            }

            public void beforeViewChange(Component oldView, Component newView) {
            }

            private void removeMe() {
                controller.getMapViewManager().removeMapViewChangeListener(this);
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        final boolean autoRun = e.getSource().equals(autorunTimer);
        if (autorunTimer != null) {
            autorunTimer.stop();
            autorunTimer = null;
        }
        new Thread(new Runnable(){

            public void run() {
                UpdateCheckAction.this.checkForUpdates(autoRun);
            }
        }, "checkForUpdates").start();
    }

    private void addUpdateButton(FreeplaneVersion lastVersion) {
        Controller controller = Controller.getCurrentController();
        Set<String> modes = controller.getModes();
        for (String mode : modes) {
            MenuBuilder menuBuilder = controller.getModeController(mode).getUserInputListenerFactory().getMenuBuilder();
            if (lastVersion == null || lastVersion.compareTo(FreeplaneVersion.getVersion()) <= 0) {
                ResourceController.getResourceController().setProperty(LAST_UPDATE_VERSION, "");
                if (menuBuilder.get(UPDATE_BUTTON_PATH) == null) continue;
                menuBuilder.removeElement(UPDATE_BUTTON_PATH);
                continue;
            }
            ResourceController.getResourceController().setProperty(LAST_UPDATE_VERSION, lastVersion.toString());
            String updateAvailable = TextUtils.format("new_version_available", lastVersion.toString());
            controller.getViewController().out(updateAvailable);
            this.putValue("ShortDescription", updateAvailable);
            this.putValue("LongDescription", updateAvailable);
            if (menuBuilder.get(UPDATE_BUTTON_PATH) != null) continue;
            menuBuilder.addAction(UPDATE_BUTTON_LOCATION, UPDATE_BUTTON_PATH, this, 0);
        }
    }

    private void checkForUpdates(final boolean autoRun) {
        boolean connectSuccessfull;
        String history;
        FreeplaneVersion lastVersion;
        Date now = new Date();
        ResourceController.getResourceController().setProperty(LAST_UPDATE_CHECK_TIME, Long.toString(now.getTime()));
        Locale defaultLocale = Locale.getDefault();
        String language = defaultLocale.getLanguage();
        String DEFAULT_LANGUAGE = "en";
        String translatedWebUpdate = this.getWebUpdateUrl(language);
        final FreeplaneVersion localVersion = FreeplaneVersion.getVersion();
        HttpVersionClient translatedVersionClient = new HttpVersionClient(translatedWebUpdate, localVersion);
        FreeplaneVersion lastTranslatedVersion = translatedVersionClient.getRemoteVersion();
        if (lastTranslatedVersion == null) {
            lastTranslatedVersion = localVersion;
        }
        if (!language.equals("en")) {
            String defaultWebUpdate = this.getWebUpdateUrl("en");
            HttpVersionClient defaultVersionClient = new HttpVersionClient(defaultWebUpdate, lastTranslatedVersion);
            lastVersion = defaultVersionClient.getRemoteVersion();
            history = defaultVersionClient.getHistory() + translatedVersionClient.getHistory();
            connectSuccessfull = defaultVersionClient.isSuccessful();
        } else {
            lastVersion = lastTranslatedVersion;
            history = translatedVersionClient.getHistory();
            connectSuccessfull = translatedVersionClient.isSuccessful();
        }
        this.checkForAddonsUpdates();
        Controller.getCurrentController().getViewController().invokeLater(new Runnable(){

            public void run() {
                UpdateCheckAction.this.addUpdateButton(lastVersion);
                if (autoRun) {
                    return;
                }
                UpdateCheckAction.this.showUpdateDialog(connectSuccessfull, localVersion, lastVersion, history);
            }
        });
    }

    private void checkForAddonsUpdates() {
        List<AddOnProperties> installedAddOns = AddOnsController.getController().getInstalledAddOns();
        LogUtils.info("checking for updates of " + installedAddOns.size() + " add-ons");
        for (AddOnProperties addOnProperties : installedAddOns) {
            FreeplaneVersion addOnLocalVersion = this.toFreeplaneVersion(addOnProperties.getVersion());
            URL updateUrl = addOnProperties.getUpdateUrl();
            if (updateUrl == null) continue;
            String addOnUpdateRequest = updateUrl + "?v=" + addOnLocalVersion.toString();
            HttpVersionClient versionClient = new HttpVersionClient(addOnUpdateRequest, addOnLocalVersion);
            FreeplaneVersion latestVersion = versionClient.getRemoteVersion();
            boolean connectSuccesfull = versionClient.isSuccessful();
            if (!connectSuccesfull) continue;
            addOnProperties.setLatestVersion(latestVersion.toString());
            if (versionClient.getRemoteVersionDownloadUrl() != null) {
                addOnProperties.setLatestVersionDownloadUrl(versionClient.getRemoteVersionDownloadUrl());
            }
            if (versionClient.getRemoteVersionChangelogUrl() == null) continue;
            addOnProperties.setLatestVersionChangelogUrl(versionClient.getRemoteVersionChangelogUrl());
        }
    }

    private String getWebUpdateUrl(String language) {
        String webUpdateUrl = ResourceController.getResourceController().getProperty(WEB_UPDATE_LOCATION_KEY);
        FreeplaneVersion localVersion = FreeplaneVersion.getVersion();
        StringBuilder sb = new StringBuilder(webUpdateUrl);
        String type = localVersion.getType();
        if (!type.equals("")) {
            sb.append(type);
            sb.append('/');
        }
        sb.append("history_");
        sb.append(language);
        sb.append(".txt");
        return sb.toString();
    }

    private FreeplaneVersion getKnownNewVersion() {
        FreeplaneVersion localVersion = FreeplaneVersion.getVersion();
        String property = ResourceController.getResourceController().getProperty(LAST_UPDATE_VERSION);
        if (property.equals("")) {
            return null;
        }
        FreeplaneVersion lastVersion = FreeplaneVersion.getVersion(property);
        if (lastVersion.compareTo(localVersion) <= 0) {
            lastVersion = null;
        }
        return lastVersion;
    }

    private void setTimer() {
        if (!autorunEnabled) {
            return;
        }
        autorunEnabled = ResourceController.getResourceController().getBooleanProperty(CHECK_UPDATES_AUTOMATICALLY);
        if (!autorunEnabled) {
            return;
        }
        autorunEnabled = false;
        Date now = new Date();
        long nextCheckMillis = ResourceController.getResourceController().getLongProperty(LAST_UPDATE_CHECK_TIME, 0) + 86400000L;
        Date nextCheckDate = new Date(nextCheckMillis);
        if (now.before(nextCheckDate)) {
            FreeplaneVersion knownNewVersion = this.getKnownNewVersion();
            this.addUpdateButton(knownNewVersion);
            return;
        }
        autorunTimer = new Timer(30000, this);
        autorunTimer.setRepeats(false);
        autorunTimer.start();
    }

    private void showUpdateDialog(boolean connectSuccesfull, FreeplaneVersion localVersion, FreeplaneVersion newVersion, String history) {
        if (!connectSuccesfull) {
            this.showUpdateDialog("can_not_connect_to_info_server", newVersion, history);
        } else {
            this.showUpdateDialog("new_version_available", newVersion, history);
        }
    }

    private int showUpdateDialog(String info, FreeplaneVersion freeplaneLatestVersion, String history) {
        JLabel freeplaneLatestVersionLabel;
        Box messagePane = Box.createVerticalBox();
        JLabel emptyLabel = new JLabel("");
        JPanel gridPane = new JPanel(new GridBagLayout());
        gridPane.setAlignmentX(0.0f);
        Border paddingBorder = BorderFactory.createEmptyBorder(0, 10, 10, 0);
        gridPane.setBorder(BorderFactory.createCompoundBorder(paddingBorder, paddingBorder));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        int gridRow = 0;
        c.weightx = 0.5;
        JLabel componentHeader = new JLabel(TextUtils.getText("updater.component"), 0);
        JLabel installedVersionHeader = new JLabel(TextUtils.getText("updater.version.installed"), 0);
        JLabel latestVersionHeader = new JLabel(TextUtils.getText("updater.version.latest"), 0);
        Font boldFont = new Font(componentHeader.getFont().getName(), 1, componentHeader.getFont().getSize());
        componentHeader.setFont(boldFont);
        installedVersionHeader.setFont(boldFont);
        latestVersionHeader.setFont(boldFont);
        componentHeader.setBorder(paddingBorder);
        installedVersionHeader.setBorder(paddingBorder);
        latestVersionHeader.setBorder(paddingBorder);
        c.gridy = 0;
        c.gridx = 0;
        gridPane.add((Component)componentHeader, c);
        c.gridx = 1;
        gridPane.add((Component)installedVersionHeader, c);
        c.gridx = 2;
        gridPane.add((Component)latestVersionHeader, c);
        c.gridx = 3;
        gridPane.add((Component)emptyLabel, c);
        c.gridx = 4;
        gridPane.add((Component)emptyLabel, c);
        c.gridy = 1;
        JLabel freeplaneLabel = new JLabel("Freeplane");
        FreeplaneVersion freeplaneLocalVersion = FreeplaneVersion.getVersion();
        JLabel freeplaneInstalledVersionLabel = new JLabel(freeplaneLocalVersion.toString(), 0);
        Locale defaultLocale = Locale.getDefault();
        String language = defaultLocale.getLanguage();
        String translatedWebUpdate = this.getWebUpdateUrl(language);
        JButton changelogButton = new JButton(TextUtils.getText("updater.viewChangelog"));
        changelogButton.addActionListener(this.openUrlListener);
        changelogButton.setActionCommand(translatedWebUpdate);
        JButton updateButton = new JButton(TextUtils.getText("updater.goToDownload"));
        updateButton.addActionListener(this.openUrlListener);
        updateButton.setActionCommand("http://freeplane.sourceforge.net");
        Boolean needsUpdate = Boolean.FALSE;
        if (freeplaneLatestVersion != null) {
            needsUpdate = freeplaneLocalVersion.compareTo(freeplaneLatestVersion) < 0 ? Boolean.TRUE : Boolean.FALSE;
            freeplaneLatestVersionLabel = new JLabel(freeplaneLatestVersion.toString(), 0);
        } else {
            freeplaneLatestVersionLabel = new JLabel(TextUtils.getText("updater.version.unknown"), 0);
            freeplaneLatestVersionLabel.setToolTipText(TextUtils.getText(info));
        }
        changelogButton.setEnabled(needsUpdate);
        updateButton.setEnabled(needsUpdate);
        c.gridx = 0;
        gridPane.add((Component)freeplaneLabel, c);
        c.gridx = 1;
        gridPane.add((Component)freeplaneInstalledVersionLabel, c);
        c.gridx = 2;
        gridPane.add((Component)freeplaneLatestVersionLabel, c);
        c.gridx = 3;
        gridPane.add((Component)changelogButton, c);
        c.gridx = 4;
        gridPane.add((Component)updateButton, c);
        List<AddOnProperties> installedAddOns = AddOnsController.getController().getInstalledAddOns();
        gridRow = 3;
        for (AddOnProperties addOnProperties : installedAddOns) {
            JLabel addOnLatestVersionLabel;
            FreeplaneVersion addOnLocalVersion = this.toFreeplaneVersion(addOnProperties.getVersion());
            FreeplaneVersion addOnLatestVersion = this.toFreeplaneVersion(addOnProperties.getLatestVersion());
            JLabel addOnInstalledVersionLabel = new JLabel(addOnLocalVersion.toString(), 0);
            needsUpdate = Boolean.FALSE;
            if (addOnLatestVersion != null) {
                if (addOnLocalVersion.compareTo(addOnLatestVersion) < 0) {
                    needsUpdate = Boolean.TRUE;
                }
                addOnLatestVersionLabel = new JLabel(addOnLatestVersion.toString(), 0);
            } else {
                addOnLatestVersionLabel = new JLabel(TextUtils.getText("updater.version.unknown"), 0);
                if (addOnProperties.getUpdateUrl() != null) {
                    addOnLatestVersionLabel.setToolTipText(TextUtils.getText("updater.version.unreachable") + " " + addOnProperties.getUpdateUrl());
                } else {
                    addOnLatestVersionLabel.setToolTipText(TextUtils.getText("updater.version.noUpdateUrl"));
                }
            }
            JLabel addOnLabel = new JLabel(TextUtils.getText("addons." + addOnProperties.getName()));
            c.gridx = 0;
            c.gridy = gridRow;
            gridPane.add((Component)addOnLabel, c);
            c.gridx = 1;
            c.gridy = gridRow;
            gridPane.add((Component)addOnInstalledVersionLabel, c);
            c.gridx = 2;
            c.gridy = gridRow;
            gridPane.add((Component)addOnLatestVersionLabel, c);
            c.gridx = 3;
            c.gridy = gridRow;
            changelogButton = new JButton(TextUtils.getText("updater.viewChangelog"));
            changelogButton.addActionListener(this.openUrlListener);
            if (addOnProperties.getLatestVersionChangelogUrl() != null) {
                changelogButton.setActionCommand(addOnProperties.getLatestVersionChangelogUrl().toString());
            } else if (addOnProperties.getUpdateUrl() != null) {
                changelogButton.setActionCommand(String.valueOf(addOnProperties.getUpdateUrl()));
            }
            gridPane.add((Component)changelogButton, c);
            changelogButton.setEnabled(needsUpdate);
            c.gridx = 4;
            c.gridy = gridRow;
            updateButton = new JButton(TextUtils.getText("updater.goToDownload"));
            updateButton.addActionListener(this.openUrlListener);
            if (addOnProperties.getLatestVersionDownloadUrl() != null) {
                updateButton.setActionCommand(addOnProperties.getLatestVersionDownloadUrl().toString());
            } else if (addOnProperties.getHomepage() != null) {
                updateButton.setActionCommand(addOnProperties.getHomepage().toString());
            }
            gridPane.add((Component)updateButton, c);
            updateButton.setEnabled(needsUpdate);
            ++gridRow;
        }
        messagePane.add(gridPane);
        JLabel confLabel = new JLabel(TextUtils.getText("preferences"));
        confLabel.setFont(boldFont);
        messagePane.add(confLabel);
        JCheckBox updateAutomatically = new JCheckBox(TextUtils.getText("OptionPanel.check_updates_automatically"), ResourceController.getResourceController().getBooleanProperty(CHECK_UPDATES_AUTOMATICALLY));
        updateAutomatically.setAlignmentX(0.0f);
        messagePane.add(updateAutomatically);
        Object[] options = new Object[]{TextUtils.getText("simplyhtml.closeBtnName")};
        int choice = JOptionPane.showOptionDialog(Controller.getCurrentController().getViewController().getFrame(), messagePane, TextUtils.getText("updatecheckdialog"), -1, 1, null, options, options[0]);
        ResourceController.getResourceController().setProperty(CHECK_UPDATES_AUTOMATICALLY, Boolean.toString(updateAutomatically.isSelected()));
        return choice;
    }

    private FreeplaneVersion toFreeplaneVersion(String versionString) {
        try {
            return FreeplaneVersion.getVersion(versionString);
        }
        catch (Exception e) {
            return FreeplaneVersion.getVersion("0.0.0");
        }
    }
}

