/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowAdapter;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.BlueHighlightDockingTheme;
import net.infonode.docking.util.DockingUtil;
import net.infonode.util.Direction;
import org.apache.commons.codec.binary.Base64;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.url.mindmapmode.FileOpener;
import org.freeplane.main.application.MapViewSerializer;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.ui.DefaultMapMouseListener;

class MapViewDockingWindows
implements IMapViewChangeListener {
    private static final String OPENED_NOW = "openedNow_1.3.04";
    private RootWindow rootWindow = null;
    private final Vector<Component> mapViews;
    private boolean mPaneSelectionUpdate = true;
    private boolean loadingLayoutFromObjectInpusStream;
    private byte[] emptyConfigurations;
    private final MapViewSerializer viewSerializer = new MapViewSerializer();

    public MapViewDockingWindows() {
        this.rootWindow = new RootWindow((ViewSerializer)this.viewSerializer);
        RootWindowProperties rootWindowProperties = this.rootWindow.getRootWindowProperties();
        rootWindowProperties.addSuperObject(new BlueHighlightDockingTheme().getRootWindowProperties());
        rootWindowProperties.getWindowAreaProperties().setBackgroundColor(UIManager.getColor("Panel.background"));
        this.rootWindow.getWindowBar(Direction.DOWN).setEnabled(true);
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream wrapper = new ObjectOutputStream(byteStream);
            this.rootWindow.write(wrapper);
            wrapper.close();
            this.emptyConfigurations = byteStream.toByteArray();
        }
        catch (IOException e1) {
            // empty catch block
        }
        this.removeDesktopPaneAccelerators();
        this.mapViews = new Vector();
        FileOpener fileOpener = new FileOpener();
        new DropTarget((Component)this.rootWindow, fileOpener);
        this.rootWindow.addMouseListener((MouseListener)new DefaultMapMouseListener());
        Controller controller = Controller.getCurrentController();
        controller.getMapViewManager().addMapViewChangeListener(this);
        this.rootWindow.addListener((DockingWindowListener)new DockingWindowAdapter(){

            public void viewFocusChanged(View previouslyFocusedView, View focusedView) {
                if (previouslyFocusedView != null && focusedView != null) {
                    Component containedMapView = MapViewDockingWindows.getContainedMapView(focusedView);
                    MapViewDockingWindows.this.viewSelectionChanged(containedMapView);
                }
            }

            public void windowClosing(DockingWindow window) throws OperationAbortedException {
                for (Component mapViewComponent : MapViewDockingWindows.this.mapViews.toArray(new Component[0])) {
                    if (!SwingUtilities.isDescendingFrom(mapViewComponent, (Component)window) || Controller.getCurrentController().getMapViewManager().close(mapViewComponent, false)) continue;
                    throw new OperationAbortedException("can not close view");
                }
                super.windowClosing(window);
            }
        });
        new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
            }
        };
    }

    private void removeDesktopPaneAccelerators() {
        InputMap map = new InputMap();
        this.rootWindow.setInputMap(1, map);
    }

    private DockingWindow getLastFocusedChildWindow(DockingWindow parentWindow) {
        DockingWindow lastFocusedChildWindow = parentWindow.getLastFocusedChildWindow();
        if (lastFocusedChildWindow == null) {
            return parentWindow;
        }
        return this.getLastFocusedChildWindow(lastFocusedChildWindow);
    }

    public void afterViewChange(Component pOldMap, Component pNewMap) {
        if (pNewMap == null) {
            return;
        }
        if (!this.loadingLayoutFromObjectInpusStream) {
            for (int i = 0; i < this.mapViews.size(); ++i) {
                if (this.mapViews.get(i) != pNewMap) continue;
                View dockedView = MapViewDockingWindows.getContainingDockedWindow(pNewMap);
                dockedView.restoreFocus();
                return;
            }
            this.addDockedWindow(pNewMap);
        } else if (this.mapViews.contains(pNewMap)) {
            return;
        }
        this.mapViews.add(pNewMap);
    }

    private static View getContainingDockedWindow(Component pNewMap) {
        return (View)SwingUtilities.getAncestorOfClass(View.class, pNewMap);
    }

    protected void addDockedView(View dynamicView) {
        DockingWindow lastFocusedChildWindow = this.getLastFocusedChildWindow((DockingWindow)this.rootWindow);
        if (lastFocusedChildWindow == null) {
            DockingUtil.addWindow((DockingWindow)dynamicView, (RootWindow)this.rootWindow);
        } else {
            Container parent = SwingUtilities.getAncestorOfClass(DockingWindow.class, (Component)lastFocusedChildWindow);
            if (parent instanceof TabWindow) {
                ((TabWindow)parent).addTab((DockingWindow)dynamicView);
            } else {
                DockingUtil.addWindow((DockingWindow)dynamicView, (RootWindow)lastFocusedChildWindow.getRootWindow());
            }
        }
    }

    static Component getContainedMapView(View dockedWindow) {
        JScrollPane scrollPane = (JScrollPane)dockedWindow.getComponent();
        Component view = scrollPane.getViewport().getView();
        return view;
    }

    private void addDockedWindow(Component pNewMap) {
        View viewFrame = this.viewSerializer.newDockedView(pNewMap);
        this.addDockedView(viewFrame);
    }

    public void afterViewClose(Component pOldMapView) {
        for (int i = 0; i < this.mapViews.size(); ++i) {
            if (this.mapViews.get(i) != pOldMapView) continue;
            this.mPaneSelectionUpdate = false;
            MapViewDockingWindows.getContainingDockedWindow(pOldMapView).close();
            this.mapViews.remove(i);
            this.mPaneSelectionUpdate = true;
            this.rootWindow.repaint();
            return;
        }
    }

    public void afterViewCreated(Component mapView) {
    }

    public void beforeViewChange(Component pOldMapView, Component pNewMapView) {
    }

    private void viewSelectionChanged(Component mapView) {
        if (!this.mPaneSelectionUpdate) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        if (mapView != controller.getMapViewManager().getMapViewComponent()) {
            controller.getMapViewManager().changeToMapView(mapView.getName());
        }
    }

    public JComponent getMapPane() {
        return this.rootWindow;
    }

    public void saveLayout() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            this.rootWindow.write(objectStream);
            objectStream.close();
            String encodedBytes = Base64.encodeBase64String((byte[])byteStream.toByteArray());
            ResourceController.getResourceController().setProperty(OPENED_NOW, encodedBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLayout() {
        String encodedBytes = ResourceController.getResourceController().getProperty(OPENED_NOW, null);
        if (encodedBytes != null) {
            byte[] bytes = Base64.decodeBase64((String)encodedBytes);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            try {
                this.loadingLayoutFromObjectInpusStream = true;
                this.rootWindow.read(new ObjectInputStream(byteStream));
                this.selectMapViewLater();
            }
            catch (Exception e) {
                LogUtils.severe(e);
                try {
                    this.rootWindow.read(new ObjectInputStream(new ByteArrayInputStream(this.emptyConfigurations)));
                    this.selectMapViewLater();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            finally {
                this.viewSerializer.removeDummyViews();
                this.loadingLayoutFromObjectInpusStream = false;
            }
        }
    }

    private void selectMapViewLater() {
        Timer timer = new Timer(40, new ActionListener(){
            MapView mapView = null;
            int retryCount = 5;

            public void actionPerformed(ActionEvent e) {
                if (this.mapView == null) {
                    for (Component mapView : MapViewDockingWindows.this.mapViews) {
                        if (!mapView.isShowing()) continue;
                        this.mapView = (MapView)mapView;
                        break;
                    }
                }
                if (this.mapView != null) {
                    this.mapView.select();
                    this.mapView.selectAsTheOnlyOneSelected(this.mapView.getRoot());
                }
                if (this.retryCount > 1) {
                    --this.retryCount;
                    ((Timer)e.getSource()).start();
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public void setTitle() {
        if (this.loadingLayoutFromObjectInpusStream) {
            return;
        }
        for (Component mapViewComponent : this.mapViews) {
            if (!(mapViewComponent instanceof MapView)) continue;
            MapView mapView = (MapView)mapViewComponent;
            String name = mapView.getName();
            String title = mapView.getModel().isSaved() ? name : name + " *";
            View containingDockedWindow = MapViewDockingWindows.getContainingDockedWindow(mapViewComponent);
            containingDockedWindow.getViewProperties().setTitle(title);
        }
    }
}

