/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IFreeplaneAction;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.JFreeplaneMenuItem;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.ConfigurationUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.DocuMapAttribute;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.main.application.OpenLastOpenedAction;
import org.freeplane.n3.nanoxml.XMLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LastOpenedList
implements IMapViewChangeListener,
IMapChangeListener {
    private static final String MENU_CATEGORY = "main_menu_most_recent_files";
    private static final String LAST_OPENED_LIST_LENGTH = "last_opened_list_length";
    private static final String LAST_OPENED = "lastOpened_1.0.20";
    private static boolean PORTABLE_APP = System.getProperty("portableapp", "false").equals("true");
    private static String USER_DRIVE = System.getProperty("user.home", "").substring(0, 2);
    private final List<String> lastOpenedList = new LinkedList<String>();
    private final Map<String, String> mRestorableToMapName = new HashMap<String, String>();

    LastOpenedList() {
        this.restoreList(LAST_OPENED, this.lastOpenedList);
    }

    @Override
    public void afterViewChange(Component oldView, Component newView) {
        if (newView == null) {
            this.updateMenus();
            return;
        }
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        MapModel map = mapViewManager.getModel(newView);
        String restoreString = this.getRestoreable(map);
        this.updateList(map, restoreString);
    }

    @Override
    public void afterViewClose(Component oldView) {
    }

    @Override
    public void afterViewCreated(Component mapView) {
    }

    @Override
    public void beforeViewChange(Component oldView, Component newView) {
    }

    private int getMaxMenuEntries() {
        return ResourceController.getResourceController().getIntProperty(LAST_OPENED_LIST_LENGTH, 25);
    }

    private String getRestorable(File file) {
        if (file == null) {
            return null;
        }
        String absolutePath = file.getAbsolutePath();
        if (!PORTABLE_APP || !USER_DRIVE.endsWith(":")) {
            return "MindMap:" + absolutePath;
        }
        String diskName = absolutePath.substring(0, 2);
        if (!diskName.equals(USER_DRIVE)) {
            return "MindMap:" + absolutePath;
        }
        return "MindMap::" + absolutePath.substring(2);
    }

    public String getRestoreable(MapModel map) {
        if (map == null) {
            return null;
        }
        if (map.containsExtension(DocuMapAttribute.class)) {
            return null;
        }
        ModeController modeController = Controller.getCurrentModeController();
        if (!modeController.getModeName().equals("MindMap")) {
            return null;
        }
        File file = map.getFile();
        return this.getRestorable(file);
    }

    @Override
    public void mapChanged(MapChangeEvent event) {
        String fileAfter;
        if (!event.getProperty().equals("map_url")) {
            return;
        }
        URL after = (URL)event.getNewValue();
        if (after != null && (fileAfter = after.getFile()) != null) {
            String restorable = this.getRestorable(new File(fileAfter));
            this.updateList(event.getMap(), restorable);
        }
    }

    @Override
    public void onNodeDeleted(NodeModel parent, NodeModel child, int index) {
    }

    @Override
    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
    }

    @Override
    public void onNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
    }

    @Override
    public void onPreNodeDelete(NodeModel oldParent, NodeModel selectedNode, int index) {
    }

    public void open(String restoreable) throws FileNotFoundException, MalformedURLException, IOException, URISyntaxException, XMLException {
        if (restoreable == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(restoreable, ":");
        if (!tokens.hasMoreTokens()) {
            return;
        }
        boolean changedToMapView = this.tryToChangeToMapView(restoreable);
        if (changedToMapView) {
            return;
        }
        String mode = tokens.nextToken();
        Controller.getCurrentController().selectMode(mode);
        String fileName = tokens.nextToken(";").substring(1);
        if (PORTABLE_APP && fileName.startsWith(":") && USER_DRIVE.endsWith(":")) {
            fileName = USER_DRIVE + fileName.substring(1);
        }
        if (!changedToMapView) {
            Controller.getCurrentModeController().getMapController().newMap(Compat.fileToUrl(new File(fileName)));
        } else {
            MapModel map = Controller.getCurrentController().getMap();
            Controller.getCurrentModeController().getMapController().newMapView(map);
        }
    }

    public void openMapsOnStart() {
        String lastMap;
        if (!this.lastOpenedList.isEmpty() && !this.tryToChangeToMapView(lastMap = this.lastOpenedList.get(0))) {
            this.safeOpen(lastMap);
        }
    }

    private void remove(String restoreable) {
        this.lastOpenedList.remove(restoreable);
        this.updateMenus();
    }

    private void restoreList(String key, List<String> list) {
        String restored = ResourceController.getResourceController().getProperty(key, null);
        if (restored != null && !restored.equals("")) {
            list.addAll(ConfigurationUtils.decodeListValue(restored, true));
        }
    }

    void safeOpen(List<String> maps) {
        for (String restoreable : maps) {
            this.safeOpen(restoreable);
        }
    }

    public void safeOpen(String restoreable) {
        block2: {
            try {
                this.open(restoreable);
            }
            catch (Exception ex) {
                LogUtils.warn(ex);
                String message = TextUtils.format("remove_file_from_list_on_error", restoreable);
                UITools.showFrame();
                Frame frame = UITools.getFrame();
                int remove = JOptionPane.showConfirmDialog(frame, message, "Freeplane", 0);
                if (remove != 0) break block2;
                this.remove(restoreable);
            }
        }
    }

    public void saveProperties() {
        ResourceController.getResourceController().setProperty(LAST_OPENED, ConfigurationUtils.encodeListValue(this.lastOpenedList, true));
    }

    private boolean tryToChangeToMapView(String restoreable) {
        return Controller.getCurrentController().getMapViewManager().tryToChangeToMapView(this.mRestorableToMapName.get(restoreable));
    }

    private void updateList(MapModel map, String restoreString) {
        if (map.containsExtension(DocuMapAttribute.class)) {
            return;
        }
        if (restoreString != null) {
            if (this.lastOpenedList.contains(restoreString)) {
                this.lastOpenedList.remove(restoreString);
            }
            this.lastOpenedList.add(0, restoreString);
            this.mRestorableToMapName.put(restoreString, map.getTitle());
        }
        this.updateMenus();
    }

    private void updateMenus() {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController();
        MenuBuilder menuBuilder = modeController.getUserInputListenerFactory().getMenuBuilder();
        menuBuilder.removeChildElements(MENU_CATEGORY);
        int i = 0;
        int maxEntries = this.getMaxMenuEntries();
        for (String key : this.lastOpenedList) {
            if (!(i != 0 || modeController.getModeName().equals("MindMap") && controller.getMap() != null && controller.getMap().getURL() != null)) {
                ++i;
                ++maxEntries;
            }
            if (i == maxEntries) break;
            OpenLastOpenedAction lastOpenedActionListener = new OpenLastOpenedAction(i++, this);
            IFreeplaneAction decoratedAction = menuBuilder.decorateAction(lastOpenedActionListener);
            JFreeplaneMenuItem item = new JFreeplaneMenuItem(decoratedAction);
            item.setActionCommand(key);
            String text = this.createOpenMapItemName(key);
            item.setText(text);
            item.setMnemonic(0);
            menuBuilder.addMenuItem(MENU_CATEGORY, item, "main_menu_most_recent_files/" + lastOpenedActionListener.getKey(), 0);
        }
    }

    private String createOpenMapItemName(String restorable) {
        int separatorIndex = restorable.indexOf(58);
        if (separatorIndex == -1) {
            return restorable;
        }
        String key = restorable.substring(0, separatorIndex);
        String fileName = restorable.substring(separatorIndex);
        if (fileName.startsWith("::")) {
            return TextUtils.getText("open_as" + key, key) + " " + fileName.substring(2);
        }
        return TextUtils.getText("open_as" + key, key) + " " + fileName.substring(1);
    }

    @Override
    public void onPreNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
    }
}

