/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ShowSelectionAsRectangleAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.ConfigurationUtils;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.features.attribute.ModelessAttributeController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.NextNodeAction;
import org.freeplane.features.filter.NextPresentationItemAction;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.help.HelpController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.QuitAction;
import org.freeplane.features.mode.mindmapmode.LoadAcceleratorPresetsAction;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.print.PrintController;
import org.freeplane.features.styles.LogicalStyleFilterController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.text.TextController;
import org.freeplane.features.time.TimeController;
import org.freeplane.features.ui.FrameController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.FreeplaneUriConverter;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.main.application.ApplicationResourceController;
import org.freeplane.main.application.ApplicationViewController;
import org.freeplane.main.application.CommandLineParser;
import org.freeplane.main.application.FreeplaneSecurityManager;
import org.freeplane.main.application.FreeplaneSplashModern;
import org.freeplane.main.application.FreeplaneStarter;
import org.freeplane.main.application.UpdateCheckAction;
import org.freeplane.main.application.UserPropertiesUpdater;
import org.freeplane.main.browsemode.BModeControllerFactory;
import org.freeplane.main.filemode.FModeControllerFactory;
import org.freeplane.main.mindmapmode.MModeControllerFactory;
import org.freeplane.view.swing.features.nodehistory.NodeHistory;
import org.freeplane.view.swing.map.ViewLayoutTypeAction;
import org.freeplane.view.swing.map.mindmapmode.MMapViewController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeplaneGUIStarter
implements FreeplaneStarter {
    private final ApplicationResourceController applicationResourceController;
    private FreeplaneSplashModern splash = null;
    private boolean startupFinished = false;
    private ApplicationViewController viewController;
    private boolean dontLoadLastMaps;
    private final boolean firstRun;
    private static final String LOAD_LAST_MAPS = "load_last_maps";
    private static final String LOAD_LAST_MAP = "load_last_map";

    public static String getResourceBaseDir() {
        return System.getProperty("org.freeplane.globalresourcedir", "resources");
    }

    public static void showSysInfo() {
        StringBuilder info = new StringBuilder();
        info.append("freeplane_version = ");
        info.append(FreeplaneVersion.getVersion());
        String revision = FreeplaneVersion.getVersion().getRevision();
        info.append("; freeplane_xml_version = ");
        info.append("freeplane 1.3.0");
        if (!revision.equals("")) {
            info.append("\ngit revision = ");
            info.append(revision);
        }
        info.append("\njava_version = ");
        info.append(System.getProperty("java.version"));
        info.append("; os_name = ");
        info.append(System.getProperty("os.name"));
        info.append("; os_version = ");
        info.append(System.getProperty("os.version"));
        LogUtils.info(info.toString());
    }

    public FreeplaneGUIStarter() {
        File userPreferencesFile = ApplicationResourceController.getUserPreferencesFile();
        this.firstRun = !userPreferencesFile.exists();
        new UserPropertiesUpdater().importOldProperties();
        this.applicationResourceController = new ApplicationResourceController();
    }

    @Override
    public void setDontLoadLastMaps() {
        this.dontLoadLastMaps = true;
    }

    @Override
    public Controller createController() {
        try {
            Controller controller = new Controller(this.applicationResourceController);
            Controller.setCurrentController(controller);
            Compat.macAppChanges();
            controller.addAction(new QuitAction());
            this.applicationResourceController.init();
            LogUtils.createLogger();
            FreeplaneGUIStarter.showSysInfo();
            String lookandfeel = System.getProperty("lookandfeel", this.applicationResourceController.getProperty("lookandfeel"));
            FrameController.setLookAndFeel(lookandfeel);
            JFrame frame = new JFrame("Freeplane");
            frame.setName("mainFreeplaneFrame");
            this.splash = new FreeplaneSplashModern(frame);
            if (!System.getProperty("org.freeplane.nosplash", "false").equals("true")) {
                this.splash.setVisible(true);
            }
            MMapViewController mapViewController = new MMapViewController(controller);
            this.viewController = new ApplicationViewController(controller, (IMapViewManager)mapViewController, frame);
            System.setSecurityManager(new FreeplaneSecurityManager());
            mapViewController.addMapViewChangeListener(this.applicationResourceController.getLastOpenedList());
            FilterController.install();
            PrintController.install();
            FormatController.install(new FormatController());
            ScannerController scannerController = new ScannerController();
            ScannerController.install(scannerController);
            scannerController.addParsersForStandardFormats();
            ModelessAttributeController.install();
            TextController.install();
            TimeController.install();
            LinkController.install();
            IconController.install();
            HelpController.install();
            controller.addAction(new UpdateCheckAction());
            controller.addAction(new NextNodeAction(MapController.Direction.FORWARD));
            controller.addAction(new NextNodeAction(MapController.Direction.BACK));
            controller.addAction(new NextNodeAction(MapController.Direction.FORWARD_N_FOLD));
            controller.addAction(new NextNodeAction(MapController.Direction.BACK_N_FOLD));
            controller.addAction(new NextPresentationItemAction());
            controller.addAction(new ShowSelectionAsRectangleAction());
            controller.addAction(new ViewLayoutTypeAction(MapViewLayout.OUTLINE));
            FilterController.getCurrentFilterController().getConditionFactory().addConditionController(7, new LogicalStyleFilterController());
            MapController.install();
            NodeHistory.install(controller);
            return controller;
        }
        catch (Exception e) {
            LogUtils.severe(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createModeControllers(Controller controller) {
        MModeControllerFactory.createModeController();
        ModeController mindMapModeController = controller.getModeController("MindMap");
        mindMapModeController.getMapController().addMapChangeListener(this.applicationResourceController.getLastOpenedList());
        mindMapModeController.addMenuContributor(FilterController.getController(controller).getMenuContributor());
        BModeControllerFactory.createModeController();
        FModeControllerFactory.createModeController();
    }

    @Override
    public void buildMenus(Controller controller, Set<String> plugins) {
        this.buildMenus(controller, plugins, "MindMap", "/xml/mindmapmodemenu.xml");
        LoadAcceleratorPresetsAction.install();
        this.buildMenus(controller, plugins, "Browse", "/xml/browsemodemenu.xml");
        this.buildMenus(controller, plugins, "File", "/xml/filemodemenu.xml");
    }

    private void buildMenus(Controller controller, Set<String> plugins, String mode, String xml) {
        ModeController modeController = controller.getModeController(mode);
        controller.selectModeForBuild(modeController);
        modeController.updateMenus(xml, plugins);
        controller.selectModeForBuild(null);
    }

    @Override
    public void createFrame(final String[] args) {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController("MindMap");
        controller.selectModeForBuild(modeController);
        Compat.macMenuChanges();
        new UserPropertiesUpdater().importOldDefaultStyle();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CommandLineParser.Options options = CommandLineParser.parse(args);
                FreeplaneGUIStarter.this.viewController.init(Controller.getCurrentController());
                Frame frame = FreeplaneGUIStarter.this.viewController.getFrame();
                int extendedState = frame.getExtendedState();
                Container contentPane = FreeplaneGUIStarter.this.viewController.getContentPane();
                contentPane.setVisible(false);
                FreeplaneGUIStarter.this.splash.dispose();
                FreeplaneGUIStarter.this.splash = null;
                frame.setVisible(true);
                if (extendedState != frame.getExtendedState()) {
                    frame.setExtendedState(extendedState);
                }
                FreeplaneGUIStarter.this.loadMaps(options.getFilesToOpenAsArray());
                FreeplaneGUIStarter.this.viewController.getContentPane().setVisible(true);
                frame.toFront();
                FreeplaneGUIStarter.this.startupFinished = true;
                System.setProperty("nonInteractive", Boolean.toString(options.isNonInteractive()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                MenuUtils.executeMenuItems(options.getMenuItemsToExecute());
            }
        });
    }

    private void loadMaps(String[] args) {
        String map;
        File baseDir;
        File absolutFile;
        Controller controller = Controller.getCurrentController();
        boolean alwaysLoadLastMaps = ResourceController.getResourceController().getBooleanProperty("always_load_last_maps");
        if (alwaysLoadLastMaps && !this.dontLoadLastMaps) {
            this.loadLastMaps();
        }
        this.loadMaps(controller, args);
        if (controller.getMap() != null) {
            return;
        }
        if (!alwaysLoadLastMaps && !this.dontLoadLastMaps) {
            AddOnsController addonsController = AddOnsController.getController();
            addonsController.setAutoInstallEnabled(false);
            this.loadLastMaps();
            addonsController.setAutoInstallEnabled(true);
        }
        if (this.firstRun && !this.dontLoadLastMaps && (absolutFile = ConfigurationUtils.getLocalizedFile(new File[]{baseDir = new File(FreeplaneGUIStarter.getResourceBaseDir()).getAbsoluteFile().getParentFile()}, map = ResourceController.getResourceController().getProperty("first_start_map"), Locale.getDefault().getLanguage())) != null) {
            this.loadMaps(controller, new String[]{absolutFile.getAbsolutePath()});
        }
        if (null != controller.getMap()) {
            return;
        }
        controller.selectMode("MindMap");
        MModeController modeController = (MModeController)controller.getModeController();
        MFileManager.getController(modeController).newMapFromDefaultTemplate();
    }

    private void loadLastMaps() {
        boolean loadLastMap = ResourceController.getResourceController().getBooleanProperty(LOAD_LAST_MAP);
        boolean loadLastMaps = ResourceController.getResourceController().getBooleanProperty(LOAD_LAST_MAPS);
        if (loadLastMaps) {
            this.viewController.openMapsOnStart();
        } else if (loadLastMap) {
            this.applicationResourceController.getLastOpenedList().openMapsOnStart();
        }
    }

    @Override
    public void loadMapsLater(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (FreeplaneGUIStarter.this.startupFinished && EventQueue.isDispatchThread()) {
                    FreeplaneGUIStarter.this.loadMaps(Controller.getCurrentController(), args);
                    FreeplaneGUIStarter.this.toFront();
                    return;
                }
                EventQueue.invokeLater(this);
            }
        });
    }

    private void toFront() {
        Frame frame = UITools.getFrame();
        if (frame == null) {
            return;
        }
        int state = frame.getExtendedState();
        if ((state & 1) != 0) {
            frame.setExtendedState(state & 0xFFFFFFFE);
        }
        if (!frame.isVisible()) {
            frame.setVisible(true);
        }
        frame.toFront();
        frame.requestFocus();
    }

    private void loadMaps(Controller controller, String[] args) {
        controller.selectMode("MindMap");
        for (int i = 0; i < args.length; ++i) {
            String fileArgument = args[i];
            try {
                URL url;
                if (fileArgument.startsWith("http://")) {
                    LinkController.getController().loadURI(new URI(fileArgument));
                    continue;
                }
                if (fileArgument.startsWith("freeplane:")) {
                    String fixedUri = new FreeplaneUriConverter().fixPartiallyDecodedFreeplaneUriComingFromInternetExplorer(fileArgument);
                    LinkController.getController().loadURI(new URI(fixedUri));
                    continue;
                }
                if (!FileUtils.isAbsolutePath(fileArgument)) {
                    fileArgument = System.getProperty("user.dir") + System.getProperty("file.separator") + fileArgument;
                }
                if (!(url = Compat.fileToUrl(new File(fileArgument))).getPath().toLowerCase().endsWith(".mm")) continue;
                MModeController modeController = (MModeController)controller.getModeController();
                MapController mapController = modeController.getMapController();
                mapController.openMapSelectReferencedNode(url);
                continue;
            }
            catch (Exception ex) {
                System.err.println("File " + fileArgument + " not loaded");
            }
        }
    }

    @Override
    public void run(String[] args) {
        try {
            if (null == System.getProperty("org.freeplane.core.dir.lib", null)) {
                System.setProperty("org.freeplane.core.dir.lib", "/lib/");
            }
            Controller controller = this.createController();
            this.createModeControllers(controller);
            FilterController.getController(controller).loadDefaultConditions();
            Set<String> emptySet = Collections.emptySet();
            this.buildMenus(controller, emptySet);
            this.createFrame(args);
        }
        catch (Exception e) {
            LogUtils.severe(e);
            JOptionPane.showMessageDialog(UITools.getFrame(), "freeplane.main.Freeplane can't be started", "Startup problem", 0);
            System.exit(1);
        }
    }

    @Override
    public void stop() {
        try {
            if (EventQueue.isDispatchThread()) {
                Controller.getCurrentController().shutdown();
                return;
            }
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    Controller.getCurrentController().shutdown();
                }
            });
        }
        catch (InterruptedException e) {
            LogUtils.severe(e);
        }
        catch (InvocationTargetException e) {
            LogUtils.severe(e);
        }
    }

    @Override
    public ResourceController getResourceController() {
        return this.applicationResourceController;
    }

    static {
        Compat.fixMousePointerForLinux();
    }
}

