/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.freeplane.core.util.Compat;

class CommandLineParser {
    static final String QUIT_MENU_ITEM_KEY = "MB_QuitAction";

    CommandLineParser() {
    }

    public static Options parse(String[] args) {
        int i;
        for (String arg : args) {
            System.out.println(arg);
        }
        Options result = new Options();
        if (args == null || args.length == 0 || !args[0].startsWith("-")) {
            result.setFilesToOpen(args);
            return result;
        }
        String[] mutableArgs = new String[args.length];
        System.arraycopy(args, 0, mutableArgs, 0, args.length);
        args = mutableArgs;
        for (i = 0; i != args.length; ++i) {
            String arg;
            arg = args[i];
            if (arg.startsWith("-S")) {
                result.setStopAfterLaunch(true);
                if (arg.length() <= 2) continue;
                args[i] = "-" + arg.substring(2);
                --i;
                continue;
            }
            if (arg.startsWith("-N")) {
                result.setNonInteractive(true);
                if (arg.length() <= 2) continue;
                args[i] = "-" + arg.substring(2);
                --i;
                continue;
            }
            if (arg.startsWith("-X")) {
                if (arg.length() > 2) {
                    result.addMenuItemToExecute(arg.substring(2));
                    continue;
                }
                if (args.length < i) continue;
                result.addMenuItemToExecute(args[++i]);
                continue;
            }
            if (arg.startsWith("-U")) {
                String userdir = null;
                if (arg.length() > 2) {
                    userdir = arg.substring(2);
                } else if (args.length >= i) {
                    userdir = args[++i];
                } else {
                    System.err.println("option -U<userdir> misses its parameter");
                }
                if (userdir == null) continue;
                System.setProperty("org.freeplane.userfpdir", userdir);
                continue;
            }
            if (arg.startsWith("-h")) {
                result.setHelpRequested(true);
                if (arg.length() <= 2) continue;
                args[i] = "-" + arg.substring(2);
                --i;
                continue;
            }
            if (!arg.equals("--help")) break;
            result.setHelpRequested(true);
        }
        while (i != args.length) {
            result.addFilesToOpen(args[i]);
            ++i;
        }
        if (result.stopAfterLaunch && !result.menuItemsToExecute.contains(QUIT_MENU_ITEM_KEY)) {
            result.addMenuItemToExecute(QUIT_MENU_ITEM_KEY);
        }
        if (result.isHelpRequested()) {
            System.out.println(result.getHelpMessage());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Options {
        private static final String HELP_MESSAGE = "Use:\n\tfreeplane [options] [file1 [file2 ...]]\n -X<menukey>: execute menu item with key <menukey>. Use devtools add-on to find the menu keys\n -S: stop after executing menu items\n -N: set the 'nonInteractive' system property to 'true'\n -U<userdir>: set the freeplane user config directory (default: " + Compat.getFreeplaneUserDirectory() + ")" + "\n -h|--help: print this help";
        private List<String> filesToOpen = new ArrayList<String>();
        private List<String> menuItemsToExecute = new ArrayList<String>();
        private boolean stopAfterLaunch;
        private boolean nonInteractive;
        private boolean helpRequested = false;

        public void setFilesToOpen(String[] filesToOpen) {
            this.filesToOpen = Arrays.asList(filesToOpen);
        }

        public void setMenuItemsToExecute(String[] menuItemsToExecute) {
            this.menuItemsToExecute = Arrays.asList(menuItemsToExecute);
        }

        public boolean isStopAfterLaunch() {
            return this.stopAfterLaunch;
        }

        public void setStopAfterLaunch(boolean stopAfterLaunch) {
            this.stopAfterLaunch = stopAfterLaunch;
        }

        public List<String> getFilesToOpen() {
            return this.filesToOpen;
        }

        public String[] getFilesToOpenAsArray() {
            return this.filesToOpen.toArray(new String[this.filesToOpen.size()]);
        }

        public List<String> getMenuItemsToExecute() {
            return this.menuItemsToExecute;
        }

        public String[] getMenuItemsToExecuteAsArray() {
            return this.menuItemsToExecute.toArray(new String[this.menuItemsToExecute.size()]);
        }

        public boolean hasMenuItemsToExecute() {
            return !this.menuItemsToExecute.isEmpty();
        }

        public void addFilesToOpen(String file) {
            this.filesToOpen.add(file);
        }

        public void addMenuItemToExecute(String item) {
            this.menuItemsToExecute.add(item);
        }

        public void setNonInteractive(boolean b) {
            this.nonInteractive = b;
        }

        public boolean isNonInteractive() {
            return this.nonInteractive;
        }

        public boolean isHelpRequested() {
            return this.helpRequested;
        }

        public void setHelpRequested(boolean helpRequested) {
            this.helpRequested = helpRequested;
        }

        public String toString() {
            return "Options(files: " + this.filesToOpen + ", menuItems: " + this.menuItemsToExecute + ", stopAfterLaunch: " + this.stopAfterLaunch + ", nonInteractive: " + this.nonInteractive + ")";
        }

        public String getHelpMessage() {
            return HELP_MESSAGE;
        }
    }
}

