/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.features.filter.FilterController;
import org.freeplane.main.application.FreeplaneGUIStarter;
import org.freeplane.main.application.LastOpenedList;

public class ApplicationResourceController
extends ResourceController {
    private static final String FREEPLANE_MAC_PROPERTIES = "/freeplane_mac.properties";
    private final File autoPropertiesFile;
    private final Properties defProps = this.readDefaultPreferences();
    private LastOpenedList lastOpened;
    private final Properties props = this.readUsersPreferences(this.defProps);
    private final ClassLoader urlResourceLoader;

    public ApplicationResourceController() {
        File userDir = this.createUserDirectory(this.defProps);
        ArrayList<URL> urls = new ArrayList<URL>(2);
        String resourceBaseDir = this.getResourceBaseDir();
        if (resourceBaseDir != null) {
            try {
                File resourceDir;
                File userResourceDir = new File(userDir, "resources");
                if (userResourceDir.exists()) {
                    URL userResourceUrl = Compat.fileToUrl(userResourceDir);
                    urls.add(userResourceUrl);
                }
                if ((resourceDir = new File(resourceBaseDir)).exists()) {
                    URL globalResourceUrl = Compat.fileToUrl(resourceDir);
                    urls.add(globalResourceUrl);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.urlResourceLoader = urls.size() > 0 ? new URLClassLoader(urls.toArray(new URL[0]), null) : null;
        this.setDefaultLocale(this.props);
        this.autoPropertiesFile = ApplicationResourceController.getUserPreferencesFile();
        this.addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals("language")) {
                    ApplicationResourceController.this.loadAnotherLanguage();
                }
            }
        });
    }

    private File createUserDirectory(Properties pDefaultProperties) {
        File userPropertiesFolder = new File(this.getFreeplaneUserDirectory());
        try {
            if (!userPropertiesFolder.exists()) {
                userPropertiesFolder.mkdirs();
            }
            return userPropertiesFolder;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Cannot create folder for user properties and logging: '" + userPropertiesFolder.getAbsolutePath() + "'");
            return null;
        }
    }

    public String getDefaultProperty(String key) {
        return this.defProps.getProperty(key);
    }

    public String getFreeplaneUserDirectory() {
        return Compat.getFreeplaneUserDirectory();
    }

    public LastOpenedList getLastOpenedList() {
        return this.lastOpened;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public URL getResource(String name) {
        if (this.urlResourceLoader == null) {
            return super.getResource(name);
        }
        String relName = name.startsWith("/") ? name.substring(1) : name;
        URL resource = this.urlResourceLoader.getResource(relName);
        if (resource != null) {
            return resource;
        }
        resource = super.getResource(name);
        if (resource != null) {
            return resource;
        }
        if ("/lib/freeplaneviewer.jar".equals(name)) {
            String rootDir = new File(this.getResourceBaseDir()).getAbsoluteFile().getParent();
            try {
                File try1 = new File(rootDir + "/plugins/org.freeplane.core/lib/freeplaneviewer.jar");
                if (try1.exists()) {
                    return try1.toURL();
                }
                File try2 = new File(rootDir + "/lib/freeplaneviewer.jar");
                if (try2.exists()) {
                    return try2.toURL();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getResourceBaseDir() {
        return FreeplaneGUIStarter.getResourceBaseDir();
    }

    public String getInstallationBaseDir() {
        return new File(this.getResourceBaseDir()).getAbsoluteFile().getParent();
    }

    public static File getUserPreferencesFile() {
        String freeplaneDirectory = Compat.getFreeplaneUserDirectory();
        File userPropertiesFolder = new File(freeplaneDirectory);
        File autoPropertiesFile = new File(userPropertiesFolder, "auto.properties");
        return autoPropertiesFile;
    }

    public void init() {
        this.lastOpened = new LastOpenedList();
        super.init();
    }

    private Properties readDefaultPreferences() {
        Properties props = new Properties();
        this.readDefaultPreferences(props, "/freeplane.properties");
        if (Compat.isMacOsX()) {
            this.readDefaultPreferences(props, FREEPLANE_MAC_PROPERTIES);
        }
        String propsLocs = props.getProperty("load_next_properties", "");
        this.readDefaultPreferences(props, propsLocs.split(";"));
        return props;
    }

    private void readDefaultPreferences(Properties props, String[] locArray) {
        for (String loc : locArray) {
            this.readDefaultPreferences(props, loc);
        }
    }

    private void readDefaultPreferences(Properties props, String propsLoc) {
        URL defaultPropsURL = this.getResource(propsLoc);
        ApplicationResourceController.loadProperties(props, defaultPropsURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readUsersPreferences(Properties defaultPreferences) {
        Properties auto = new Properties(defaultPreferences);
        FileInputStream in = null;
        try {
            File autoPropertiesFile = ApplicationResourceController.getUserPreferencesFile();
            in = new FileInputStream(autoPropertiesFile);
            auto.load(in);
        }
        catch (Exception ex) {
            try {
                System.err.println("User properties not found, new file created");
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose(in);
                throw throwable;
            }
            FileUtils.silentlyClose(in);
        }
        FileUtils.silentlyClose(in);
        return auto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        this.lastOpened.saveProperties();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.autoPropertiesFile);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)out, "8859_1");
            outputStreamWriter.write("#Freeplane ");
            outputStreamWriter.write(FreeplaneVersion.getVersion().toString());
            outputStreamWriter.write(10);
            outputStreamWriter.flush();
            this.props.store(out, null);
        }
        catch (Exception ex) {
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {}
            }
        }
        FilterController.getCurrentFilterController().saveConditions();
    }

    private void setDefaultLocale(Properties pProperties) {
        String lang = pProperties.getProperty("language");
        if (lang == null) {
            return;
        }
        Locale localeDef = null;
        switch (lang.length()) {
            case 2: {
                localeDef = new Locale(lang);
                break;
            }
            case 5: {
                localeDef = new Locale(lang.substring(0, 1), lang.substring(3, 4));
                break;
            }
            default: {
                return;
            }
        }
        Locale.setDefault(localeDef);
    }

    public void setDefaultProperty(String key, String value) {
        this.defProps.setProperty(key, value);
    }

    public void setProperty(String key, String value) {
        String oldValue = this.getProperty(key);
        if (oldValue == value) {
            return;
        }
        if (oldValue != null && oldValue.equals(value)) {
            return;
        }
        this.props.setProperty(key, value);
        this.firePropertyChanged(key, value, oldValue);
    }
}

