/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.IPropertyControlCreator;
import org.freeplane.core.resources.components.OptionPanelBuilder;
import org.freeplane.core.ui.components.OptionalDontShowMeAgainDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.XsltPipeReaderFactory;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.url.IMapInputStreamConverter;
import org.freeplane.features.url.MapConversionException;
import org.freeplane.features.url.MapVersionInterpreter;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.ExportBranchAction;
import org.freeplane.features.url.mindmapmode.FileOpener;
import org.freeplane.features.url.mindmapmode.FileRevisionsDialog;
import org.freeplane.features.url.mindmapmode.ImportBranchAction;
import org.freeplane.features.url.mindmapmode.ImportExplorerFavoritesAction;
import org.freeplane.features.url.mindmapmode.ImportFolderStructureAction;
import org.freeplane.features.url.mindmapmode.ImportLinkedBranchAction;
import org.freeplane.features.url.mindmapmode.ImportLinkedBranchWithoutRootAction;
import org.freeplane.features.url.mindmapmode.NewMapAction;
import org.freeplane.features.url.mindmapmode.NewMapFromTemplateAction;
import org.freeplane.features.url.mindmapmode.OpenAction;
import org.freeplane.features.url.mindmapmode.OpenURLMapAction;
import org.freeplane.features.url.mindmapmode.OpenUserDirAction;
import org.freeplane.features.url.mindmapmode.RevertAction;
import org.freeplane.features.url.mindmapmode.SaveAction;
import org.freeplane.features.url.mindmapmode.SaveAsAction;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.n3.nanoxml.XMLParseException;

public class MFileManager
extends UrlManager
implements IMapViewChangeListener {
    private static final String BACKUP_EXTENSION = "bak";
    private static final int DEBUG_OFFSET = 0;
    private static final String BACKUP_FILE_NUMBER = "backup_file_number";
    private static final String FREEPLANE_VERSION_UPDATER_XSLT = "/xslt/freeplane_version_updater.xslt";
    private static File singleBackupDirectory;
    javax.swing.filechooser.FileFilter filefilter = new MindMapFilter();

    private File[] findFileRevisions(final File file, File backupDir, final AlternativeFileMode mode) {
        String fileExtensionPattern = mode == AlternativeFileMode.ALL ? "(bak|autosave)" : "autosave";
        final Pattern pattern = Pattern.compile("^" + Pattern.quote(MFileManager.backupFileName(file)) + "\\.+\\d+\\." + fileExtensionPattern);
        if (backupDir.exists()) {
            File[] fileList = backupDir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    String name = f.getName();
                    return pattern.matcher(name).matches() && f.isFile() && (mode == AlternativeFileMode.ALL || f.lastModified() > file.lastModified() - 0L);
                }
            });
            return fileList;
        }
        return new File[0];
    }

    private static String backupFileName(File file) {
        if (singleBackupDirectory == null) {
            return file.getName();
        }
        return file.getName() + "." + file.hashCode();
    }

    private static void backupFile(File file, int backupFileNumber, String extension) {
        File backupFile;
        if (backupFileNumber == 0) {
            return;
        }
        File backupDir = MFileManager.backupDir(file);
        backupDir.mkdir();
        if (backupDir.exists() && !(backupFile = MFileManager.renameBackupFiles(backupDir, file, backupFileNumber, extension)).exists()) {
            MFileManager.performBackup(file, backupFile);
        }
    }

    private static void performBackup(File file, File backupFile) {
        try {
            FileUtils.copyFile(file, backupFile);
            backupFile.setLastModified(file.lastModified());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File backupDir(File file) {
        if (singleBackupDirectory != null) {
            return singleBackupDirectory;
        }
        return new File(file.getParentFile(), ".backup");
    }

    static File createBackupFile(File backupDir, File file, int number, String extension) {
        return new File(backupDir, MFileManager.backupFileName(file) + '.' + number + '.' + extension);
    }

    static File renameBackupFiles(File backupDir, File file, int backupFileNumber, String extension) {
        File newFile;
        if (backupFileNumber == 0) {
            return null;
        }
        int i = backupFileNumber + 1;
        while ((newFile = MFileManager.createBackupFile(backupDir, file, i, extension)).exists()) {
            newFile.delete();
            ++i;
        }
        i = backupFileNumber;
        while (!(newFile = MFileManager.createBackupFile(backupDir, file, i, extension)).exists() && --i != 0) {
        }
        if (i < backupFileNumber) {
            return MFileManager.createBackupFile(backupDir, file, i + 1, extension);
        }
        for (i = 1; i < backupFileNumber; ++i) {
            newFile = MFileManager.createBackupFile(backupDir, file, i, extension);
            File oldFile = MFileManager.createBackupFile(backupDir, file, i + 1, extension);
            newFile.delete();
            if (oldFile.renameTo(newFile)) continue;
            return null;
        }
        return MFileManager.createBackupFile(backupDir, file, backupFileNumber, extension);
    }

    protected void init() {
        super.init();
        this.createActions();
        this.createPreferences();
        if (ResourceController.getResourceController().getBooleanProperty("single_backup_directory")) {
            String value = ResourceController.getResourceController().getProperty("single_backup_directory_path");
            if (value != null && value.indexOf("{freeplaneuserdir}") >= 0) {
                value = value.replace("{freeplaneuserdir}", ResourceController.getResourceController().getFreeplaneUserDirectory());
                ResourceController.getResourceController().setProperty("single_backup_directory_path", value);
            }
            singleBackupDirectory = new File(value);
        }
    }

    private void createPreferences() {
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        OptionPanelBuilder optionPanelBuilder = modeController.getOptionPanelBuilder();
        optionPanelBuilder.addCreator("Environment/load", new IPropertyControlCreator(){

            public IPropertyControl createControl() {
                Set<String> charsets = Charset.availableCharsets().keySet();
                LinkedList<String> charsetList = new LinkedList<String>(charsets);
                charsetList.addFirst("JVMdefault");
                LinkedList<String> charsetTranslationList = new LinkedList<String>(charsets);
                charsetTranslationList.addFirst(TextUtils.getText("OptionPanel.default"));
                return new ComboProperty("default_charset", charsetList, charsetTranslationList);
            }
        }, 0);
    }

    private void backup(File file) {
        if (file == null) {
            return;
        }
        int backupFileNumber = ResourceController.getResourceController().getIntProperty(BACKUP_FILE_NUMBER, 0);
        MFileManager.backupFile(file, backupFileNumber, BACKUP_EXTENSION);
    }

    private void createActions() {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController();
        controller.addAction(new OpenAction());
        controller.addAction(new OpenURLMapAction());
        controller.addAction(new NewMapAction());
        File userTemplates = this.defaultUserTemplateDir();
        userTemplates.mkdir();
        modeController.addAction(new NewMapFromTemplateAction("new_map_from_user_templates", userTemplates));
        modeController.addAction(new SaveAction());
        modeController.addAction(new SaveAsAction());
        modeController.addAction(new ExportBranchAction());
        modeController.addAction(new ImportBranchAction());
        modeController.addAction(new ImportLinkedBranchAction());
        modeController.addAction(new ImportLinkedBranchWithoutRootAction());
        modeController.addAction(new ImportExplorerFavoritesAction());
        modeController.addAction(new ImportFolderStructureAction());
        modeController.addAction(new RevertAction());
        modeController.addAction(new OpenUserDirAction());
    }

    public JFileChooser getFileChooser(boolean useDirectorySelector) {
        JFileChooser fileChooser = this.getFileChooser(this.getFileFilter(), useDirectorySelector);
        return fileChooser;
    }

    public javax.swing.filechooser.FileFilter getFileFilter() {
        return this.filefilter;
    }

    protected JComponent createDirectorySelector(final JFileChooser chooser) {
        JComboBox<NamedObject> box = new JComboBox<NamedObject>();
        box.setEditable(false);
        File dir = this.getLastCurrentDir() != null ? this.getLastCurrentDir() : chooser.getCurrentDirectory();
        File templateDir = this.defaultStandardTemplateDir();
        File userTemplateDir = this.defaultUserTemplateDir();
        box.addItem(new NamedObject(dir, TextUtils.getText("current_dir")));
        box.addItem(new NamedObject(templateDir, TextUtils.getText("template_dir")));
        box.addItem(new NamedObject(userTemplateDir, TextUtils.getText("user_template_dir")));
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                NamedObject obj = (NamedObject)box.getSelectedItem();
                File dir = (File)obj.getObject();
                chooser.setCurrentDirectory(dir);
            }
        });
        File selectedDir = chooser.getCurrentDirectory();
        String selectedPath = selectedDir.getAbsolutePath();
        if (!selectedDir.equals(dir)) {
            for (int i = 0; i < box.getItemCount(); ++i) {
                NamedObject item = (NamedObject)box.getItemAt(i);
                File itemDir = (File)item.getObject();
                if (!itemDir.getAbsolutePath().equals(selectedPath)) continue;
                box.setSelectedItem(item);
                break;
            }
        }
        return box;
    }

    private String getFileNameProposal(MapModel map) {
        String rootText = TextController.getController().getPlainTextContent(map.getRootNode());
        rootText = rootText.replaceAll("[&:/\\\\\u0000%$#~\\?\\*]+", "");
        return rootText;
    }

    public URI getLinkByFileChooser(MapModel map) {
        JFileChooser chooser = null;
        File file = map.getFile();
        if (file == null && LinkController.getLinkType() == 1) {
            JOptionPane.showMessageDialog(Controller.getCurrentController().getViewController().getContentPane(), TextUtils.getText("not_saved_for_link_error"), "Freeplane", 2);
            return null;
        }
        chooser = this.getLastCurrentDir() != null ? new JFileChooser(this.getLastCurrentDir()) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileSelectionMode(2);
        int returnVal = chooser.showOpenDialog(Controller.getCurrentController().getViewController().getContentPane());
        if (returnVal != 0) {
            return null;
        }
        File input = chooser.getSelectedFile();
        this.setLastCurrentDir(input.getParentFile());
        return LinkController.toLinkTypeDependantURI(file, input);
    }

    @Deprecated
    public void loadAndLock(URL url, MapModel map) throws FileNotFoundException, IOException, XMLParseException, URISyntaxException {
        File file = Compat.urlToFile(url);
        if (file == null) {
            super.loadCatchExceptions(url, map);
            return;
        }
        if (!file.exists()) {
            throw new FileNotFoundException(TextUtils.format("file_not_found", file.getPath()));
        }
        if (!file.canWrite()) {
            map.setReadOnly(true);
        }
        try {
            String lockingUser = this.tryToLock(map, file);
            if (lockingUser != null) {
                UITools.informationMessage(Controller.getCurrentController().getViewController().getFrame(), TextUtils.format("map_locked_by_open", file.getName(), lockingUser));
                map.setReadOnly(true);
            }
        }
        catch (Exception e) {
            LogUtils.severe(e);
            UITools.informationMessage(Controller.getCurrentController().getViewController().getFrame(), TextUtils.format("locking_failed_by_open", file.getName()));
            map.setReadOnly(true);
        }
        if (file.length() != 0L) {
            this.setFile(map, file);
            NodeModel root = this.loadTree(map, file);
            assert (map.getRootNode() == root);
        }
        if (map.getRootNode() == null) {
            map.createNewRoot();
        }
    }

    public URL getAlternativeURL(URL url, AlternativeFileMode mode) {
        try {
            File file = Compat.urlToFile(url);
            if (file == null) {
                return url;
            }
            File alternativeFile = this.getAlternativeFile(file, mode);
            if (alternativeFile != null) {
                return Compat.fileToUrl(alternativeFile);
            }
            return null;
        }
        catch (MalformedURLException e) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public File getAlternativeFile(File file, AlternativeFileMode mode) {
        boolean success;
        File[] revisions = this.findFileRevisions(file, MFileManager.backupDir(file), mode);
        if (revisions.length == 0 && mode == AlternativeFileMode.AUTOSAVE) {
            return file;
        }
        FileRevisionsDialog newerFileRevisionsFoundDialog = new FileRevisionsDialog(file, revisions, mode);
        File selectedFile = newerFileRevisionsFoundDialog.getSelectedFile();
        if (file.equals(selectedFile) && !(success = file.setLastModified(System.currentTimeMillis()))) {
            LogUtils.warn("Unable to set the last modification time for " + file);
        }
        return selectedFile;
    }

    @Deprecated
    public NodeModel loadTree(MapModel map, File file) throws XMLParseException, IOException {
        try {
            NodeModel rootNode = this.loadTreeImpl(map, file);
            return rootNode;
        }
        catch (Exception ex) {
            String errorMessage = "Error while parsing file:" + file;
            LogUtils.warn(errorMessage, ex);
            UITools.errorMessage(errorMessage);
            NodeModel result = new NodeModel(map);
            result.setText(errorMessage);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeModel loadTreeImpl(MapModel map, File f) throws FileNotFoundException, IOException, XMLException, MapConversionException {
        NodeModel nodeModel;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(f));
        int versionInfoLength = 1000;
        byte[] buffer = new byte[versionInfoLength];
        int readCount = file.read(buffer);
        String mapStart = new String(buffer, FileUtils.defaultCharset().name());
        ByteArrayInputStream readBytes = new ByteArrayInputStream(buffer, 0, readCount);
        SequenceInputStream sequencedInput = new SequenceInputStream(readBytes, file);
        Reader reader = null;
        MapVersionInterpreter versionInterpreter = MapVersionInterpreter.getVersionInterpreter(mapStart);
        map.addExtension(versionInterpreter);
        if (versionInterpreter.anotherDialect) {
            String message = versionInterpreter.getDialectInfo(f.getAbsolutePath());
            UITools.showMessage(message, 2);
        }
        if (versionInterpreter.needsConversion) {
            int showResult = OptionalDontShowMeAgainDialog.show("really_convert_to_current_version", "confirmation", "convert_to_current_version", 0);
            IMapInputStreamConverter isConverter = versionInterpreter.getMapInputStreamConverter();
            if (showResult != 0 || isConverter == null) {
                reader = new XsltPipeReaderFactory().getActualReader(sequencedInput);
            } else {
                ((InputStream)sequencedInput).close();
                reader = isConverter.getConvertedStream(f);
            }
        } else {
            reader = new XsltPipeReaderFactory().getActualReader(sequencedInput);
        }
        try {
            nodeModel = Controller.getCurrentModeController().getMapController().getMapReader().createNodeTreeFromXml(map, reader, MapWriter.Mode.FILE);
        }
        catch (Throwable throwable) {
            FileUtils.silentlyClose(reader);
            throw throwable;
        }
        FileUtils.silentlyClose(reader);
        return nodeModel;
    }

    @Deprecated
    public void loadURL(URI relative) {
        MapModel map = Controller.getCurrentController().getMap();
        if (!(map != null && map.getURL() != null || (relative.toString().startsWith("#") || relative.isAbsolute()) && !relative.isOpaque())) {
            Controller.getCurrentController().getViewController().out("You must save the current map first!");
            boolean result = ((MFileManager)UrlManager.getController()).save(map);
            if (!result) {
                return;
            }
        }
        super.loadURL(relative);
    }

    @Deprecated
    public void open() {
        JFileChooser chooser = this.getFileChooser(false);
        chooser.setMultiSelectionEnabled(true);
        int returnVal = chooser.showOpenDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent());
        if (returnVal != 0) {
            return;
        }
        File[] selectedFiles = chooser.getSelectedFiles();
        for (int i = 0; i < selectedFiles.length; ++i) {
            File theFile = selectedFiles[i];
            try {
                this.setLastCurrentDir(theFile.getParentFile());
                Controller.getCurrentModeController().getMapController().newMap(Compat.fileToUrl(theFile));
                continue;
            }
            catch (Exception ex) {
                this.handleLoadingException(ex);
                break;
            }
        }
        Controller.getCurrentController().getMapViewManager().setTitle();
    }

    @Deprecated
    public MapModel newMapFromDefaultTemplate() {
        File file = this.defaultTemplateFile();
        if (file != null) {
            return this.newMapFromTemplate(file);
        }
        MapController mapController = Controller.getCurrentModeController().getMapController();
        MapModel map = mapController.newMap();
        mapController.setSaved(map, true);
        return map;
    }

    public File defaultTemplateFile() {
        String userDefinedTemplateFile = this.getStandardTemplateName();
        File absolute = new File(userDefinedTemplateFile);
        if (absolute.isAbsolute() && absolute.exists() && !absolute.isDirectory()) {
            return absolute;
        }
        File userTemplates = this.defaultUserTemplateDir();
        File userStandard = new File(userTemplates, userDefinedTemplateFile);
        if (userStandard.exists() && !userStandard.isDirectory()) {
            return userStandard;
        }
        return null;
    }

    public File defaultUserTemplateDir() {
        String userDir = ResourceController.getResourceController().getFreeplaneUserDirectory();
        File userTemplates = new File(userDir, "templates");
        return userTemplates;
    }

    public File defaultStandardTemplateDir() {
        String resourceBaseDir = ResourceController.getResourceController().getResourceBaseDir();
        File allUserTemplates = new File(resourceBaseDir, "templates");
        return allUserTemplates;
    }

    public String getStandardTemplateName() {
        return ResourceController.getResourceController().getProperty("standard_template");
    }

    @Deprecated
    public MapModel newMapFromTemplate(File startFile) {
        File file;
        if (startFile == null) {
            file = this.getLastCurrentDir();
        } else if (startFile.isDirectory()) {
            JFileChooser chooser = this.getFileChooser(true);
            chooser.setCurrentDirectory(startFile);
            int returnVal = chooser.showOpenDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent());
            if (returnVal != 0) {
                return null;
            }
            file = chooser.getSelectedFile();
        } else {
            file = startFile;
        }
        try {
            MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
            mapController.newUntitledMap(Compat.fileToUrl(file));
            Controller controller = Controller.getCurrentController();
            MapModel map = controller.getMap();
            Object rootText = map.getRootNode().getUserObject();
            if (rootText instanceof NamedObject) {
                map.getRootNode().setText(rootText.toString());
            }
            controller.getModeController().getMapController().setSaved(map, true);
            return map;
        }
        catch (Exception e) {
            this.handleLoadingException(e);
            return null;
        }
    }

    @Deprecated
    public void saveAsUserTemplate() {
        int overwriteMap;
        JFileChooser chooser = new JFileChooser();
        javax.swing.filechooser.FileFilter filter = this.getFileFilter();
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        File userTemplates = this.defaultUserTemplateDir();
        chooser.setCurrentDirectory(userTemplates);
        int returnVal = chooser.showOpenDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent());
        if (returnVal != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file.exists() && (overwriteMap = JOptionPane.showConfirmDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent(), TextUtils.getText("map_already_exists"), "Freeplane", 0)) != 0) {
            return;
        }
        this.saveInternal((MMapModel)Controller.getCurrentController().getMap(), file, false);
    }

    @Deprecated
    public boolean save(MapModel map) {
        if (map == null || map.isSaved()) {
            return true;
        }
        if (map.getURL() == null || map.isReadOnly()) {
            return this.saveAs(map);
        }
        return this.save(map, map.getFile());
    }

    @Deprecated
    public boolean save(MapModel map, File file) {
        if (file == null) {
            return this.saveAs(map);
        }
        try {
            String lockingUser;
            if (null == map.getExtension(BackupFlag.class)) {
                map.addExtension(new BackupFlag());
                this.backup(file);
            }
            if ((lockingUser = this.tryToLock(map, file)) != null) {
                UITools.informationMessage(Controller.getCurrentController().getViewController().getFrame(), TextUtils.format("map_locked_by_save_as", file.getName(), lockingUser));
                return false;
            }
        }
        catch (Exception e) {
            UITools.informationMessage(Controller.getCurrentController().getViewController().getFrame(), TextUtils.format("locking_failed_by_save_as", file.getName()));
            return false;
        }
        URL urlBefore = map.getURL();
        boolean saved = this.saveInternal((MMapModel)map, file, false);
        if (!saved) {
            return false;
        }
        map.setReadOnly(false);
        URL urlAfter = map.getURL();
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        mapController.fireMapChanged(new MapChangeEvent(this, map, "map_url", urlBefore, urlAfter));
        mapController.setSaved(map, true);
        return true;
    }

    @Deprecated
    public boolean saveAs(MapModel map) {
        int overwriteMap;
        JFileChooser chooser = this.getFileChooser(true);
        if (this.getMapsParentFile(map) == null) {
            chooser.setSelectedFile(new File(this.getFileNameProposal(map) + ".mm"));
        } else {
            chooser.setSelectedFile(map.getFile());
        }
        chooser.setDialogTitle(TextUtils.getText("SaveAsAction.text"));
        int returnVal = chooser.showSaveDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent());
        if (returnVal != 0) {
            return false;
        }
        File f = chooser.getSelectedFile();
        this.setLastCurrentDir(f.getParentFile());
        String ext = FileUtils.getExtension(f.getName());
        if (!ext.equals("mm")) {
            f = new File(f.getParent(), f.getName() + ".mm");
        }
        if (f.exists() && (overwriteMap = JOptionPane.showConfirmDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent(), TextUtils.getText("map_already_exists"), "Freeplane", 0)) != 0) {
            return false;
        }
        File oldFile = map.getFile();
        if (oldFile != null) {
            oldFile = oldFile.getAbsoluteFile();
        }
        if (!f.getAbsoluteFile().equals(oldFile) && null != map.getExtension(BackupFlag.class)) {
            map.removeExtension(BackupFlag.class);
        }
        if (this.save(map, f)) {
            Controller.getCurrentController().getMapViewManager().updateMapViewName();
            return true;
        }
        return false;
    }

    boolean saveInternal(MMapModel map, File file, boolean isInternal) {
        if (file.exists() && !file.canWrite()) {
            LogUtils.severe("Attempt to write in read-only file.");
            return false;
        }
        try {
            if (map.getTimerForAutomaticSaving() != null) {
                map.getTimerForAutomaticSaving().cancel();
            }
            if (!isInternal) {
                this.setFile(map, file);
                map.setSaved(true);
            }
            this.writeToFile(map, file);
            map.scheduleTimerForAutomaticSaving();
            return true;
        }
        catch (IOException e) {
            String message = TextUtils.format("save_failed", file.getName());
            if (!isInternal) {
                UITools.errorMessage(message);
            } else {
                Controller.getCurrentController().getViewController().out(message);
            }
        }
        catch (Exception e) {
            LogUtils.severe("Error in MapModel.save(): ", e);
        }
        map.scheduleTimerForAutomaticSaving();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void writeToFile(MapModel map, File file) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(file);
        FileLock lock = null;
        try {
            boolean lockedByOtherApplication = false;
            try {
                lock = out.getChannel().tryLock();
                lockedByOtherApplication = lock == null;
            }
            catch (Exception e) {
                LogUtils.warn(e.getMessage());
            }
            if (lockedByOtherApplication) {
                throw new IOException("can not obtain file lock for " + file);
            }
            BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(out));
            Controller.getCurrentModeController().getMapController().getMapWriter().writeMapAsXml(map, fileout, MapWriter.Mode.FILE, true, false);
        }
        finally {
            if (lock != null && lock.isValid()) {
                lock.release();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public void setFile(MapModel map, File file) {
        try {
            URL url = Compat.fileToUrl(file);
            this.setURL(map, url);
        }
        catch (MalformedURLException e) {
            LogUtils.severe(e);
        }
    }

    @Deprecated
    public String tryToLock(MapModel map, File file) throws Exception {
        String lockingUser = ((MMapModel)map).getLockManager().tryToLock(file);
        String lockingUserOfOldLock = ((MMapModel)map).getLockManager().popLockingUserOfOldLock();
        if (lockingUserOfOldLock != null) {
            UITools.informationMessage(Controller.getCurrentController().getViewController().getFrame(), TextUtils.format("locking_old_lock_removed", file.getName(), lockingUserOfOldLock));
        }
        return lockingUser;
    }

    public void afterViewChange(Component oldView, Component newView) {
    }

    public void afterViewClose(Component oldView) {
    }

    public void afterViewCreated(Component mapView) {
        if (mapView != null) {
            FileOpener fileOpener = new FileOpener();
            new DropTarget(mapView, fileOpener);
        }
    }

    public void beforeViewChange(Component oldView, Component newView) {
    }

    public static MFileManager getController(ModeController modeController) {
        return (MFileManager)modeController.getExtension(UrlManager.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlternativeFileMode {
        ALL,
        AUTOSAVE;

    }

    private class MindMapFilter
    extends javax.swing.filechooser.FileFilter {
        private MindMapFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = FileUtils.getExtension(f.getName());
            if (extension != null) {
                return extension.equals("mm");
            }
            return false;
        }

        public String getDescription() {
            return TextUtils.getText("mindmaps_desc");
        }
    }

    private static class BackupFlag
    implements IExtension {
        private BackupFlag() {
        }
    }
}

