/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JFileChooser;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.ViewController;

class ImportFolderStructureAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public ImportFolderStructureAction() {
        super("ImportFolderStructureAction");
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(TextUtils.getText("select_folder_for_importing"));
        ViewController viewController = Controller.getCurrentController().getViewController();
        int returnVal = chooser.showOpenDialog(viewController.getContentPane());
        if (returnVal == 0) {
            File folder = chooser.getSelectedFile();
            viewController.out("Importing folder structure ...");
            try {
                this.importFolderStructure(folder, Controller.getCurrentModeController().getMapController().getSelectedNode(), true);
            }
            catch (Exception ex) {
                LogUtils.severe(ex);
            }
            viewController.out("Folder structure imported.");
        }
    }

    private NodeModel addNode(NodeModel target, String nodeContent, String link) {
        NodeModel node = ((MMapController)Controller.getCurrentModeController().getMapController()).addNewNode(target, target.getChildCount(), target.isNewChildLeft());
        ((MTextController)TextController.getController()).setNodeText(node, nodeContent);
        ((MLinkController)LinkController.getController()).setLink(node, link, 0);
        return node;
    }

    public void importFolderStructure(File folder, NodeModel target, boolean redisplay) throws MalformedURLException {
        int i;
        File[] list = folder.listFiles();
        if (list == null) {
            return;
        }
        for (i = 0; i < list.length; ++i) {
            if (!list[i].isDirectory()) continue;
            NodeModel node = this.addNode(target, list[i].getName(), list[i].toURI().toString());
            this.importFolderStructure(list[i], node, false);
        }
        for (i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) continue;
            this.addNode(target, list[i].getName(), list[i].toURI().toString());
        }
        Controller.getCurrentModeController().getMapController().setFolded(target, true);
    }
}

