/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JFileChooser;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;

class ImportExplorerFavoritesAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public ImportExplorerFavoritesAction() {
        super("ImportExplorerFavoritesAction");
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(TextUtils.getText("select_favorites_folder"));
        int returnVal = chooser.showOpenDialog(Controller.getCurrentController().getViewController().getContentPane());
        if (returnVal == 0) {
            File folder = chooser.getSelectedFile();
            Controller.getCurrentController().getViewController().out("Importing Favorites ...");
            this.importExplorerFavorites(folder, Controller.getCurrentModeController().getMapController().getSelectedNode(), true);
            Controller.getCurrentController().getViewController().out("Favorites imported.");
        }
    }

    private NodeModel addNode(NodeModel target, String nodeContent) {
        NodeModel node = ((MMapController)Controller.getCurrentModeController().getMapController()).addNewNode(target, target.getChildCount(), target.isNewChildLeft());
        ((MTextController)TextController.getController()).setNodeText(node, nodeContent);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importExplorerFavorites(File folder, NodeModel target, boolean redisplay) {
        boolean favoritesFound = false;
        if (folder.isDirectory()) {
            NodeModel node;
            int i;
            File[] list = folder.listFiles();
            for (i = 0; i < list.length; ++i) {
                if (!list[i].isDirectory()) continue;
                String nodeContent = list[i].getName();
                node = this.addNode(target, nodeContent);
                boolean favoritesFoundInSubfolder = this.importExplorerFavorites(list[i], node, false);
                if (favoritesFoundInSubfolder) {
                    favoritesFound = true;
                    continue;
                }
                ((MMapController)Controller.getCurrentModeController().getMapController()).deleteNode(node);
            }
            block12: for (i = 0; i < list.length; ++i) {
                if (list[i].isDirectory() || !FileUtils.getExtension(list[i]).equals("url")) continue;
                favoritesFound = true;
                BufferedReader in = null;
                try {
                    node = this.addNode(target, FileUtils.removeExtension(list[i].getName()));
                    in = new BufferedReader(new FileReader(list[i]));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        if (!line.startsWith("URL=")) continue;
                        String link = line.substring(4);
                        ((MLinkController)LinkController.getController()).setLink(node, LinkController.createURI(link), 0);
                        continue block12;
                    }
                    continue;
                }
                catch (Exception e) {
                    LogUtils.severe(e);
                    continue;
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        LogUtils.warn(e);
                    }
                }
            }
        }
        if (redisplay) {
            Controller.getCurrentModeController().getMapController().nodeChanged(target);
        }
        return favoritesFound;
    }
}

