/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;

class ImportBranchAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public ImportBranchAction() {
        super("ImportBranchAction");
    }

    public void actionPerformed(ActionEvent e) {
        int returnVal;
        NodeModel parent = Controller.getCurrentModeController().getMapController().getSelectedNode();
        if (parent == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        FileFilter fileFilter = ((MFileManager)UrlManager.getController()).getFileFilter();
        if (fileFilter != null) {
            chooser.addChoosableFileFilter(fileFilter);
        }
        if ((returnVal = chooser.showOpenDialog(Controller.getCurrentController().getViewController().getContentPane())) == 0) {
            try {
                MapModel map = parent.getMap();
                URL url = map.getURL();
                NodeModel node = ((MFileManager)UrlManager.getController()).loadTree(map, chooser.getSelectedFile());
                map.setURL(url);
                PersistentNodeHook.removeMapExtensions(node);
                ((MMapController)Controller.getCurrentModeController().getMapController()).insertNode(node, parent);
            }
            catch (Exception ex) {
                UrlManager.getController().handleLoadingException(ex);
            }
        }
    }
}

