/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.url.mindmapmode.MFileManager;

class FileRevisionsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String ALL_KEY_BASE = "FileRevisionsDialog";
    private static final String AUTOSAVE_KEY_BASE = "NewerFileRevisionsFoundDialog";
    private String keyBase;
    private JButton btnRestore;
    private JButton btnSkip;
    private boolean cancelled;
    private final File file;
    private File selectedFile;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat();
    private final NumberFormat fileSizeFormat = NumberFormat.getIntegerInstance();

    public FileRevisionsDialog(File file, File[] revisions, MFileManager.AlternativeFileMode mode) {
        super(UITools.getFrame(), true);
        if (mode == MFileManager.AlternativeFileMode.ALL) {
            this.keyBase = ALL_KEY_BASE;
        } else if (mode == MFileManager.AlternativeFileMode.AUTOSAVE) {
            this.keyBase = AUTOSAVE_KEY_BASE;
        }
        this.setTitle(TextUtils.getText(this.key("title")));
        UITools.backOtherWindows();
        this.selectedFile = this.file = file;
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(0);
        UITools.addEscapeActionToDialog(this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        final JTable table = this.createTable(revisions);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.getViewport().setBackground(Color.white);
        Dimension tablePreferredSize = table.getPreferredSize();
        int maxHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() * 2 / 3;
        scrollPane.getViewport().setPreferredSize(new Dimension(tablePreferredSize.width, Math.min(maxHeight, tablePreferredSize.height)));
        this.add(scrollPane);
        this.add(this.createQuestion());
        this.add(this.createButtonBar());
        this.getRootPane().setDefaultButton(this.btnRestore);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(38, 0), "up");
        this.getRootPane().getActionMap().put("up", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int newSelectedRow = table.getSelectedRow() - 1;
                if (newSelectedRow >= 0) {
                    table.setRowSelectionInterval(newSelectedRow, newSelectedRow);
                }
            }
        });
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(40, 0), "down");
        this.getRootPane().getActionMap().put("down", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int newSelectedRow = table.getSelectedRow() + 1;
                if (newSelectedRow < table.getRowCount()) {
                    table.setRowSelectionInterval(newSelectedRow, newSelectedRow);
                }
            }
        });
        this.pack();
        UITools.showFrame();
        this.setLocationRelativeTo(UITools.getFrame());
        this.setVisible(true);
    }

    private Component createQuestion() {
        String text = TextUtils.format(this.key("question"), this.file.getName());
        String html = HtmlUtils.plainToHTML(text);
        JLabel textArea = new JLabel(html);
        textArea.setAlignmentX(0.5f);
        textArea.setFont(new Font("Dialog", 1, 12));
        textArea.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        return textArea;
    }

    private String key(String appendix) {
        return this.keyBase + "." + appendix;
    }

    private JTable createTable(File[] revisions) {
        TreeSet<File> sortedRevisions = new TreeSet<File>(new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                long diff = f1.lastModified() - f2.lastModified();
                if (diff == 0L) {
                    return f1.getName().compareTo(f2.getName());
                }
                return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
            }
        });
        sortedRevisions.add(this.file);
        sortedRevisions.addAll(Arrays.asList(revisions));
        Object[][] data = new Object[sortedRevisions.size()][];
        int i = 0;
        int selectedRow = 0;
        for (File f : sortedRevisions) {
            data[i] = this.createRow(f);
            if (f == this.file) {
                selectedRow = i;
            }
            ++i;
        }
        RevisionTable revisionTable = new RevisionTable(data, selectedRow);
        return revisionTable;
    }

    private Object[] createRow(File file) {
        return new Object[]{new FileWrapper(file), this.fileSizeFormat.format(file.length()), this.dateFormat.format(file.lastModified())};
    }

    private Box createButtonBar() {
        Box controllerBox = Box.createHorizontalBox();
        controllerBox.setBorder(new EmptyBorder(5, 0, 5, 0));
        CloseAction closeAction = new CloseAction();
        controllerBox.add(Box.createHorizontalGlue());
        this.btnSkip = this.createButton(this.key("cancel"), null, closeAction);
        this.btnRestore = this.createButton(this.key("open"), this.key("open.tooltip"), closeAction);
        controllerBox.add(this.btnRestore);
        controllerBox.add(Box.createHorizontalStrut(10));
        controllerBox.add(this.btnSkip);
        controllerBox.add(Box.createHorizontalStrut(10));
        return controllerBox;
    }

    private JButton createButton(String key, String tooltipKey, ActionListener closeAction) {
        String selectedFileName;
        JButton button = new JButton();
        MenuBuilder.setLabelAndMnemonic(button, TextUtils.getRawText(key));
        button.addActionListener(closeAction);
        button.setMaximumSize(new Dimension(1000, 1000));
        String string = selectedFileName = this.getSelectedFile() == null ? null : this.getSelectedFile().getName();
        if (tooltipKey != null) {
            button.setToolTipText(TextUtils.format(tooltipKey, this.file.getName(), selectedFileName));
        }
        return button;
    }

    public File getSelectedFile() {
        if (this.cancelled) {
            return null;
        }
        return this.selectedFile;
    }

    private void setSelectedFile(File selectedFile) {
        this.selectedFile = selectedFile;
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            FileRevisionsDialog.this.cancelled = source == FileRevisionsDialog.this.btnSkip;
            FileRevisionsDialog.this.dispose();
        }
    }

    private class RevisionTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        private final DefaultTableCellRenderer renderer;

        public RevisionTable(Object[][] data, int selectedRow) {
            super(data, new Object[]{TextUtils.getText(FileRevisionsDialog.this.key("file_name")), TextUtils.getText(FileRevisionsDialog.this.key("file_size")), TextUtils.getText(FileRevisionsDialog.this.key("file_last_modified"))});
            this.renderer = new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (this.containsOriginalFile(table, row)) {
                        c.setFont(this.getFont().deriveFont(1));
                    }
                    return c;
                }

                private boolean containsOriginalFile(JTable table, int row) {
                    FileWrapper fileHolder = (FileWrapper)table.getValueAt(row, 0);
                    return fileHolder.getFile().equals(FileRevisionsDialog.this.file);
                }
            };
            int width = Toolkit.getDefaultToolkit().getScreenSize().width * 2 / 3;
            this.getColumnModel().getColumn(0).setPreferredWidth((int)((double)width * 0.7));
            this.getColumnModel().getColumn(1).setPreferredWidth((int)((double)width * 0.1));
            this.getColumnModel().getColumn(2).setPreferredWidth((int)((double)width * 0.2));
            this.setRowHeight(20);
            this.setRowSelectionAllowed(true);
            this.setFocusable(false);
            this.setDefaultRenderer(Object.class, this.renderer);
            this.setSelectionMode(0);
            this.setRowSelectionInterval(selectedRow, selectedRow);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent event) {
                    if (!event.getValueIsAdjusting()) {
                        boolean enable;
                        ListSelectionModel lsm = (ListSelectionModel)event.getSource();
                        boolean bl = enable = !lsm.isSelectionEmpty();
                        if (enable) {
                            FileWrapper fileWrapper = (FileWrapper)RevisionTable.this.getModel().getValueAt(RevisionTable.this.getSelectedRow(), 0);
                            if (FileRevisionsDialog.this.file.equals(fileWrapper.getFile())) {
                                RevisionTable.this.setButtonOpenDefault();
                            } else {
                                RevisionTable.this.setButtonOpenRestore(fileWrapper);
                            }
                            FileRevisionsDialog.this.setSelectedFile(fileWrapper.getFile());
                        } else {
                            RevisionTable.this.setButtonOpenDefault();
                        }
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() >= 2) {
                        FileWrapper fileWrapper = (FileWrapper)RevisionTable.this.getModel().getValueAt(RevisionTable.this.getSelectedRow(), 0);
                        FileRevisionsDialog.this.setSelectedFile(fileWrapper.getFile());
                        if (fileWrapper != null) {
                            FileRevisionsDialog.this.btnRestore.doClick();
                        }
                    }
                }
            });
        }

        private void setButtonOpenDefault() {
            MenuBuilder.setLabelAndMnemonic(FileRevisionsDialog.this.btnRestore, TextUtils.getRawText(FileRevisionsDialog.this.key("open")));
            FileRevisionsDialog.this.btnRestore.setToolTipText(TextUtils.format(FileRevisionsDialog.this.key("open.tooltip"), new Object[0]));
        }

        private void setButtonOpenRestore(FileWrapper fileWrapper) {
            MenuBuilder.setLabelAndMnemonic(FileRevisionsDialog.this.btnRestore, TextUtils.getRawText(FileRevisionsDialog.this.key("restore")));
            FileRevisionsDialog.this.btnRestore.setToolTipText(TextUtils.format(FileRevisionsDialog.this.key("restore.tooltip"), FileRevisionsDialog.this.file.getName(), fileWrapper.toString()));
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    public static class FileWrapper {
        private final File file;

        public FileWrapper(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public String toString() {
            return this.file.getName();
        }
    }
}

