/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.MindMapNodesSelection;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class FileOpener
implements DropTargetListener {
    private static final Pattern filePattern = Pattern.compile("file://[^\\s" + File.pathSeparatorChar + "]+");

    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.isDragAcceptable(dtde)) {
            dtde.rejectDrag();
            return;
        }
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    public void drop(DropTargetDropEvent dtde) {
        if (!this.isDropAcceptable(dtde)) {
            dtde.rejectDrop();
            return;
        }
        dtde.acceptDrop(1);
        try {
            Transferable transferable = dtde.getTransferable();
            Controller.getCurrentController().selectMode("MindMap");
            ModeController modeController = Controller.getCurrentModeController();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : list) {
                    String fileName = file.getName();
                    if (file.isDirectory() || !this.isMindMapUrl(fileName)) continue;
                    modeController.getMapController().newMap(Compat.fileToUrl(file));
                }
            }
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String urls = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (urls.startsWith("file:")) {
                    Matcher matcher = filePattern.matcher(urls);
                    while (matcher.find()) {
                        String urlString = matcher.group();
                        if (!this.isMindMapUrl(urlString)) continue;
                        try {
                            URI uri = new URI(urlString);
                            URL url = new URL(uri.getScheme(), uri.getHost(), uri.getPath());
                            File file = Compat.urlToFile(url);
                            if (!file.exists() || file.isDirectory()) continue;
                            modeController.getMapController().newMap(url);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (urls.startsWith("http://") && this.isMindMapUrl(urls)) {
                    URL url = new URL(urls);
                    modeController.getMapController().newMap(url);
                }
            }
        }
        catch (Exception e) {
            UITools.errorMessage(TextUtils.format("dropped_file_error", e.getMessage()));
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
    }

    private boolean isMindMapUrl(String urlString) {
        return urlString.substring(urlString.length() - 3).equalsIgnoreCase(".mm");
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private boolean isDragAcceptable(DropTargetDragEvent event) {
        return event.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || !event.isDataFlavorSupported(MindMapNodesSelection.mindMapNodesFlavor) && event.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    private boolean isDropAcceptable(DropTargetDropEvent event) {
        return event.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || event.isDataFlavorSupported(DataFlavor.stringFlavor);
    }
}

